/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.event.BeanPersistListener;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ChainedBeanPersistListener
implements BeanPersistListener {
    private final List<BeanPersistListener> list;
    private final BeanPersistListener[] chain;

    public ChainedBeanPersistListener(BeanPersistListener c1, BeanPersistListener c2) {
        this(ChainedBeanPersistListener.addList(c1, c2));
    }

    protected int size() {
        return this.chain.length;
    }

    @Override
    public boolean isRegisterFor(Class<?> cls) {
        return false;
    }

    private static List<BeanPersistListener> addList(BeanPersistListener c1, BeanPersistListener c2) {
        ArrayList<BeanPersistListener> addList = new ArrayList<BeanPersistListener>(2);
        addList.add(c1);
        addList.add(c2);
        return addList;
    }

    public ChainedBeanPersistListener(List<BeanPersistListener> list) {
        this.list = list;
        this.chain = list.toArray(new BeanPersistListener[list.size()]);
    }

    public ChainedBeanPersistListener register(BeanPersistListener c) {
        if (this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPersistListener> newList = new ArrayList<BeanPersistListener>();
        newList.addAll(this.list);
        newList.add(c);
        return new ChainedBeanPersistListener(newList);
    }

    public ChainedBeanPersistListener deregister(BeanPersistListener c) {
        if (!this.list.contains(c)) {
            return this;
        }
        ArrayList<BeanPersistListener> newList = new ArrayList<BeanPersistListener>();
        newList.addAll(this.list);
        newList.remove(c);
        return new ChainedBeanPersistListener(newList);
    }

    @Override
    public void deleted(Object bean) {
        for (int i = 0; i < this.chain.length; ++i) {
            this.chain[i].deleted(bean);
        }
    }

    @Override
    public void inserted(Object bean) {
        for (int i = 0; i < this.chain.length; ++i) {
            this.chain[i].inserted(bean);
        }
    }

    @Override
    public void updated(Object bean, Set<String> updatedProperties) {
        for (int i = 0; i < this.chain.length; ++i) {
            this.chain[i].updated(bean, updatedProperties);
        }
    }
}

