/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyCompoundScalar;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanProperty;
import com.avaje.ebeaninternal.server.properties.BeanPropertySetter;
import com.avaje.ebeaninternal.server.type.CtCompoundProperty;
import java.util.ArrayList;
import java.util.List;

public class BeanPropertyCompoundRoot {
    private final BeanPropertySetter setter;
    private final String name;
    private final String fullBeanName;
    private final ArrayList<BeanPropertyCompoundScalar> propList;
    private List<CtCompoundProperty> nonScalarProperties;

    public BeanPropertyCompoundRoot(DeployBeanProperty deploy) {
        this.fullBeanName = deploy.getFullBeanName();
        this.name = deploy.getName();
        this.setter = deploy.getSetter();
        this.propList = new ArrayList();
    }

    public BeanProperty[] getScalarProperties() {
        return this.propList.toArray(new BeanProperty[this.propList.size()]);
    }

    public void register(BeanPropertyCompoundScalar prop) {
        this.propList.add(prop);
    }

    public List<CtCompoundProperty> getNonScalarProperties() {
        return this.nonScalarProperties;
    }

    public void setNonScalarProperties(List<CtCompoundProperty> nonScalarProperties) {
        this.nonScalarProperties = nonScalarProperties;
    }

    public void setRootValue(EntityBean bean, Object value) {
        try {
            this.setter.set(bean, value);
        }
        catch (Exception ex) {
            String beanType = bean == null ? "null" : bean.getClass().getName();
            String msg = "set " + this.name + " with arg[" + value + "] on [" + this.fullBeanName + "] with type[" + beanType + "] threw error";
            throw new RuntimeException(msg, ex);
        }
    }

    public void setRootValueIntercept(EntityBean bean, Object value) {
        try {
            this.setter.setIntercept(bean, value);
        }
        catch (Exception ex) {
            String beanType = bean == null ? "null" : bean.getClass().getName();
            String msg = "setIntercept " + this.name + " arg[" + value + "] on [" + this.fullBeanName + "] with type[" + beanType + "] threw error";
            throw new RuntimeException(msg, ex);
        }
    }
}

