/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.Expression;
import com.avaje.ebean.Query;
import com.avaje.ebean.SqlUpdate;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.BeanCollectionAdd;
import com.avaje.ebean.bean.BeanCollectionLoader;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.text.PathProperties;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.DefaultSqlUpdate;
import com.avaje.ebeaninternal.server.deploy.BeanCollectionHelp;
import com.avaje.ebeaninternal.server.deploy.BeanCollectionHelpFactory;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssoc;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocManyJsonHelp;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.DbReadContext;
import com.avaje.ebeaninternal.server.deploy.DbSqlContext;
import com.avaje.ebeaninternal.server.deploy.ExportedProperty;
import com.avaje.ebeaninternal.server.deploy.IntersectionRow;
import com.avaje.ebeaninternal.server.deploy.ManyType;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.deploy.TableJoinColumn;
import com.avaje.ebeaninternal.server.deploy.id.ImportedId;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.el.ElPropertyChainBuilder;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.query.SqlBeanLoad;
import com.avaje.ebeaninternal.server.text.json.ReadJson;
import com.avaje.ebeaninternal.server.text.json.WriteJson;
import java.io.IOException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanPropertyAssocMany<T>
extends BeanPropertyAssoc<T> {
    private static final Logger logger = LoggerFactory.getLogger(BeanPropertyAssocMany.class);
    private final BeanPropertyAssocManyJsonHelp jsonHelp;
    private final TableJoin intersectionJoin;
    private final String intersectionPublishTable;
    private final String intersectionDraftTable;
    private final TableJoin inverseJoin;
    private final boolean unidirectional;
    private final boolean manyToMany;
    private final String fetchOrderBy;
    private String lazyFetchOrderBy;
    private final String mapKey;
    private final ManyType manyType;
    private final BeanCollection.ModifyListenMode modifyListenMode;
    private BeanProperty mapKeyProperty;
    private String exportedPropertyBindProto = "?";
    protected BeanPropertyAssocOne<?> childMasterProperty;
    private String childMasterIdProperty;
    private boolean embeddedExportedProperties;
    private BeanCollectionHelp<T> help;
    private ImportedId importedId;
    private String deleteByParentIdSql;
    private String deleteByParentIdInSql;

    public BeanPropertyAssocMany(BeanDescriptor<?> descriptor, DeployBeanPropertyAssocMany<T> deploy) {
        super(descriptor, deploy);
        this.unidirectional = deploy.isUnidirectional();
        this.manyToMany = deploy.isManyToMany();
        this.manyType = deploy.getManyType();
        this.mapKey = deploy.getMapKey();
        this.fetchOrderBy = deploy.getFetchOrderBy();
        this.intersectionJoin = deploy.createIntersectionTableJoin();
        if (this.intersectionJoin != null) {
            this.intersectionPublishTable = this.intersectionJoin.getTable();
            this.intersectionDraftTable = deploy.getIntersectionDraftTable();
        } else {
            this.intersectionPublishTable = null;
            this.intersectionDraftTable = null;
        }
        this.inverseJoin = deploy.createInverseTableJoin();
        this.modifyListenMode = deploy.getModifyListenMode();
        this.jsonHelp = new BeanPropertyAssocManyJsonHelp(this);
    }

    @Override
    public void initialise() {
        super.initialise();
        if (!this.isTransient) {
            this.help = BeanCollectionHelpFactory.create(this);
            if (this.manyToMany) {
                this.importedId = this.createImportedId(this, this.targetDescriptor, this.tableJoin);
            } else {
                this.childMasterProperty = this.initChildMasterProperty();
                if (this.childMasterProperty != null) {
                    this.childMasterProperty.setRelationshipProperty(this);
                }
            }
            if (this.mapKey != null) {
                this.mapKeyProperty = this.initMapKeyProperty();
            }
            this.exportedProperties = this.createExported();
            if (this.exportedProperties.length > 0) {
                this.embeddedExportedProperties = this.exportedProperties[0].isEmbedded();
                this.exportedPropertyBindProto = this.deriveExportedPropertyBindProto();
                if (this.fetchOrderBy != null) {
                    StringBuilder sb = new StringBuilder(50);
                    for (int i = 0; i < this.exportedProperties.length; ++i) {
                        if (i > 0) {
                            sb.append(", ");
                        }
                        String fkTableAlias = this.isManyToMany() ? "int_" : "t0";
                        sb.append(fkTableAlias).append(".").append(this.exportedProperties[i].getForeignDbColumn());
                    }
                    sb.append(", ").append(this.fetchOrderBy);
                    this.lazyFetchOrderBy = sb.toString().trim();
                }
            }
            String delStmt = this.manyToMany ? "delete from " + this.inverseJoin.getTable() + " where " : "delete from " + this.targetDescriptor.getBaseTable() + " where ";
            this.deleteByParentIdSql = delStmt + this.deriveWhereParentIdSql(false, "");
            this.deleteByParentIdInSql = delStmt + this.deriveWhereParentIdSql(true, "");
        }
    }

    public void initialisePostTarget() {
        if (this.childMasterProperty != null) {
            BeanProperty masterId = this.childMasterProperty.getTargetDescriptor().getIdProperty();
            this.childMasterIdProperty = this.childMasterProperty.getName() + "." + masterId.getName();
        }
    }

    @Override
    protected void docStoreIncludeByDefault(PathProperties pathProps) {
    }

    @Override
    public void merge(EntityBean bean, EntityBean existing) {
        BeanCollection fromBC;
        Object fromCollection;
        BeanCollection toBC;
        Object existingCollection = this.getVal(existing);
        if (existingCollection instanceof BeanCollection && !(toBC = (BeanCollection)existingCollection).isPopulated() && (fromCollection = this.getVal(bean)) instanceof BeanCollection && (fromBC = (BeanCollection)fromCollection).isPopulated()) {
            toBC.loadFrom(fromBC);
        }
    }

    public void addBeanToCollectionWithCreate(EntityBean parentBean, EntityBean detailBean, boolean withCheck) {
        BeanCollection<T> bc = (BeanCollection<T>)super.getValue(parentBean);
        if (bc == null) {
            bc = this.help.createEmpty(parentBean);
            this.setValue(parentBean, bc);
        }
        this.help.add(bc, detailBean, withCheck);
    }

    public boolean isSkipSaveBeanCollection(EntityBean bean, boolean insertedParent) {
        Object val = this.getValue(bean);
        if (val == null) {
            return true;
        }
        if (val instanceof BeanCollection) {
            return ((BeanCollection)val).isSkipSave();
        }
        if (insertedParent) {
            if (val instanceof Collection) {
                return ((Collection)val).isEmpty();
            }
            if (val instanceof Map) {
                return ((Map)val).isEmpty();
            }
        }
        return false;
    }

    public void resetMany(EntityBean bean) {
        Object value = this.getValue(bean);
        if (value instanceof BeanCollection) {
            ((BeanCollection)value).reset(bean, this.name);
        } else {
            this.createReference(bean);
        }
    }

    @Override
    public ElPropertyValue buildElPropertyValue(String propName, String remainder, ElPropertyChainBuilder chain, boolean propertyDeploy) {
        return this.createElPropertyValue(propName, remainder, chain, propertyDeploy);
    }

    @Override
    public void buildRawSqlSelectChain(String prefix, List<String> selectChain) {
    }

    public SqlUpdate deleteByParentId(Object parentId, List<Object> parentIdist) {
        if (parentId != null) {
            return this.deleteByParentId(parentId);
        }
        return this.deleteByParentIdList(parentIdist);
    }

    private SqlUpdate deleteByParentId(Object parentId) {
        DefaultSqlUpdate sqlDelete = new DefaultSqlUpdate(this.deleteByParentIdSql);
        this.bindWhereParendId(sqlDelete, parentId);
        return sqlDelete;
    }

    public List<Object> findIdsByParentId(Object parentId, List<Object> parentIdList, Transaction t, ArrayList<Object> excludeDetailIds) {
        if (parentId != null) {
            return this.findIdsByParentId(parentId, t, excludeDetailIds);
        }
        return this.findIdsByParentIdList(parentIdList, t, excludeDetailIds);
    }

    private List<Object> findIdsByParentId(Object parentId, Transaction t, ArrayList<Object> excludeDetailIds) {
        String rawWhere = this.deriveWhereParentIdSql(false, "");
        ArrayList<Object> bindValues = new ArrayList<Object>();
        this.bindWhereParentId(bindValues, parentId);
        SpiEbeanServer server = this.getBeanDescriptor().getEbeanServer();
        Query<?> q = server.find(this.getPropertyType()).where().raw(rawWhere, bindValues.toArray()).query();
        if (excludeDetailIds != null && !excludeDetailIds.isEmpty()) {
            Expression idIn = q.getExpressionFactory().idIn(excludeDetailIds);
            q.where().not(idIn);
        }
        return server.findIds(q, t);
    }

    @Override
    public boolean isCacheDataInclude() {
        return false;
    }

    public void lazyLoadMany(EntityBean current) {
        EntityBean parentBean = this.childMasterProperty.getValueAsEntityBean(current);
        if (parentBean != null) {
            this.addBeanToCollectionWithCreate(parentBean, current, true);
        }
    }

    public void addWhereParentIdIn(SpiQuery<?> query, List<Object> parentIds, boolean useDocStore) {
        if (useDocStore) {
            query.where().in(this.childMasterIdProperty, parentIds);
        } else {
            this.addWhereParentIdIn(query, parentIds);
        }
    }

    private void addWhereParentIdIn(SpiQuery<?> query, List<Object> parentIds) {
        String tableAlias;
        String string = tableAlias = this.manyToMany ? "int_." : "t0.";
        if (this.manyToMany) {
            query.setM2MIncludeJoin(this.inverseJoin);
        }
        String rawWhere = this.deriveWhereParentIdSql(true, tableAlias);
        String expr = this.descriptor.getParentIdInExpr(parentIds.size(), rawWhere);
        List<Object> bindValues = this.getBindParentIds(parentIds);
        query.where().raw(expr, bindValues.toArray());
    }

    private List<Object> findIdsByParentIdList(List<Object> parentIdList, Transaction t, ArrayList<Object> excludeDetailIds) {
        String rawWhere = this.deriveWhereParentIdSql(true, "");
        String inClause = this.buildInClauseBinding(parentIdList.size(), this.exportedPropertyBindProto);
        String expr = rawWhere + inClause;
        ArrayList<Object> bindValues = new ArrayList<Object>();
        for (int i = 0; i < parentIdList.size(); ++i) {
            this.bindWhereParentId(bindValues, parentIdList.get(i));
        }
        SpiEbeanServer server = this.getBeanDescriptor().getEbeanServer();
        Query<?> q = server.find(this.getPropertyType()).where().raw(expr, bindValues.toArray()).query();
        if (excludeDetailIds != null && !excludeDetailIds.isEmpty()) {
            Expression idIn = q.getExpressionFactory().idIn(excludeDetailIds);
            q.where().not(idIn);
        }
        return server.findIds(q, t);
    }

    private SqlUpdate deleteByParentIdList(List<Object> parentIdist) {
        StringBuilder sb = new StringBuilder(100);
        sb.append(this.deleteByParentIdInSql);
        String inClause = this.buildInClauseBinding(parentIdist.size(), this.exportedPropertyBindProto);
        sb.append(inClause);
        DefaultSqlUpdate delete = new DefaultSqlUpdate(sb.toString());
        for (int i = 0; i < parentIdist.size(); ++i) {
            this.bindWhereParendId(delete, parentIdist.get(i));
        }
        return delete;
    }

    private String deriveExportedPropertyBindProto() {
        if (this.exportedProperties.length == 1) {
            return "?";
        }
        StringBuilder sb = new StringBuilder();
        sb.append("(");
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append("?");
        }
        sb.append(")");
        return sb.toString();
    }

    private String buildInClauseBinding(int size, String bindProto) {
        StringBuilder sb = new StringBuilder(10 + size * (bindProto.length() + 1));
        sb.append(" in");
        sb.append(" (");
        for (int i = 0; i < size; ++i) {
            if (i > 0) {
                sb.append(",");
            }
            sb.append(bindProto);
        }
        sb.append(") ");
        return sb.toString();
    }

    public void setLoader(BeanCollectionLoader loader) {
        if (this.help != null) {
            this.help.setLoader(loader);
        }
    }

    public BeanCollection.ModifyListenMode getModifyListenMode() {
        return this.modifyListenMode;
    }

    @Override
    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
    }

    @Override
    public void loadIgnore(DbReadContext ctx) {
    }

    @Override
    public void load(SqlBeanLoad sqlBeanLoad) {
    }

    @Override
    public Object readSet(DbReadContext ctx, EntityBean bean) throws SQLException {
        return null;
    }

    @Override
    public Object read(DbReadContext ctx) throws SQLException {
        return null;
    }

    public void add(BeanCollection<?> collection, EntityBean bean) {
        this.help.add(collection, bean, false);
    }

    @Override
    public String getAssocIsEmpty(SpiExpressionRequest request, String path) {
        StringBuilder sb = new StringBuilder();
        SpiQuery<?> query = request.getQueryRequest().getQuery();
        if (this.manyToMany) {
            sb.append(query.isAsDraft() ? this.intersectionDraftTable : this.intersectionPublishTable);
        } else {
            sb.append(this.targetDescriptor.getBaseTable(query.getTemporalMode()));
        }
        sb.append(" where ");
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            if (i > 0) {
                sb.append(" and ");
            }
            this.exportedProperties[i].appendWhere(sb, path);
        }
        return sb.toString();
    }

    @Override
    public Object[] getAssocIdValues(EntityBean bean) {
        return this.targetDescriptor.getIdBinder().getIdValues(bean);
    }

    @Override
    public String getAssocIdExpression(String prefix, String operator) {
        return this.targetDescriptor.getIdBinder().getAssocOneIdExpr(prefix, operator);
    }

    @Override
    public String getAssocIdInValueExpr(int size) {
        return this.targetDescriptor.getIdBinder().getIdInValueExpr(size);
    }

    @Override
    public String getAssocIdInExpr(String prefix) {
        return this.targetDescriptor.getIdBinder().getAssocIdInExpr(prefix);
    }

    @Override
    public boolean isMany() {
        return true;
    }

    @Override
    public boolean isAssocMany() {
        return true;
    }

    @Override
    public boolean isAssocId() {
        return true;
    }

    @Override
    public boolean isAssocProperty() {
        return true;
    }

    @Override
    public boolean containsMany() {
        return true;
    }

    public ManyType getManyType() {
        return this.manyType;
    }

    public boolean isManyToMany() {
        return this.manyToMany;
    }

    public TableJoin getIntersectionTableJoin() {
        return this.intersectionJoin;
    }

    public void setJoinValuesToChild(EntityBean parent, EntityBean child, Object mapKeyValue) {
        if (this.mapKeyProperty != null) {
            this.mapKeyProperty.setValue(child, mapKeyValue);
        }
        if (!this.manyToMany && this.childMasterProperty != null) {
            this.childMasterProperty.setValue(child, parent);
        }
    }

    public String getFetchOrderBy() {
        return this.fetchOrderBy;
    }

    public String getLazyFetchOrderBy() {
        return this.lazyFetchOrderBy;
    }

    public String getMapKey() {
        return this.mapKey;
    }

    public BeanCollection<?> createReferenceIfNull(EntityBean parentBean) {
        Object v = this.getValue(parentBean);
        if (v instanceof BeanCollection) {
            BeanCollection bc = (BeanCollection)v;
            return bc.isReference() ? bc : null;
        }
        if (v != null) {
            return null;
        }
        return this.createReference(parentBean);
    }

    public BeanCollection<?> createReference(EntityBean parentBean) {
        BeanCollection<T> ref = this.help.createReference(parentBean);
        this.setValue(parentBean, ref);
        return ref;
    }

    public BeanCollection<T> createEmpty(EntityBean parentBean) {
        return this.help.createEmpty(parentBean);
    }

    public BeanCollectionAdd getBeanCollectionAdd(Object bc, String mapKey) {
        return this.help.getBeanCollectionAdd(bc, mapKey);
    }

    public Object getParentId(EntityBean parentBean) {
        return this.descriptor.getId(parentBean);
    }

    public List<Object> getBindParentIds(List<Object> parentIds) {
        if (this.exportedProperties.length == 1) {
            return parentIds;
        }
        ArrayList<Object> expandedList = new ArrayList<Object>(parentIds.size() * this.exportedProperties.length);
        for (int i = 0; i < parentIds.size(); ++i) {
            for (int y = 0; y < this.exportedProperties.length; ++y) {
                Object compId = parentIds.get(i);
                expandedList.add(this.exportedProperties[y].getValue((EntityBean)compId));
            }
        }
        return expandedList;
    }

    private void bindWhereParendId(DefaultSqlUpdate sqlUpd, Object parentId) {
        if (this.exportedProperties.length == 1) {
            sqlUpd.addParameter(parentId);
            return;
        }
        EntityBean parent = (EntityBean)parentId;
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            Object embVal = this.exportedProperties[i].getValue(parent);
            sqlUpd.addParameter(embVal);
        }
    }

    public void addSelectExported(DbSqlContext ctx, String tableAlias) {
        String alias;
        String string = alias = this.manyToMany ? "int_" : tableAlias;
        if (alias == null) {
            alias = "t0";
        }
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            ctx.appendColumn(alias, this.exportedProperties[i].getForeignDbColumn());
        }
    }

    private String deriveWhereParentIdSql(boolean inClause, String tableAlias) {
        StringBuilder sb = new StringBuilder();
        if (inClause) {
            sb.append("(");
        }
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            String fkColumn = this.exportedProperties[i].getForeignDbColumn();
            if (i > 0) {
                String s = inClause ? "," : " and ";
                sb.append(s);
            }
            sb.append(tableAlias).append(fkColumn);
            if (inClause) continue;
            sb.append("=? ");
        }
        if (inClause) {
            sb.append(")");
        }
        return sb.toString();
    }

    private ExportedProperty[] createExported() {
        BeanProperty idProp = this.descriptor.getIdProperty();
        ArrayList<ExportedProperty> list = new ArrayList<ExportedProperty>();
        if (idProp != null && idProp.isEmbedded()) {
            BeanPropertyAssocOne one = (BeanPropertyAssocOne)idProp;
            BeanDescriptor targetDesc = one.getTargetDescriptor();
            BeanProperty[] emIds = targetDesc.propertiesBaseScalar();
            try {
                for (int i = 0; i < emIds.length; ++i) {
                    ExportedProperty expProp = this.findMatch(true, emIds[i]);
                    list.add(expProp);
                }
            }
            catch (PersistenceException e) {
                logger.error("Could not find a exported property?", (Throwable)e);
            }
        } else if (idProp != null) {
            ExportedProperty expProp = this.findMatch(false, idProp);
            list.add(expProp);
        }
        return list.toArray(new ExportedProperty[list.size()]);
    }

    private ExportedProperty findMatch(boolean embedded, BeanProperty prop) {
        String searchTable;
        TableJoinColumn[] columns;
        String matchColumn = prop.getDbColumn();
        if (this.manyToMany) {
            columns = this.intersectionJoin.columns();
            searchTable = this.intersectionJoin.getTable();
        } else {
            columns = this.tableJoin.columns();
            searchTable = this.tableJoin.getTable();
        }
        for (int i = 0; i < columns.length; ++i) {
            String matchTo = columns[i].getLocalDbColumn();
            if (!matchColumn.equalsIgnoreCase(matchTo)) continue;
            String foreignCol = columns[i].getForeignDbColumn();
            return new ExportedProperty(embedded, foreignCol, prop);
        }
        String msg = "Error with the Join on [" + this.getFullBeanName() + "]. Could not find the matching foreign key for [" + matchColumn + "] in table[" + searchTable + "]?" + " Perhaps using a @JoinColumn with the name/referencedColumnName attributes swapped?";
        throw new PersistenceException(msg);
    }

    private BeanPropertyAssocOne<?> initChildMasterProperty() {
        if (this.unidirectional) {
            return null;
        }
        Class beanType = this.descriptor.getBeanType();
        BeanDescriptor targetDesc = this.getTargetDescriptor();
        BeanPropertyAssocOne<?>[] ones = targetDesc.propertiesOne();
        for (int i = 0; i < ones.length; ++i) {
            BeanPropertyAssocOne<?> prop = ones[i];
            if (!(this.mappedBy != null ? this.mappedBy.equalsIgnoreCase(prop.getName()) : prop.getTargetType().equals(beanType))) continue;
            return prop;
        }
        throw new RuntimeException("Can not find Master [" + beanType + "] in Child[" + targetDesc + "]");
    }

    private BeanProperty initMapKeyProperty() {
        BeanDescriptor targetDesc = this.getTargetDescriptor();
        for (BeanProperty prop : targetDesc.propertiesAll()) {
            if (!this.mapKey.equalsIgnoreCase(prop.getName())) continue;
            return prop;
        }
        String from = this.descriptor.getFullName();
        String to = targetDesc.getFullName();
        throw new PersistenceException(from + ": Could not find mapKey property [" + this.mapKey + "] on [" + to + "]");
    }

    public IntersectionRow buildManyDeleteChildren(EntityBean parentBean, ArrayList<Object> excludeDetailIds) {
        IntersectionRow row = new IntersectionRow(this.tableJoin.getTable(), this.targetDescriptor);
        if (excludeDetailIds != null && !excludeDetailIds.isEmpty()) {
            row.setExcludeIds(excludeDetailIds, this.getTargetDescriptor());
        }
        this.buildExport(row, parentBean);
        return row;
    }

    public IntersectionRow buildManyToManyDeleteChildren(EntityBean parentBean, boolean publish) {
        String tableName = publish ? this.intersectionPublishTable : this.intersectionDraftTable;
        IntersectionRow row = new IntersectionRow(tableName);
        this.buildExport(row, parentBean);
        return row;
    }

    public IntersectionRow buildManyToManyMapBean(EntityBean parent, EntityBean other, boolean publish) {
        String tableName = publish ? this.intersectionPublishTable : this.intersectionDraftTable;
        IntersectionRow row = new IntersectionRow(tableName);
        this.buildExport(row, parent);
        this.buildImport(row, other);
        return row;
    }

    public void registerDraftIntersectionTable(Map<String, String> draftTableMap) {
        if (this.hasDraftIntersection()) {
            draftTableMap.put(this.intersectionPublishTable, this.intersectionDraftTable);
        }
    }

    private boolean hasDraftIntersection() {
        return this.intersectionDraftTable != null && !this.intersectionDraftTable.equals(this.intersectionPublishTable);
    }

    private void buildExport(IntersectionRow row, EntityBean parentBean) {
        if (this.embeddedExportedProperties) {
            BeanProperty idProp = this.descriptor.getIdProperty();
            parentBean = (EntityBean)idProp.getValue(parentBean);
        }
        for (int i = 0; i < this.exportedProperties.length; ++i) {
            Object val = this.exportedProperties[i].getValue(parentBean);
            String fkColumn = this.exportedProperties[i].getForeignDbColumn();
            row.put(fkColumn, val);
        }
    }

    private void buildImport(IntersectionRow row, EntityBean otherBean) {
        this.importedId.buildImport(row, otherBean);
    }

    public boolean hasImportedId(EntityBean otherBean) {
        return null != this.targetDescriptor.getId(otherBean);
    }

    @Override
    public void jsonWrite(WriteJson ctx, EntityBean bean) throws IOException {
        if (!this.jsonSerialize) {
            return;
        }
        Boolean include = ctx.includeMany(this.name);
        if (Boolean.FALSE.equals(include)) {
            return;
        }
        Object value = this.getValueIntercept(bean);
        if (value != null) {
            ctx.pushParentBeanMany(bean);
            if (this.help != null) {
                this.help.jsonWrite(ctx, this.name, value, include != null);
            } else if (this.isTransient && this.targetDescriptor == null) {
                ctx.writeValueUsingObjectMapper(this.name, value);
            } else {
                Collection collection = (Collection)value;
                if (!collection.isEmpty() || ctx.isIncludeEmpty()) {
                    ctx.toJson(this.name, collection);
                }
            }
            ctx.popParentBeanMany();
        }
    }

    @Override
    public void jsonRead(ReadJson readJson, EntityBean parentBean) throws IOException {
        this.jsonHelp.jsonRead(readJson, parentBean);
    }

    public void publishMany(EntityBean draft, EntityBean live) {
        BeanCollection draftVal = (BeanCollection)this.getValueIntercept(draft);
        BeanCollection liveVal = (BeanCollection)this.getValueIntercept(live);
        Map<Object, T> liveBeansAsMap = this.liveBeansAsMap(liveVal);
        draftVal.size();
        Collection actualDetails = draftVal.getActualDetails();
        for (Object bean : actualDetails) {
            Object id = this.targetDescriptor.getId((EntityBean)bean);
            T liveBean = liveBeansAsMap.remove(id);
            if (this.isManyToMany()) {
                if (liveBean != null) continue;
                liveVal.addBean(this.targetDescriptor.createReference(Boolean.FALSE, false, id, null));
                continue;
            }
            Object newLive = this.targetDescriptor.publish(bean, liveBean);
            if (liveBean != null) continue;
            liveVal.addBean(newLive);
        }
        Collection<T> values = liveBeansAsMap.values();
        for (T value : values) {
            liveVal.removeBean(value);
        }
    }

    private Map<Object, T> liveBeansAsMap(BeanCollection<?> liveVal) {
        liveVal.size();
        Collection<?> liveBeans = liveVal.getActualDetails();
        LinkedHashMap liveMap = new LinkedHashMap();
        for (Object liveBean : liveBeans) {
            Object id = this.targetDescriptor.getId((EntityBean)liveBean);
            liveMap.put(id, liveBean);
        }
        return liveMap;
    }
}

