/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.cache.ServerCache;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.cache.CacheChangeSet;
import com.avaje.ebeaninternal.server.cache.CachedBeanData;
import com.avaje.ebeaninternal.server.cache.CachedBeanDataFromBean;
import com.avaje.ebeaninternal.server.cache.CachedBeanDataToBean;
import com.avaje.ebeaninternal.server.cache.CachedManyIds;
import com.avaje.ebeaninternal.server.core.CacheOptions;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanCollectionUtil;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.querydefn.NaturalKeyBindParam;
import com.avaje.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class BeanDescriptorCacheHelp<T> {
    private static final Logger logger = LoggerFactory.getLogger(BeanDescriptorCacheHelp.class);
    private static final Logger queryLog = LoggerFactory.getLogger((String)"org.avaje.ebean.cache.QUERY");
    private static final Logger beanLog = LoggerFactory.getLogger((String)"org.avaje.ebean.cache.BEAN");
    private static final Logger manyLog = LoggerFactory.getLogger((String)"org.avaje.ebean.cache.COLL");
    private static final Logger natLog = LoggerFactory.getLogger((String)"org.avaje.ebean.cache.NATKEY");
    private final BeanDescriptor<T> desc;
    private final ServerCacheManager cacheManager;
    private final CacheOptions cacheOptions;
    private final boolean cacheSharableBeans;
    private final Class<?> beanType;
    private final String cacheName;
    private final BeanPropertyAssocOne<?>[] propertiesOneImported;
    private final String naturalKeyProperty;
    private final ServerCache beanCache;
    private final ServerCache naturalKeyCache;
    private final ServerCache queryCache;
    private boolean cacheNotifyOnAll;
    private boolean cacheNotifyOnDelete;

    BeanDescriptorCacheHelp(BeanDescriptor<T> desc, ServerCacheManager cacheManager, CacheOptions cacheOptions, boolean cacheSharableBeans, BeanPropertyAssocOne<?>[] propertiesOneImported) {
        this.desc = desc;
        this.beanType = desc.rootBeanType;
        this.cacheName = this.beanType.getSimpleName();
        this.cacheManager = cacheManager;
        this.cacheOptions = cacheOptions;
        this.cacheSharableBeans = cacheSharableBeans;
        this.propertiesOneImported = propertiesOneImported;
        this.naturalKeyProperty = cacheOptions.getNaturalKey();
        this.queryCache = !cacheOptions.isEnableQueryCache() ? null : cacheManager.getQueryCache(this.beanType);
        if (cacheOptions.isEnableBeanCache()) {
            this.beanCache = cacheManager.getBeanCache(this.beanType);
            this.naturalKeyCache = cacheOptions.getNaturalKey() != null ? cacheManager.getNaturalKeyCache(this.beanType) : null;
        } else {
            this.beanCache = null;
            this.naturalKeyCache = null;
        }
    }

    public void deriveNotifyFlags() {
        this.cacheNotifyOnAll = this.beanCache != null || this.queryCache != null;
        boolean bl = this.cacheNotifyOnDelete = !this.cacheNotifyOnAll && this.isNotifyOnDeletes();
        if (logger.isDebugEnabled() && (this.isBeanCaching() || this.isQueryCaching() || this.cacheNotifyOnAll || this.cacheNotifyOnDelete)) {
            String notifyMode = this.cacheNotifyOnAll ? "All" : (this.cacheNotifyOnDelete ? "Delete" : "None");
            logger.debug("l2 caching on {} - beanCaching:{} queryCaching:{} notifyMode:{} ", new Object[]{this.desc.getFullName(), this.isBeanCaching(), this.isQueryCaching(), notifyMode});
        }
    }

    private boolean isNotifyOnDeletes() {
        for (int i = 0; i < this.propertiesOneImported.length; ++i) {
            if (!this.propertiesOneImported[i].isCacheNotify()) continue;
            return true;
        }
        return false;
    }

    boolean isCacheNotify(PersistRequest.Type type) {
        return this.cacheNotifyOnAll || this.cacheNotifyOnDelete && (type == PersistRequest.Type.DELETE || type == PersistRequest.Type.DELETE_PERMANENT);
    }

    boolean isQueryCaching() {
        return this.queryCache != null;
    }

    boolean isBeanCaching() {
        return this.beanCache != null;
    }

    CacheOptions getCacheOptions() {
        return this.cacheOptions;
    }

    void queryCacheClear() {
        if (this.queryCache != null) {
            if (queryLog.isDebugEnabled()) {
                queryLog.debug("   CLEAR {}", (Object)this.cacheName);
            }
            this.queryCache.clear();
        }
    }

    void queryCacheClear(CacheChangeSet changeSet) {
        if (this.queryCache != null) {
            changeSet.addClearQuery(this.desc);
        }
    }

    BeanCollection<T> queryCacheGet(Object id) {
        if (this.queryCache == null) {
            throw new IllegalStateException("No query cache enabled on " + this.desc + ". Need explicit @Cache(enableQueryCache=true)");
        }
        BeanCollection list = (BeanCollection)this.queryCache.get(id);
        if (queryLog.isDebugEnabled()) {
            if (list == null) {
                queryLog.debug("   GET {}({}) - cache miss", (Object)this.cacheName, id);
            } else {
                queryLog.debug("   GET {}({}) - hit", (Object)this.cacheName, id);
            }
        }
        return list;
    }

    void queryCachePut(Object id, BeanCollection<T> query) {
        if (this.queryCache == null) {
            throw new IllegalStateException("No query cache enabled on " + this.desc + ". Need explicit @Cache(enableQueryCache=true)");
        }
        if (queryLog.isDebugEnabled()) {
            queryLog.debug("   PUT {}({})", (Object)this.cacheName, id);
        }
        this.queryCache.put(id, query);
    }

    void manyPropRemove(String propertyName, Object parentId) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, propertyName);
        if (manyLog.isTraceEnabled()) {
            manyLog.trace("   REMOVE {}({}).{}", new Object[]{this.cacheName, parentId, propertyName});
        }
        collectionIdsCache.remove(parentId);
    }

    void manyPropClear(String propertyName) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, propertyName);
        if (manyLog.isDebugEnabled()) {
            manyLog.debug("   CLEAR {}(*).{} ", (Object)this.cacheName, (Object)propertyName);
        }
        collectionIdsCache.clear();
    }

    private CachedManyIds manyPropGet(Object parentId, String propertyName) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, propertyName);
        CachedManyIds entry = (CachedManyIds)collectionIdsCache.get(parentId);
        if (entry == null) {
            if (manyLog.isTraceEnabled()) {
                manyLog.trace("   GET {}({}).{} - cache miss", new Object[]{this.cacheName, parentId, propertyName});
            }
        } else if (manyLog.isDebugEnabled()) {
            manyLog.debug("   GET {}({}).{} - hit", new Object[]{this.cacheName, parentId, propertyName});
        }
        return entry;
    }

    boolean manyPropLoad(BeanPropertyAssocMany<?> many, BeanCollection<?> bc, Object parentId, Boolean readOnly) {
        CachedManyIds entry = this.manyPropGet(parentId, many.getName());
        if (entry == null) {
            return false;
        }
        EntityBean ownerBean = bc.getOwnerBean();
        EntityBeanIntercept ebi = ownerBean._ebean_getIntercept();
        PersistenceContext persistenceContext = ebi.getPersistenceContext();
        BeanDescriptor targetDescriptor = many.getTargetDescriptor();
        List<Object> idList = entry.getIdList();
        bc.checkEmptyLazyLoad();
        for (int i = 0; i < idList.size(); ++i) {
            Object id = idList.get(i);
            Object refBean = targetDescriptor.createReference(readOnly, false, id, persistenceContext);
            many.add(bc, (EntityBean)refBean);
        }
        return true;
    }

    void manyPropPut(BeanPropertyAssocMany<?> many, Object details, Object parentId) {
        CachedManyIds entry = this.createManyIds(many, details);
        if (entry != null) {
            this.cachePutManyIds(parentId, many.getName(), entry);
        }
    }

    void cachePutManyIds(Object parentId, String manyName, CachedManyIds entry) {
        ServerCache collectionIdsCache = this.cacheManager.getCollectionIdsCache(this.beanType, manyName);
        if (manyLog.isDebugEnabled()) {
            manyLog.debug("   PUT {}({}).{} - ids:{}", new Object[]{this.cacheName, parentId, manyName, entry});
        }
        collectionIdsCache.put(parentId, entry);
    }

    private CachedManyIds createManyIds(BeanPropertyAssocMany<?> many, Object details) {
        BeanDescriptor targetDescriptor = many.getTargetDescriptor();
        ArrayList<Object> idList = new ArrayList<Object>();
        Collection<?> actualDetails = BeanCollectionUtil.getActualEntries(details);
        if (actualDetails == null) {
            return null;
        }
        for (Object bean : actualDetails) {
            idList.add(targetDescriptor.getId((EntityBean)bean));
        }
        return new CachedManyIds(idList);
    }

    Object naturalKeyIdLookup(SpiQuery<T> query) {
        if (!this.isNaturalKeyCaching(query.isUseBeanCache())) {
            return null;
        }
        NaturalKeyBindParam keyBindParam = query.getNaturalKeyBindParam();
        if (keyBindParam == null || !this.isNaturalKey(keyBindParam.getName())) {
            return null;
        }
        Object id = this.naturalKeyCache.get(keyBindParam.getValue());
        if (natLog.isTraceEnabled()) {
            natLog.trace(" LOOKUP {}({}) - id:{}", new Object[]{this.cacheName, keyBindParam.getValue(), id});
        }
        return id;
    }

    private boolean isNaturalKeyCaching(Boolean queryUseCache) {
        return this.naturalKeyCache != null && (queryUseCache == null || queryUseCache != false);
    }

    private boolean isNaturalKey(String propName) {
        return propName != null && propName.equals(this.cacheOptions.getNaturalKey());
    }

    private void setupContext(Object bean, PersistenceContext context) {
        if (context == null) {
            context = new DefaultPersistenceContext();
        }
        EntityBean entityBean = (EntityBean)bean;
        EntityBeanIntercept ebi = entityBean._ebean_getIntercept();
        ebi.setPersistenceContext(context);
        Object id = this.desc.getId(entityBean);
        this.desc.contextPut(context, id, bean);
    }

    private ServerCache getBeanCache() {
        if (this.beanCache == null) {
            throw new IllegalStateException("No bean cache enabled for " + this.desc + ". Add the @Cache annotation.");
        }
        return this.beanCache;
    }

    private void beanCacheClear() {
        if (this.beanCache != null) {
            if (beanLog.isDebugEnabled()) {
                beanLog.debug("   CLEAR {}", (Object)this.cacheName);
            }
            this.beanCache.clear();
        }
    }

    CachedBeanData beanExtractData(BeanDescriptor<?> targetDesc, EntityBean bean) {
        return CachedBeanDataFromBean.extract(targetDesc, bean);
    }

    void beanCachePut(EntityBean bean) {
        if (this.desc.inheritInfo != null) {
            this.desc.descOf(bean.getClass()).cacheBeanPutDirect(bean);
        } else {
            this.beanCachePutDirect(bean);
        }
    }

    void beanCachePutDirect(EntityBean bean) {
        Object naturalKey;
        CachedBeanData beanData = this.beanExtractData(this.desc, bean);
        Object id = this.desc.getId(bean);
        if (beanLog.isDebugEnabled()) {
            beanLog.debug("   PUT {}({}) data:{}", new Object[]{this.cacheName, id, beanData});
        }
        this.getBeanCache().put(id, beanData);
        if (this.naturalKeyProperty != null && (naturalKey = beanData.getData(this.naturalKeyProperty)) != null) {
            if (natLog.isDebugEnabled()) {
                natLog.debug(" PUT {}({}, {})", new Object[]{this.cacheName, naturalKey, id});
            }
            this.naturalKeyCache.put(naturalKey, id);
        }
    }

    CachedBeanData beanCacheGetData(Object id) {
        return (CachedBeanData)this.getBeanCache().get(id);
    }

    T beanCacheGet(Object id, Boolean readOnly, PersistenceContext context) {
        T bean = this.beanCacheGetInternal(id, readOnly, context);
        if (bean != null) {
            this.setupContext(bean, context);
        }
        return bean;
    }

    private T beanCacheGetInternal(Object id, Boolean readOnly, PersistenceContext context) {
        Object bean;
        CachedBeanData data = (CachedBeanData)this.getBeanCache().get(id);
        if (data == null) {
            if (beanLog.isTraceEnabled()) {
                beanLog.trace("   GET {}({}) - cache miss", (Object)this.cacheName, id);
            }
            return null;
        }
        if (this.cacheSharableBeans && !Boolean.FALSE.equals(readOnly) && (bean = data.getSharableBean()) != null) {
            if (beanLog.isTraceEnabled()) {
                beanLog.trace("   GET {}({}) - hit shared bean", (Object)this.cacheName, id);
            }
            if (this.desc.isReadAuditing()) {
                this.desc.readAuditBean("l2", "", bean);
            }
            return (T)bean;
        }
        return (T)this.loadBean(id, readOnly, data, context);
    }

    private EntityBean loadBean(Object id, Boolean readOnly, CachedBeanData data, PersistenceContext context) {
        String discValue = data.getDiscValue();
        if (discValue == null) {
            return this.loadBeanDirect(id, readOnly, data, context);
        }
        return this.rootDescriptor(discValue).cacheBeanLoadDirect(id, readOnly, data, context);
    }

    private BeanDescriptor<?> rootDescriptor(String discValue) {
        return this.desc.inheritInfo.readType(discValue).desc();
    }

    EntityBean loadBeanDirect(Object id, Boolean readOnly, CachedBeanData data, PersistenceContext context) {
        if (context == null) {
            context = new DefaultPersistenceContext();
        }
        EntityBean bean = this.desc.createEntityBean();
        id = this.desc.convertSetId(id, bean);
        CachedBeanDataToBean.load(this.desc, bean, data, context);
        EntityBeanIntercept ebi = bean._ebean_getIntercept();
        ebi.setBeanLoader(this.desc.getEbeanServer());
        if (Boolean.TRUE.equals(readOnly)) {
            ebi.setReadOnly(true);
        }
        ebi.setPersistenceContext(context);
        this.desc.contextPut(context, id, bean);
        if (beanLog.isTraceEnabled()) {
            beanLog.trace("   GET {}({}) - hit", (Object)this.cacheName, id);
        }
        if (this.desc.isReadAuditing()) {
            this.desc.readAuditBean("l2", "", bean);
        }
        return bean;
    }

    EntityBean embeddedBeanLoad(CachedBeanData data, PersistenceContext context) {
        String discValue = data.getDiscValue();
        if (discValue == null) {
            return this.embeddedBeanLoadDirect(data, context);
        }
        return this.rootDescriptor(discValue).cacheEmbeddedBeanLoadDirect(data, context);
    }

    EntityBean embeddedBeanLoadDirect(CachedBeanData data, PersistenceContext context) {
        EntityBean bean = this.desc.createEntityBean();
        CachedBeanDataToBean.load(this.desc, bean, data, context);
        return bean;
    }

    void beanCacheRemove(Object id) {
        if (this.beanCache != null) {
            if (beanLog.isDebugEnabled()) {
                beanLog.debug("   REMOVE {}({})", (Object)this.cacheName, id);
            }
            this.beanCache.remove(id);
        }
        for (int i = 0; i < this.propertiesOneImported.length; ++i) {
            this.propertiesOneImported[i].cacheClear();
        }
    }

    boolean beanCacheLoad(EntityBean bean, EntityBeanIntercept ebi, Object id, PersistenceContext context) {
        CachedBeanData cacheData = (CachedBeanData)this.getBeanCache().get(id);
        if (cacheData == null) {
            if (beanLog.isTraceEnabled()) {
                beanLog.trace("   LOAD {}({}) - cache miss", (Object)this.cacheName, id);
            }
            return false;
        }
        int lazyLoadProperty = ebi.getLazyLoadPropertyIndex();
        if (lazyLoadProperty > -1 && !cacheData.isLoaded(ebi.getLazyLoadProperty())) {
            if (beanLog.isTraceEnabled()) {
                beanLog.trace("   LOAD {}({}) - cache miss on property({})", new Object[]{this.cacheName, id, ebi.getLazyLoadProperty()});
            }
            return false;
        }
        CachedBeanDataToBean.load(this.desc, bean, cacheData, context);
        if (beanLog.isDebugEnabled()) {
            beanLog.debug("   LOAD {}({}) - hit", (Object)this.cacheName, id);
        }
        return true;
    }

    void handleDelete(Object id, CacheChangeSet changeSet) {
        if (this.beanCache != null) {
            changeSet.addBeanRemove(this.desc, id);
        }
        this.cacheDeleteImported(true, null, changeSet);
    }

    void handleDelete(Object id, PersistRequestBean<T> deleteRequest, CacheChangeSet changeSet) {
        this.queryCacheClear(changeSet);
        if (this.beanCache != null) {
            changeSet.addBeanRemove(this.desc, id);
        }
        this.cacheDeleteImported(true, deleteRequest.getEntityBean(), changeSet);
    }

    void handleInsert(PersistRequestBean<T> insertRequest, CacheChangeSet changeSet) {
        this.queryCacheClear(changeSet);
        this.cacheDeleteImported(false, insertRequest.getEntityBean(), changeSet);
        changeSet.addBeanInsert(this.desc.getBaseTable());
    }

    private void cacheDeleteImported(boolean clear, EntityBean entityBean, CacheChangeSet changeSet) {
        for (int i = 0; i < this.propertiesOneImported.length; ++i) {
            this.propertiesOneImported[i].cacheDelete(clear, entityBean, changeSet);
        }
    }

    void handleUpdate(Object id, PersistRequestBean<T> updateRequest, CacheChangeSet changeSet) {
        this.queryCacheClear(changeSet);
        if (this.beanCache == null) {
            return;
        }
        List<BeanPropertyAssocMany<?>> manyCollections = updateRequest.getUpdatedManyCollections();
        if (manyCollections != null) {
            for (int i = 0; i < manyCollections.size(); ++i) {
                Object details;
                BeanPropertyAssocMany<?> many = manyCollections.get(i);
                CachedManyIds entry = this.createManyIds(many, details = many.getValue(updateRequest.getEntityBean()));
                if (entry == null) continue;
                changeSet.addManyPut(this.desc, many.getName(), id, entry);
            }
        }
        if (!updateRequest.isUpdatedManysOnly()) {
            boolean updateNaturalKey = false;
            LinkedHashMap<String, Object> changes = new LinkedHashMap<String, Object>();
            EntityBean bean = updateRequest.getEntityBean();
            boolean[] dirtyProperties = updateRequest.getDirtyProperties();
            for (int i = 0; i < dirtyProperties.length; ++i) {
                BeanProperty property;
                if (!dirtyProperties[i] || !(property = this.desc.propertiesIndex[i]).isCacheDataInclude()) continue;
                Object val = property.getCacheDataValue(bean);
                changes.put(property.getName(), val);
                if (!property.isNaturalKey()) continue;
                updateNaturalKey = true;
                changeSet.addNaturalKeyPut(this.desc, id, val);
            }
            changeSet.addBeanUpdate(this.desc, id, changes, updateNaturalKey, updateRequest.getVersion());
        }
    }

    void handleBulkUpdate(TransactionEventTable.TableIUD tableIUD) {
        if (tableIUD.isUpdateOrDelete()) {
            this.beanCacheClear();
        }
        this.queryCacheClear();
    }

    void cacheNaturalKeyPut(Object id, Object newKey) {
        if (newKey != null) {
            this.naturalKeyCache.put(newKey, id);
        }
    }

    void cacheBeanUpdate(Object id, Map<String, Object> changes, boolean updateNaturalKey, long version) {
        ServerCache cache = this.getBeanCache();
        CachedBeanData existingData = (CachedBeanData)cache.get(id);
        if (existingData != null) {
            Object oldKey;
            long currentVersion = existingData.getVersion();
            if (version > 0L && version < currentVersion) {
                if (beanLog.isDebugEnabled()) {
                    beanLog.debug("   REMOVE {}({}) - version conflict old:{} new:{}", new Object[]{this.cacheName, id, currentVersion, version});
                }
                cache.remove(id);
            } else {
                if (version == 0L) {
                    version = currentVersion;
                }
                CachedBeanData newData = existingData.update(changes, version);
                if (beanLog.isDebugEnabled()) {
                    beanLog.debug("   UPDATE {}({})  changes:{}", new Object[]{this.cacheName, id, changes});
                }
                cache.put(id, newData);
            }
            if (updateNaturalKey && (oldKey = existingData.getData(this.naturalKeyProperty)) != null) {
                if (natLog.isDebugEnabled()) {
                    natLog.debug(".. update {} REMOVE({}) - old key for ({})", new Object[]{this.cacheName, oldKey, id});
                }
                this.naturalKeyCache.remove(oldKey);
            }
        }
    }
}

