/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.deploy;

import com.avaje.ebean.OrderBy;
import com.avaje.ebean.PersistenceContextScope;
import com.avaje.ebean.Query;
import com.avaje.ebean.RawSql;
import com.avaje.ebean.SqlUpdate;
import com.avaje.ebean.Transaction;
import com.avaje.ebean.ValuePair;
import com.avaje.ebean.annotation.DocStoreMode;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.bean.PersistenceContextUtil;
import com.avaje.ebean.config.EncryptKey;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.IdType;
import com.avaje.ebean.config.dbplatform.PlatformIdGenerator;
import com.avaje.ebean.event.BeanFindController;
import com.avaje.ebean.event.BeanPersistController;
import com.avaje.ebean.event.BeanPersistListener;
import com.avaje.ebean.event.BeanPostLoad;
import com.avaje.ebean.event.BeanQueryAdapter;
import com.avaje.ebean.event.changelog.BeanChange;
import com.avaje.ebean.event.changelog.ChangeLogFilter;
import com.avaje.ebean.event.changelog.ChangeType;
import com.avaje.ebean.event.readaudit.ReadAuditLogger;
import com.avaje.ebean.event.readaudit.ReadAuditPrepare;
import com.avaje.ebean.event.readaudit.ReadEvent;
import com.avaje.ebean.meta.MetaBeanInfo;
import com.avaje.ebean.meta.MetaQueryPlanStatistic;
import com.avaje.ebean.plugin.BeanDocType;
import com.avaje.ebean.plugin.BeanType;
import com.avaje.ebean.plugin.ExpressionPath;
import com.avaje.ebean.plugin.Property;
import com.avaje.ebeaninternal.api.CQueryPlanKey;
import com.avaje.ebeaninternal.api.ConcurrencyMode;
import com.avaje.ebeaninternal.api.LoadContext;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiUpdatePlan;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.cache.CacheChangeSet;
import com.avaje.ebeaninternal.server.cache.CachedBeanData;
import com.avaje.ebeaninternal.server.cache.CachedManyIds;
import com.avaje.ebeaninternal.server.core.CacheOptions;
import com.avaje.ebeaninternal.server.core.DefaultSqlUpdate;
import com.avaje.ebeaninternal.server.core.DiffHelp;
import com.avaje.ebeaninternal.server.core.InternString;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorCacheHelp;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorDraftHelp;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorJsonHelp;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptorMap;
import com.avaje.ebeaninternal.server.deploy.BeanFkeyProperty;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssoc;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyCompound;
import com.avaje.ebeaninternal.server.deploy.ChainedBeanPersistController;
import com.avaje.ebeaninternal.server.deploy.ChainedBeanPersistListener;
import com.avaje.ebeaninternal.server.deploy.DeployPropertyParser;
import com.avaje.ebeaninternal.server.deploy.DeployUpdateParser;
import com.avaje.ebeaninternal.server.deploy.IndexDefinition;
import com.avaje.ebeaninternal.server.deploy.InheritInfo;
import com.avaje.ebeaninternal.server.deploy.InheritInfoVisitor;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.deploy.id.IdBinder;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.meta.DeployBeanPropertyLists;
import com.avaje.ebeaninternal.server.el.ElComparator;
import com.avaje.ebeaninternal.server.el.ElComparatorCompound;
import com.avaje.ebeaninternal.server.el.ElComparatorProperty;
import com.avaje.ebeaninternal.server.el.ElPropertyChainBuilder;
import com.avaje.ebeaninternal.server.el.ElPropertyDeploy;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.persist.DmlUtil;
import com.avaje.ebeaninternal.server.query.CQueryPlan;
import com.avaje.ebeaninternal.server.query.CQueryPlanStats;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import com.avaje.ebeaninternal.server.text.json.ReadJson;
import com.avaje.ebeaninternal.server.text.json.WriteJson;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.util.SortByClause;
import com.avaje.ebeaninternal.util.SortByClauseParser;
import com.avaje.ebeanservice.docstore.api.DocStoreBeanAdapter;
import com.avaje.ebeanservice.docstore.api.DocStoreUpdateContext;
import com.avaje.ebeanservice.docstore.api.DocStoreUpdates;
import com.avaje.ebeanservice.docstore.api.mapping.DocMappingBuilder;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyMapping;
import com.avaje.ebeanservice.docstore.api.mapping.DocPropertyType;
import com.avaje.ebeanservice.docstore.api.mapping.DocumentMapping;
import java.io.IOException;
import java.lang.reflect.Modifier;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.persistence.PersistenceException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BeanDescriptor<T>
implements MetaBeanInfo,
BeanType<T> {
    private static final Logger logger = LoggerFactory.getLogger(BeanDescriptor.class);
    private final ConcurrentHashMap<Integer, SpiUpdatePlan> updatePlanCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<CQueryPlanKey, CQueryPlan> queryPlanCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ElPropertyValue> elCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ElPropertyDeploy> elDeployCache = new ConcurrentHashMap();
    private final ConcurrentHashMap<String, ElComparator<T>> comparatorCache = new ConcurrentHashMap();
    private final Map<String, RawSql> namedRawSql;
    private final Map<String, String> namedQuery;
    private final String serverName;
    private final EntityType entityType;
    private final IdType idType;
    private final boolean idTypePlatformDefault;
    private final PlatformIdGenerator idGenerator;
    private final String sequenceName;
    private final int sequenceInitialValue;
    private final int sequenceAllocationSize;
    private final String selectLastInsertedId;
    private final boolean autoTunable;
    private final ConcurrencyMode concurrencyMode;
    private final IndexDefinition[] indexDefinitions;
    private final String[] dependentTables;
    private final String baseTable;
    private final String baseTableAsOf;
    private final String baseTableVersionsBetween;
    private final boolean historySupport;
    private final BeanProperty softDeleteProperty;
    private final boolean softDelete;
    private final String draftTable;
    private final String dbComment;
    private final boolean readAuditing;
    private final boolean draftable;
    private final boolean draftableElement;
    private final BeanProperty draft;
    private final BeanProperty draftDirty;
    protected final LinkedHashMap<String, BeanProperty> propMap;
    private final Class<T> beanType;
    protected final Class<?> rootBeanType;
    private final BeanDescriptorMap owner;
    private final String[] properties;
    private volatile BeanPersistController persistController;
    private final BeanPostLoad beanPostLoad;
    private volatile BeanPersistListener persistListener;
    private final BeanQueryAdapter queryAdapter;
    private final BeanFindController beanFinder;
    private final ChangeLogFilter changeLogFilter;
    private final TableJoin[] derivedTableJoins;
    protected final InheritInfo inheritInfo;
    protected final BeanProperty idProperty;
    private final int idPropertyIndex;
    private final BeanProperty versionProperty;
    private final int versionPropertyIndex;
    private final BeanProperty whenModifiedProperty;
    private final BeanProperty whenCreatedProperty;
    private final int[] unloadProperties;
    private final BeanProperty[] propertiesLocal;
    private final BeanProperty[] propertiesMutable;
    private final BeanPropertyAssocOne<?> unidirectional;
    private final BeanProperty[] propertiesNonMany;
    private final BeanPropertyAssocMany<?>[] propertiesMany;
    private final BeanPropertyAssocMany<?>[] propertiesManySave;
    private final BeanPropertyAssocMany<?>[] propertiesManyDelete;
    private final BeanPropertyAssocMany<?>[] propertiesManyToMany;
    private final BeanPropertyAssocOne<?>[] propertiesOne;
    private final BeanPropertyAssocOne<?>[] propertiesOneImported;
    private final BeanPropertyAssocOne<?>[] propertiesOneImportedSave;
    private final BeanPropertyAssocOne<?>[] propertiesOneImportedDelete;
    private final BeanPropertyAssocOne<?>[] propertiesOneExportedSave;
    private final BeanPropertyAssocOne<?>[] propertiesOneExportedDelete;
    private final BeanPropertyAssocOne<?>[] propertiesEmbedded;
    private final BeanProperty[] propertiesBaseScalar;
    private final BeanPropertyCompound[] propertiesBaseCompound;
    private final BeanProperty[] propertiesTransient;
    private final BeanProperty[] propertiesNonTransient;
    protected final BeanProperty[] propertiesIndex;
    private final String fullName;
    private boolean saveRecurseSkippable;
    private boolean deleteRecurseSkippable;
    private final EntityBean prototypeEntityBean;
    private final IdBinder idBinder;
    private String idBinderInLHSSql;
    private String idBinderIdSql;
    private String deleteByIdSql;
    private String deleteByIdInSql;
    private String whereIdInSql;
    private String softDeleteByIdSql;
    private String softDeleteByIdInSql;
    private final String name;
    private final String baseTableAlias;
    private final boolean updateChangesOnly;
    private final boolean cacheSharableBeans;
    private final String docStoreQueueId;
    private final BeanDescriptorDraftHelp<T> draftHelp;
    private final BeanDescriptorCacheHelp<T> cacheHelp;
    private final BeanDescriptorJsonHelp<T> jsonHelp;
    private DocStoreBeanAdapter<T> docStoreAdapter;
    private DocumentMapping docMapping;
    private final String defaultSelectClause;
    private SpiEbeanServer ebeanServer;

    public void merge(EntityBean bean, EntityBean existing) {
        EntityBeanIntercept fromEbi = bean._ebean_getIntercept();
        EntityBeanIntercept toEbi = existing._ebean_getIntercept();
        int propertyLength = toEbi.getPropertyLength();
        String[] names = this.getProperties();
        for (int i = 0; i < propertyLength; ++i) {
            if (!fromEbi.isLoadedProperty(i)) continue;
            BeanProperty property = this.getBeanProperty(names[i]);
            if (!toEbi.isLoadedProperty(i)) {
                Object val = property.getValue(bean);
                property.setValue(existing, val);
                continue;
            }
            if (!property.isMany()) continue;
            property.merge(bean, existing);
        }
    }

    public BeanDescriptor(BeanDescriptorMap owner, DeployBeanDescriptor<T> deploy) {
        this.owner = owner;
        this.serverName = owner.getServerName();
        this.entityType = deploy.getEntityType();
        this.properties = deploy.getProperties();
        this.name = InternString.intern(deploy.getName());
        this.baseTableAlias = "t0";
        this.fullName = InternString.intern(deploy.getFullName());
        this.beanType = deploy.getBeanType();
        this.rootBeanType = PersistenceContextUtil.root(this.beanType);
        this.prototypeEntityBean = this.createPrototypeEntityBean(this.beanType);
        this.namedQuery = deploy.getNamedQuery();
        this.namedRawSql = deploy.getNamedRawSql();
        this.inheritInfo = deploy.getInheritInfo();
        this.beanFinder = deploy.getBeanFinder();
        this.persistController = deploy.getPersistController();
        this.persistListener = deploy.getPersistListener();
        this.beanPostLoad = deploy.getPostLoad();
        this.queryAdapter = deploy.getQueryAdapter();
        this.changeLogFilter = deploy.getChangeLogFilter();
        this.defaultSelectClause = deploy.getDefaultSelectClause();
        this.idType = deploy.getIdType();
        this.idTypePlatformDefault = deploy.isIdTypePlatformDefault();
        this.idGenerator = deploy.getIdGenerator();
        this.sequenceName = deploy.getSequenceName();
        this.sequenceInitialValue = deploy.getSequenceInitialValue();
        this.sequenceAllocationSize = deploy.getSequenceAllocationSize();
        this.selectLastInsertedId = deploy.getSelectLastInsertedId();
        this.concurrencyMode = deploy.getConcurrencyMode();
        this.updateChangesOnly = deploy.isUpdateChangesOnly();
        this.indexDefinitions = deploy.getIndexDefinitions();
        this.readAuditing = deploy.isReadAuditing();
        this.draftable = deploy.isDraftable();
        this.draftableElement = deploy.isDraftableElement();
        this.historySupport = deploy.isHistorySupport();
        this.draftTable = deploy.getDraftTable();
        this.baseTable = InternString.intern(deploy.getBaseTable());
        this.baseTableAsOf = deploy.getBaseTableAsOf();
        this.baseTableVersionsBetween = deploy.getBaseTableVersionsBetween();
        this.dependentTables = deploy.getDependentTables();
        this.dbComment = deploy.getDbComment();
        this.autoTunable = EntityType.ORM == this.entityType && this.beanFinder == null;
        DeployBeanPropertyLists listHelper = new DeployBeanPropertyLists(owner, this, deploy);
        this.softDeleteProperty = listHelper.getSoftDeleteProperty();
        this.softDelete = this.softDeleteProperty != null;
        this.idProperty = listHelper.getId();
        this.versionProperty = listHelper.getVersionProperty();
        this.draft = listHelper.getDraft();
        this.draftDirty = listHelper.getDraftDirty();
        this.propMap = listHelper.getPropertyMap();
        this.propertiesTransient = listHelper.getTransients();
        this.propertiesNonTransient = listHelper.getNonTransients();
        this.propertiesBaseScalar = listHelper.getBaseScalar();
        this.propertiesBaseCompound = listHelper.getBaseCompound();
        this.propertiesEmbedded = listHelper.getEmbedded();
        this.propertiesLocal = listHelper.getLocal();
        this.propertiesMutable = listHelper.getMutable();
        this.unidirectional = listHelper.getUnidirectional();
        this.propertiesOne = listHelper.getOnes();
        this.propertiesOneExportedSave = listHelper.getOneExportedSave();
        this.propertiesOneExportedDelete = listHelper.getOneExportedDelete();
        this.propertiesOneImported = listHelper.getOneImported();
        this.propertiesOneImportedSave = listHelper.getOneImportedSave();
        this.propertiesOneImportedDelete = listHelper.getOneImportedDelete();
        this.propertiesMany = listHelper.getMany();
        this.propertiesNonMany = listHelper.getNonMany();
        this.propertiesManySave = listHelper.getManySave();
        this.propertiesManyDelete = listHelper.getManyDelete();
        this.propertiesManyToMany = listHelper.getManyToMany();
        this.derivedTableJoins = listHelper.getTableJoin();
        boolean noRelationships = this.propertiesOne.length + this.propertiesMany.length == 0;
        this.cacheSharableBeans = noRelationships && deploy.getCacheOptions().isReadOnly();
        this.cacheHelp = new BeanDescriptorCacheHelp(this, owner.getCacheManager(), deploy.getCacheOptions(), this.cacheSharableBeans, this.propertiesOneImported);
        this.jsonHelp = new BeanDescriptorJsonHelp(this);
        this.draftHelp = new BeanDescriptorDraftHelp(this);
        this.docStoreAdapter = owner.createDocStoreBeanAdapter(this, deploy);
        this.docStoreQueueId = this.docStoreAdapter.getQueueId();
        this.saveRecurseSkippable = 0 == this.propertiesOneExportedSave.length + this.propertiesOneImportedSave.length + this.propertiesManySave.length;
        this.deleteRecurseSkippable = 0 == this.propertiesOneExportedDelete.length + this.propertiesOneImportedDelete.length + this.propertiesManyDelete.length;
        this.idBinder = owner.createIdBinder(this.idProperty);
        this.whenModifiedProperty = this.findWhenModifiedProperty();
        this.whenCreatedProperty = this.findWhenCreatedProperty();
        if (Modifier.isAbstract(this.beanType.getModifiers())) {
            this.idPropertyIndex = -1;
            this.versionPropertyIndex = -1;
            this.unloadProperties = new int[0];
            this.propertiesIndex = new BeanProperty[0];
        } else {
            EntityBeanIntercept ebi = this.prototypeEntityBean._ebean_getIntercept();
            this.idPropertyIndex = this.idProperty == null ? -1 : ebi.findProperty(this.idProperty.getName());
            this.versionPropertyIndex = this.versionProperty == null ? -1 : ebi.findProperty(this.versionProperty.getName());
            this.unloadProperties = this.derivePropertiesToUnload(this.prototypeEntityBean);
            this.propertiesIndex = new BeanProperty[ebi.getPropertyLength()];
            for (int i = 0; i < this.propertiesIndex.length; ++i) {
                this.propertiesIndex[i] = this.propMap.get(ebi.getProperty(i));
            }
        }
    }

    private int[] derivePropertiesToUnload(EntityBean prototypeEntityBean) {
        boolean[] loaded = prototypeEntityBean._ebean_getIntercept().getLoaded();
        int[] props = new int[loaded.length];
        int pos = 0;
        for (int i = 0; i < loaded.length; ++i) {
            if (!loaded[i]) continue;
            props[pos++] = i;
        }
        if (pos == 0) {
            return new int[0];
        }
        int[] unload = new int[pos];
        System.arraycopy(props, 0, unload, 0, pos);
        return unload;
    }

    private EntityBean createPrototypeEntityBean(Class<T> beanType) {
        if (Modifier.isAbstract(beanType.getModifiers())) {
            return null;
        }
        try {
            return (EntityBean)beanType.newInstance();
        }
        catch (Exception e) {
            throw new IllegalStateException("Error trying to create the prototypeEntityBean for " + beanType, e);
        }
    }

    public ServerConfig getServerConfig() {
        return this.owner.getServerConfig();
    }

    public void setEbeanServer(SpiEbeanServer ebeanServer) {
        this.ebeanServer = ebeanServer;
        for (int i = 0; i < this.propertiesMany.length; ++i) {
            this.propertiesMany[i].setLoader(ebeanServer);
        }
    }

    public SpiEbeanServer getEbeanServer() {
        return this.ebeanServer;
    }

    public EntityType getEntityType() {
        return this.entityType;
    }

    public String[] getProperties() {
        return this.properties;
    }

    public void initialiseId(Map<String, String> withHistoryTables, Map<String, String> draftTables) {
        if (logger.isTraceEnabled()) {
            logger.trace("BeanDescriptor initialise " + this.fullName);
        }
        if (this.draftable) {
            draftTables.put(this.baseTable, this.draftTable);
        }
        if (this.historySupport) {
            withHistoryTables.put(this.baseTable, this.baseTableAsOf);
        }
        if (this.inheritInfo != null) {
            this.inheritInfo.setDescriptor(this);
        }
        if (this.isEmbedded()) {
            for (BeanProperty prop : this.propertiesAll()) {
                prop.initialise();
            }
        } else if (this.idProperty != null) {
            this.idProperty.initialise();
        }
    }

    public void initialiseOther(Map<String, String> asOfTableMap, String asOfViewSuffix, Map<String, String> draftTableMap) {
        int i;
        for (i = 0; i < this.propertiesManyToMany.length; ++i) {
            this.propertiesManyToMany[i].registerDraftIntersectionTable(draftTableMap);
        }
        if (this.historySupport) {
            for (i = 0; i < this.propertiesManyToMany.length; ++i) {
                if (this.propertiesManyToMany[i].isExcludedFromHistory()) continue;
                TableJoin intersectionTableJoin = this.propertiesManyToMany[i].getIntersectionTableJoin();
                String intersectionTableName = intersectionTableJoin.getTable();
                asOfTableMap.put(intersectionTableName, intersectionTableName + asOfViewSuffix);
            }
        }
        if (!this.isEmbedded()) {
            for (BeanProperty prop : this.propertiesAll()) {
                if (prop.isId()) continue;
                prop.initialise();
            }
        }
        if (this.unidirectional != null) {
            this.unidirectional.initialise();
        }
        this.idBinder.initialise();
        this.idBinderInLHSSql = this.idBinder.getBindIdInSql(this.baseTableAlias);
        this.idBinderIdSql = this.idBinder.getBindIdSql(this.baseTableAlias);
        String idBinderInLHSSqlNoAlias = this.idBinder.getBindIdInSql(null);
        String idEqualsSql = this.idBinder.getBindIdSql(null);
        this.deleteByIdSql = "delete from " + this.baseTable + " where " + idEqualsSql;
        this.whereIdInSql = " where " + idBinderInLHSSqlNoAlias + " ";
        this.deleteByIdInSql = "delete from " + this.baseTable + this.whereIdInSql;
        if (this.softDelete) {
            this.softDeleteByIdSql = "update " + this.baseTable + " set " + this.getSoftDeleteDbSet() + " where " + idEqualsSql;
            this.softDeleteByIdInSql = "update " + this.baseTable + " set " + this.getSoftDeleteDbSet() + " where " + idBinderInLHSSqlNoAlias + " ";
        } else {
            this.softDeleteByIdSql = null;
            this.softDeleteByIdInSql = null;
        }
    }

    public void initialiseDocMapping() {
        for (int i = 0; i < this.propertiesMany.length; ++i) {
            this.propertiesMany[i].initialisePostTarget();
        }
        if (this.inheritInfo != null && !this.inheritInfo.isRoot()) {
            this.docStoreAdapter = this.inheritInfo.getRoot().desc().docStoreAdapter();
        }
        this.docMapping = this.docStoreAdapter.createDocMapping();
        this.docStoreAdapter.registerPaths();
        this.cacheHelp.deriveNotifyFlags();
    }

    public void initInheritInfo() {
        if (this.inheritInfo != null) {
            if (this.saveRecurseSkippable) {
                this.saveRecurseSkippable = this.inheritInfo.isSaveRecurseSkippable();
            }
            if (this.deleteRecurseSkippable) {
                this.deleteRecurseSkippable = this.inheritInfo.isDeleteRecurseSkippable();
            }
        }
    }

    public ReadAuditLogger getReadAuditLogger() {
        return this.ebeanServer.getReadAuditLogger();
    }

    public ReadAuditPrepare getReadAuditPrepare() {
        return this.ebeanServer.getReadAuditPrepare();
    }

    public BeanChange getChangeLogBean(PersistRequestBean<T> request) {
        if (this.changeLogFilter == null) {
            return null;
        }
        PersistRequest.Type type = request.getType();
        switch (type) {
            case INSERT: {
                return this.changeLogFilter.includeInsert(request) ? this.insertBeanChange(request) : null;
            }
            case UPDATE: 
            case SOFT_DELETE: {
                return this.changeLogFilter.includeUpdate(request) ? this.updateBeanChange(request) : null;
            }
            case DELETE: {
                return this.changeLogFilter.includeDelete(request) ? this.deleteBeanChange(request) : null;
            }
        }
        throw new IllegalStateException("Unhandled request type " + (Object)((Object)type));
    }

    private BeanChange deleteBeanChange(PersistRequestBean<T> request) {
        return this.newBeanChange(request.getBeanId(), ChangeType.DELETE, Collections.EMPTY_MAP);
    }

    private BeanChange updateBeanChange(PersistRequestBean<T> request) {
        return this.newBeanChange(request.getBeanId(), ChangeType.UPDATE, this.diffFlatten(request.getEntityBeanIntercept().getDirtyValues()));
    }

    private BeanChange insertBeanChange(PersistRequestBean<T> request) {
        return this.newBeanChange(request.getBeanId(), ChangeType.INSERT, this.diffForInsert(request.getEntityBean()));
    }

    private BeanChange newBeanChange(Object id, ChangeType changeType, Map<String, ValuePair> values) {
        return new BeanChange(this.getBaseTable(), id, changeType, values);
    }

    public SqlUpdate deleteById(Object id, List<Object> idList, boolean softDelete) {
        if (id != null) {
            return this.deleteById(id, softDelete);
        }
        return this.deleteByIdList(idList, softDelete);
    }

    public String getWhereIdInSql() {
        return this.whereIdInSql;
    }

    public String getDeleteByIdInSql() {
        return this.deleteByIdInSql;
    }

    private SqlUpdate deleteByIdList(List<Object> idList, boolean softDelete) {
        String baseSql = softDelete ? this.softDeleteByIdInSql : this.deleteByIdInSql;
        StringBuilder sb = new StringBuilder(baseSql);
        String inClause = this.idBinder.getIdInValueExprDelete(idList.size());
        sb.append(inClause);
        DefaultSqlUpdate delete = new DefaultSqlUpdate(sb.toString());
        for (int i = 0; i < idList.size(); ++i) {
            this.idBinder.bindId(delete, idList.get(i));
        }
        return delete;
    }

    private SqlUpdate deleteById(Object id, boolean softDelete) {
        String baseSql = softDelete ? this.softDeleteByIdSql : this.deleteByIdSql;
        DefaultSqlUpdate sqlDelete = new DefaultSqlUpdate(baseSql);
        Object[] bindValues = this.idBinder.getBindValues(id);
        for (int i = 0; i < bindValues.length; ++i) {
            sqlDelete.addParameter(bindValues[i]);
        }
        return sqlDelete;
    }

    public void add(BeanFkeyProperty fkey) {
        this.elDeployCache.put(fkey.getName(), fkey);
    }

    public void initialiseFkeys() {
        for (int i = 0; i < this.propertiesOneImported.length; ++i) {
            this.propertiesOneImported[i].addFkey();
        }
    }

    public CacheOptions getCacheOptions() {
        return this.cacheHelp.getCacheOptions();
    }

    public EncryptKey getEncryptKey(BeanProperty p) {
        return this.owner.getEncryptKey(this.baseTable, p.getDbColumn());
    }

    public EncryptKey getEncryptKey(String tableName, String columnName) {
        return this.owner.getEncryptKey(tableName, columnName);
    }

    public boolean hasDefaultSelectClause() {
        return this.defaultSelectClause != null;
    }

    public String getDefaultSelectClause() {
        return this.defaultSelectClause;
    }

    public boolean isInheritanceRoot() {
        return this.inheritInfo == null || this.inheritInfo.isRoot();
    }

    @Override
    public boolean isDocStoreMapped() {
        return this.docStoreAdapter.isMapped();
    }

    @Override
    public String getDocStoreQueueId() {
        return this.docStoreQueueId;
    }

    @Override
    public DocumentMapping getDocMapping() {
        return this.docMapping;
    }

    @Override
    public BeanDocType<T> docStore() {
        return this.docStoreAdapter;
    }

    public DocStoreBeanAdapter<T> docStoreAdapter() {
        return this.docStoreAdapter;
    }

    public void docStoreMapping(final DocMappingBuilder mapping, final String prefix) {
        if (prefix != null && this.idProperty != null) {
            this.idProperty.docStoreMapping(mapping, prefix);
        }
        if (this.inheritInfo != null) {
            String discCol = this.inheritInfo.getDiscriminatorColumn();
            if (12 == this.inheritInfo.getDiscriminatorType()) {
                mapping.add(new DocPropertyMapping(discCol, DocPropertyType.ENUM));
            } else {
                mapping.add(new DocPropertyMapping(discCol, DocPropertyType.INTEGER));
            }
        }
        for (BeanProperty prop : this.propertiesNonTransient) {
            prop.docStoreMapping(mapping, prefix);
        }
        if (this.inheritInfo != null) {
            this.inheritInfo.visitChildren(new InheritInfoVisitor(){

                @Override
                public void visit(InheritInfo inheritInfo) {
                    for (BeanProperty localProperty : inheritInfo.localProperties()) {
                        localProperty.docStoreMapping(mapping, prefix);
                    }
                }
            });
        }
    }

    @Override
    public BeanType<?> root() {
        if (this.inheritInfo != null && !this.inheritInfo.isRoot()) {
            return this.inheritInfo.getRoot().desc();
        }
        return this;
    }

    public String getNamedQuery(String name) {
        return this.namedQuery.get(name);
    }

    public RawSql getNamedRawSql(String named) {
        return this.namedRawSql.get(named);
    }

    public DocStoreMode getDocStoreMode(PersistRequest.Type persistType, DocStoreMode txnMode) {
        return this.docStoreAdapter.getMode(persistType, txnMode);
    }

    public void docStoreInsert(Object idValue, PersistRequestBean<T> persistRequest, DocStoreUpdateContext bulkUpdate) throws IOException {
        this.docStoreAdapter.insert(idValue, persistRequest, bulkUpdate);
    }

    public void docStoreUpdate(Object idValue, PersistRequestBean<T> persistRequest, DocStoreUpdateContext bulkUpdate) throws IOException {
        this.docStoreAdapter.update(idValue, persistRequest, bulkUpdate);
    }

    public void docStoreUpdateEmbedded(PersistRequestBean<T> request, DocStoreUpdates docStoreUpdates) {
        this.docStoreAdapter.updateEmbedded(request, docStoreUpdates);
    }

    public void docStoreDeleteById(Object idValue, DocStoreUpdateContext txn) throws IOException {
        this.docStoreAdapter.deleteById(idValue, txn);
    }

    public T publish(T draftBean, T liveBean) {
        return this.draftHelp.publish(draftBean, liveBean);
    }

    public boolean draftReset(T draftBean) {
        return this.draftHelp.draftReset(draftBean);
    }

    public BeanProperty getDraftDirty() {
        return this.draftDirty;
    }

    public boolean isBeanCaching() {
        return this.cacheHelp.isBeanCaching();
    }

    public boolean isQueryCaching() {
        return this.cacheHelp.isQueryCaching();
    }

    public boolean isManyPropCaching() {
        return this.isBeanCaching();
    }

    public boolean isCacheNotify(PersistRequest.Type type, boolean publish) {
        if (this.draftable && !publish) {
            return false;
        }
        return this.cacheHelp.isCacheNotify(type);
    }

    public void queryCacheClear() {
        this.cacheHelp.queryCacheClear();
    }

    public BeanCollection<T> queryCacheGet(Object id) {
        return this.cacheHelp.queryCacheGet(id);
    }

    public void queryCachePut(Object id, BeanCollection<T> query) {
        this.cacheHelp.queryCachePut(id, query);
    }

    public void queryCacheClear(CacheChangeSet changeSet) {
        this.cacheHelp.queryCacheClear(changeSet);
    }

    public boolean cacheManyPropLoad(BeanPropertyAssocMany<?> many, BeanCollection<?> bc, Object parentId, Boolean readOnly) {
        return this.cacheHelp.manyPropLoad(many, bc, parentId, readOnly);
    }

    public void cacheManyPropPut(BeanPropertyAssocMany<?> many, BeanCollection<?> bc, Object parentId) {
        this.cacheHelp.manyPropPut(many, bc, parentId);
    }

    public void cacheManyPropPut(String name, Object parentId, CachedManyIds entry) {
        this.cacheHelp.cachePutManyIds(parentId, name, entry);
    }

    public void cacheManyPropRemove(String propertyName, Object parentId) {
        this.cacheHelp.manyPropRemove(propertyName, parentId);
    }

    public void cacheManyPropClear(String propertyName) {
        this.cacheHelp.manyPropClear(propertyName);
    }

    public CachedBeanData cacheEmbeddedBeanExtract(EntityBean bean) {
        return this.cacheHelp.beanExtractData(this, bean);
    }

    public EntityBean cacheEmbeddedBeanLoad(CachedBeanData data, PersistenceContext context) {
        return this.cacheHelp.embeddedBeanLoad(data, context);
    }

    EntityBean cacheEmbeddedBeanLoadDirect(CachedBeanData data, PersistenceContext context) {
        return this.cacheHelp.embeddedBeanLoadDirect(data, context);
    }

    EntityBean cacheBeanLoadDirect(Object id, Boolean readOnly, CachedBeanData data, PersistenceContext context) {
        return this.cacheHelp.loadBeanDirect(id, readOnly, data, context);
    }

    public void cacheBeanPut(T bean) {
        this.cacheBeanPut((EntityBean)bean);
    }

    public void cacheBeanPut(EntityBean bean) {
        this.cacheHelp.beanCachePut(bean);
    }

    void cacheBeanPutDirect(EntityBean bean) {
        this.cacheHelp.beanCachePutDirect(bean);
    }

    public T cacheBeanGet(Object id, Boolean readOnly, PersistenceContext context) {
        return this.cacheHelp.beanCacheGet(id, readOnly, context);
    }

    public void cacheHandleDeleteById(Object id) {
        this.cacheHelp.beanCacheRemove(id);
    }

    public boolean cacheBeanLoad(EntityBean bean, EntityBeanIntercept ebi, Object id, PersistenceContext context) {
        return this.cacheHelp.beanCacheLoad(bean, ebi, id, context);
    }

    public boolean cacheBeanLoad(EntityBeanIntercept ebi, PersistenceContext context) {
        EntityBean bean = ebi.getOwner();
        Object id = this.getId(bean);
        return this.cacheBeanLoad(bean, ebi, id, context);
    }

    public Object cacheNaturalKeyIdLookup(SpiQuery<T> query) {
        return this.cacheHelp.naturalKeyIdLookup(query);
    }

    public void cacheNaturalKeyPut(Object id, Object newKey) {
        this.cacheHelp.cacheNaturalKeyPut(id, newKey);
    }

    public void cacheHandleBulkUpdate(TransactionEventTable.TableIUD tableIUD) {
        this.cacheHelp.handleBulkUpdate(tableIUD);
    }

    public void cacheHandleDeleteById(Object id, CacheChangeSet changeSet) {
        this.cacheHelp.handleDelete(id, changeSet);
    }

    public void cacheHandleDelete(Object id, PersistRequestBean<T> deleteRequest, CacheChangeSet changeSet) {
        this.cacheHelp.handleDelete(id, deleteRequest, changeSet);
    }

    public void cacheHandleInsert(PersistRequestBean<T> insertRequest, CacheChangeSet changeSet) {
        this.cacheHelp.handleInsert(insertRequest, changeSet);
    }

    public void cacheHandleUpdate(Object id, PersistRequestBean<T> updateRequest, CacheChangeSet changeSet) {
        this.cacheHelp.handleUpdate(id, updateRequest, changeSet);
    }

    public void cacheBeanUpdate(Object id, Map<String, Object> changes, boolean updateNaturalKey, long version) {
        this.cacheHelp.cacheBeanUpdate(id, changes, updateNaturalKey, version);
    }

    public void readAuditFutureList(SpiQuery<T> spiQuery) {
        if (this.isReadAuditing()) {
            ReadEvent event = new ReadEvent(this.fullName);
            this.readAuditPrepare(event);
            spiQuery.setFutureFetchAudit(event);
        }
    }

    public void readAuditBean(String queryKey, String bindLog, Object bean) {
        ReadEvent event = new ReadEvent(this.fullName, queryKey, bindLog, this.getIdForJson(bean));
        this.readAuditPrepare(event);
        this.getReadAuditLogger().auditBean(event);
    }

    private void readAuditPrepare(ReadEvent event) {
        ReadAuditPrepare prepare = this.getReadAuditPrepare();
        if (prepare != null) {
            prepare.prepare(event);
        }
    }

    public void readAuditMany(String queryKey, String bindLog, List<Object> ids) {
        ReadEvent event = new ReadEvent(this.fullName, queryKey, bindLog, ids);
        this.readAuditPrepare(event);
        this.getReadAuditLogger().auditMany(event);
    }

    public void readAuditFutureMany(ReadEvent event) {
        this.getReadAuditLogger().auditMany(event);
    }

    public String getBaseTableAlias() {
        return this.baseTableAlias;
    }

    public void preAllocateIds(int batchSize) {
        if (this.idGenerator != null) {
            this.idGenerator.preAllocateIds(batchSize);
        }
    }

    public Object nextId(Transaction t) {
        if (this.idGenerator != null) {
            return this.idGenerator.nextId(t);
        }
        return null;
    }

    public DeployPropertyParser createDeployPropertyParser() {
        return new DeployPropertyParser(this);
    }

    public String convertOrmUpdateToSql(String ormUpdateStatement) {
        return new DeployUpdateParser(this).parse(ormUpdateStatement);
    }

    @Override
    public List<MetaQueryPlanStatistic> collectQueryPlanStatistics(boolean reset) {
        return this.collectQueryPlanStatisticsInternal(reset, false);
    }

    @Override
    public List<MetaQueryPlanStatistic> collectAllQueryPlanStatistics(boolean reset) {
        return this.collectQueryPlanStatisticsInternal(reset, false);
    }

    public List<MetaQueryPlanStatistic> collectQueryPlanStatisticsInternal(boolean reset, boolean collectAll) {
        ArrayList<MetaQueryPlanStatistic> list = new ArrayList<MetaQueryPlanStatistic>(this.queryPlanCache.size());
        for (CQueryPlan queryPlan : this.queryPlanCache.values()) {
            CQueryPlanStats.Snapshot snapshot = queryPlan.getSnapshot(reset);
            if (!collectAll && snapshot.getExecutionCount() <= 0L) continue;
            list.add(snapshot);
        }
        return list;
    }

    public void clearQueryStatistics() {
        for (CQueryPlan queryPlan : this.queryPlanCache.values()) {
            queryPlan.resetStatistics();
        }
    }

    public void postLoad(Object bean) {
        if (this.beanPostLoad != null) {
            this.beanPostLoad.postLoad(bean);
        }
    }

    public CQueryPlan getQueryPlan(CQueryPlanKey key) {
        return this.queryPlanCache.get(key);
    }

    public void putQueryPlan(CQueryPlanKey key, CQueryPlan plan) {
        this.queryPlanCache.put(key, plan);
    }

    public SpiUpdatePlan getUpdatePlan(Integer key) {
        return this.updatePlanCache.get(key);
    }

    public void putUpdatePlan(Integer key, SpiUpdatePlan plan) {
        this.updatePlanCache.put(key, plan);
    }

    public boolean isUpdateChangesOnly() {
        return this.updateChangesOnly;
    }

    public boolean isSaveRecurseSkippable() {
        return this.saveRecurseSkippable;
    }

    public boolean isDeleteRecurseSkippable() {
        return this.deleteRecurseSkippable;
    }

    public boolean isDeleteByStatement() {
        return this.deleteRecurseSkippable && !this.isBeanCaching();
    }

    @Override
    public BeanProperty getWhenModifiedProperty() {
        return this.whenModifiedProperty;
    }

    @Override
    public BeanProperty getWhenCreatedProperty() {
        return this.whenCreatedProperty;
    }

    private BeanProperty findWhenCreatedProperty() {
        for (int i = 0; i < this.propertiesBaseScalar.length; ++i) {
            if (!this.propertiesBaseScalar[i].isGeneratedWhenCreated()) continue;
            return this.propertiesBaseScalar[i];
        }
        return null;
    }

    private BeanProperty findWhenModifiedProperty() {
        for (int i = 0; i < this.propertiesBaseScalar.length; ++i) {
            if (!this.propertiesBaseScalar[i].isGeneratedWhenModified()) continue;
            return this.propertiesBaseScalar[i];
        }
        return null;
    }

    public BeanPropertyAssocMany<?> getManyProperty(SpiQuery<?> query) {
        OrmQueryDetail detail = query.getDetail();
        for (int i = 0; i < this.propertiesMany.length; ++i) {
            if (!detail.includesPath(this.propertiesMany[i].getName())) continue;
            return this.propertiesMany[i];
        }
        return null;
    }

    public String getParentIdInExpr(int parentIdSize, String rawWhere) {
        String inClause = this.idBinder.getIdInValueExpr(parentIdSize);
        return this.idBinder.isIdInExpandedForm() ? inClause : rawWhere + inClause;
    }

    public IdBinder getIdBinder() {
        return this.idBinder;
    }

    public String getIdBinderIdSql() {
        return this.idBinderIdSql;
    }

    public String getIdBinderInLHSSql() {
        return this.idBinderInLHSSql;
    }

    public void bindId(DataBind dataBind, Object idValue) throws SQLException {
        this.idBinder.bindId(dataBind, idValue);
    }

    public Object[] getBindIdValues(Object idValue) {
        return this.idBinder.getBindValues(idValue);
    }

    @Override
    public T createBean() {
        return (T)this.createEntityBean();
    }

    public EntityBean createEntityBean() {
        try {
            EntityBean bean = (EntityBean)this.prototypeEntityBean._ebean_newInstance();
            if (this.unloadProperties.length > 0) {
                EntityBeanIntercept ebi = bean._ebean_getIntercept();
                for (int i = 0; i < this.unloadProperties.length; ++i) {
                    ebi.setPropertyUnloaded(this.unloadProperties[i]);
                }
            }
            return bean;
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public T createReference(Boolean readOnly, boolean disableLazyLoad, Object id, PersistenceContext pc) {
        Object shareableBean;
        CachedBeanData d;
        if (this.cacheSharableBeans && !disableLazyLoad && !Boolean.FALSE.equals(readOnly) && (d = this.cacheHelp.beanCacheGetData(id)) != null && (shareableBean = d.getSharableBean()) != null) {
            if (this.isReadAuditing()) {
                this.readAuditBean("ref", "", shareableBean);
            }
            return (T)shareableBean;
        }
        try {
            EntityBean eb = this.createEntityBean();
            id = this.convertSetId(id, eb);
            EntityBeanIntercept ebi = eb._ebean_getIntercept();
            if (disableLazyLoad) {
                ebi.setDisableLazyLoad(true);
            } else {
                ebi.setBeanLoader(this.ebeanServer);
            }
            ebi.setReference(this.idPropertyIndex);
            if (Boolean.TRUE == readOnly) {
                ebi.setReadOnly(true);
            }
            if (pc != null) {
                this.contextPut(pc, id, eb);
                ebi.setPersistenceContext(pc);
            }
            return (T)eb;
        }
        catch (Exception ex) {
            throw new PersistenceException((Throwable)ex);
        }
    }

    public BeanProperty getBeanPropertyFromPath(String path) {
        String[] split = SplitName.splitBegin(path);
        if (split[1] == null) {
            return this._findBeanProperty(split[0]);
        }
        BeanPropertyAssoc assocProp = (BeanPropertyAssoc)this._findBeanProperty(split[0]);
        BeanDescriptor targetDesc = assocProp.getTargetDescriptor();
        return targetDesc.getBeanPropertyFromPath(split[1]);
    }

    @Override
    public BeanType<?> getBeanTypeAtPath(String path) {
        return this.getBeanDescriptor(path);
    }

    public BeanDescriptor<?> getBeanDescriptor(String path) {
        if (path == null) {
            return this;
        }
        String[] splitBegin = SplitName.splitBegin(path);
        BeanProperty beanProperty = this.findBeanProperty(splitBegin[0]);
        if (beanProperty instanceof BeanPropertyAssoc) {
            BeanPropertyAssoc assocProp = (BeanPropertyAssoc)beanProperty;
            return assocProp.getTargetDescriptor().getBeanDescriptor(splitBegin[1]);
        }
        throw new PersistenceException("Invalid path " + path + " from " + this.getFullName());
    }

    public <U> BeanDescriptor<U> getBeanDescriptor(Class<U> otherType) {
        return this.owner.getBeanDescriptor(otherType);
    }

    public BeanPropertyAssocOne<?> getUnidirectional() {
        if (this.unidirectional != null) {
            return this.unidirectional;
        }
        if (this.inheritInfo != null && !this.inheritInfo.isRoot()) {
            return this.inheritInfo.getParent().desc().getUnidirectional();
        }
        return null;
    }

    public Object getValue(EntityBean bean, String property) {
        return this.getBeanProperty(property).getValue(bean);
    }

    public boolean isUseIdGenerator() {
        return this.idGenerator != null;
    }

    public String getDescriptorId() {
        return this.fullName;
    }

    @Override
    public Class<T> getBeanType() {
        return this.beanType;
    }

    @Override
    public String getFullName() {
        return this.fullName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    public String toString() {
        return this.fullName;
    }

    public Object contextGet(PersistenceContext pc, Object id) {
        return pc.get(this.rootBeanType, id);
    }

    public PersistenceContext.WithOption contextGetWithOption(PersistenceContext pc, Object id) {
        return pc.getWithOption(this.rootBeanType, id);
    }

    public void contextPut(PersistenceContext pc, Object id, Object bean) {
        pc.put(this.rootBeanType, id, bean);
    }

    public Object contextPutIfAbsent(PersistenceContext pc, Object id, EntityBean localBean) {
        return pc.putIfAbsent(this.rootBeanType, id, localBean);
    }

    public Object contextRef(PersistenceContext pc, Boolean readOnly, boolean disableLazyLoad, Object id) {
        return this.createReference(readOnly, disableLazyLoad, id, pc);
    }

    public void contextClear(PersistenceContext pc, Object idValue) {
        pc.clear(this.rootBeanType, idValue);
    }

    public void contextDeleted(PersistenceContext pc, Object idValue) {
        pc.deleted(this.rootBeanType, idValue);
    }

    public String getIdName() {
        return this.idProperty == null ? null : this.idProperty.getName();
    }

    public Object getId(EntityBean bean) {
        return this.idProperty == null ? null : this.idProperty.getValue(bean);
    }

    @Override
    public Object beanId(Object bean) {
        return this.getId((EntityBean)bean);
    }

    @Override
    public Object getBeanId(T bean) {
        return this.getId((EntityBean)bean);
    }

    public Object getIdForJson(Object bean) {
        return this.idBinder.getIdForJson((EntityBean)bean);
    }

    public Object convertIdFromJson(Object idValue) {
        return this.idBinder.convertIdFromJson(idValue);
    }

    public String getDefaultOrderBy() {
        return this.idBinder.getDefaultOrderBy();
    }

    public Object convertId(Object idValue) {
        return this.idBinder.convertId(idValue);
    }

    @Override
    public void setBeanId(T bean, Object idValue) {
        this.idBinder.convertSetId(idValue, (EntityBean)bean);
    }

    public Object convertSetId(Object idValue, EntityBean bean) {
        return this.idBinder.convertSetId(idValue, bean);
    }

    @Override
    public Property getProperty(String propName) {
        return this.findBeanProperty(propName);
    }

    public BeanProperty getBeanProperty(String propName) {
        return this.propMap.get(propName);
    }

    public void sort(List<T> list, String sortByClause) {
        ElComparator<T> comparator = this.getElComparator(sortByClause);
        Collections.sort(list, comparator);
    }

    public ElComparator<T> getElComparator(String propNameOrSortBy) {
        ElComparator<T> c = this.comparatorCache.get(propNameOrSortBy);
        if (c == null) {
            c = this.createComparator(propNameOrSortBy);
            this.comparatorCache.put(propNameOrSortBy, c);
        }
        return c;
    }

    public void lazyLoadRegister(String prefix, EntityBeanIntercept ebi, EntityBean bean, LoadContext loadContext) {
        BeanPropertyAssocMany<?>[] manys = this.propertiesMany();
        for (int i = 0; i < manys.length; ++i) {
            BeanCollection<?> ref;
            if (ebi.isLoadedProperty(manys[i].getPropertyIndex()) || (ref = manys[i].createReferenceIfNull(bean)) == null || ref.isRegisteredWithLoadContext()) continue;
            String path = SplitName.add(prefix, manys[i].getName());
            loadContext.register(path, ref);
        }
    }

    public boolean lazyLoadMany(EntityBeanIntercept ebi) {
        int lazyLoadProperty = ebi.getLazyLoadPropertyIndex();
        if (lazyLoadProperty == -1) {
            return false;
        }
        if (this.inheritInfo != null) {
            return super.lazyLoadMany(ebi, lazyLoadProperty);
        }
        return this.lazyLoadMany(ebi, lazyLoadProperty);
    }

    private boolean lazyLoadMany(EntityBeanIntercept ebi, int lazyLoadProperty) {
        BeanProperty lazyLoadBeanProp = this.propertiesIndex[lazyLoadProperty];
        if (lazyLoadBeanProp instanceof BeanPropertyAssocMany) {
            BeanPropertyAssocMany manyProp = (BeanPropertyAssocMany)lazyLoadBeanProp;
            manyProp.createReference(ebi.getOwner());
            ebi.setLoadedLazy();
            return true;
        }
        return false;
    }

    BeanDescriptor<?> descOf(Class<?> type) {
        return this.inheritInfo.readType(type).desc();
    }

    private ElComparator<T> createComparator(String sortByClause) {
        SortByClause sortBy = SortByClauseParser.parse(sortByClause);
        if (sortBy.size() == 1) {
            return this.createPropertyComparator(sortBy.getProperties().get(0));
        }
        ElComparator[] comparators = new ElComparator[sortBy.size()];
        List<SortByClause.Property> sortProps = sortBy.getProperties();
        for (int i = 0; i < sortProps.size(); ++i) {
            SortByClause.Property sortProperty = sortProps.get(i);
            comparators[i] = this.createPropertyComparator(sortProperty);
        }
        return new ElComparatorCompound(comparators);
    }

    private ElComparator<T> createPropertyComparator(SortByClause.Property sortProp) {
        ElPropertyValue elGetValue = this.getElGetValue(sortProp.getName());
        Boolean nullsHigh = sortProp.getNullsHigh();
        if (nullsHigh == null) {
            nullsHigh = Boolean.TRUE;
        }
        return new ElComparatorProperty(elGetValue, sortProp.isAscending(), nullsHigh);
    }

    @Override
    public boolean isValidExpression(String propertyName) {
        try {
            return this.getElGetValue(propertyName) != null;
        }
        catch (PersistenceException e) {
            return false;
        }
    }

    public ElPropertyValue getElGetValue(String propName) {
        ElPropertyValue elGetValue = this.elCache.get(propName);
        if (elGetValue != null) {
            return elGetValue;
        }
        elGetValue = this.buildElGetValue(propName, null, false);
        if (elGetValue != null) {
            this.elCache.put(propName, elGetValue);
        }
        return elGetValue;
    }

    @Override
    public ExpressionPath getExpressionPath(String path) {
        return this.getElGetValue(path);
    }

    public ElPropertyDeploy getElPropertyDeploy(String propName) {
        ElPropertyDeploy elProp = this.elDeployCache.get(propName);
        if (elProp != null) {
            return elProp;
        }
        elProp = !propName.contains(".") ? this.getElGetValue(propName) : this.buildElGetValue(propName, null, true);
        if (elProp != null) {
            this.elDeployCache.put(propName, elProp);
        }
        return elProp;
    }

    protected ElPropertyValue buildElGetValue(String propName, ElPropertyChainBuilder chain, boolean propertyDeploy) {
        ElPropertyDeploy fk;
        if (propertyDeploy && chain != null && (fk = this.elDeployCache.get(propName)) != null && fk instanceof BeanFkeyProperty) {
            return ((BeanFkeyProperty)fk).create(chain.getExpression(), chain.isContainsMany());
        }
        int basePos = propName.indexOf(46);
        if (basePos > -1) {
            String baseName = propName.substring(0, basePos);
            String remainder = propName.substring(basePos + 1);
            BeanProperty assocProp = this._findBeanProperty(baseName);
            if (assocProp == null) {
                return null;
            }
            return assocProp.buildElPropertyValue(propName, remainder, chain, propertyDeploy);
        }
        BeanProperty property = this._findBeanProperty(propName);
        if (chain == null) {
            return property;
        }
        if (property == null) {
            throw new PersistenceException("No property found for [" + propName + "] in expression " + chain.getExpression());
        }
        if (property.containsMany()) {
            chain.setContainsMany();
        }
        return chain.add(property).build();
    }

    public BeanProperty findBeanProperty(String propName) {
        int basePos = propName.indexOf(46);
        if (basePos > -1) {
            String baseName = propName.substring(0, basePos);
            return this._findBeanProperty(baseName);
        }
        return this._findBeanProperty(propName);
    }

    private BeanProperty _findBeanProperty(String propName) {
        BeanProperty prop = this.propMap.get(propName);
        if (prop == null && this.inheritInfo != null) {
            return this.inheritInfo.findSubTypeProperty(propName);
        }
        return prop;
    }

    public void resetManyProperties(Object dbBean) {
        EntityBean bean = (EntityBean)dbBean;
        for (int i = 0; i < this.propertiesMany.length; ++i) {
            if (!this.propertiesMany[i].isCascadeRefresh()) continue;
            this.propertiesMany[i].resetMany(bean);
        }
    }

    public String getServerName() {
        return this.serverName;
    }

    public boolean isCacheSharableBeans() {
        return this.cacheSharableBeans;
    }

    public boolean isAutoTunable() {
        return this.autoTunable;
    }

    public InheritInfo getInheritInfo() {
        return this.inheritInfo;
    }

    @Override
    public boolean hasInheritance() {
        return this.inheritInfo != null;
    }

    @Override
    public String getDiscColumn() {
        return this.inheritInfo.getDiscriminatorColumn();
    }

    public String getDiscValue() {
        return this.inheritInfo == null ? null : this.inheritInfo.getDiscriminatorStringValue();
    }

    @Override
    public T createBeanUsingDisc(Object discValue) {
        return (T)this.inheritInfo.getType(discValue.toString()).desc().createBean();
    }

    @Override
    public void addInheritanceWhere(SpiQuery<?> query) {
        if (this.inheritInfo != null && !this.inheritInfo.isRoot()) {
            query.where().eq(this.inheritInfo.getDiscriminatorColumn(), this.inheritInfo.getDiscriminatorValue());
        }
    }

    public boolean isEmbedded() {
        return EntityType.EMBEDDED == this.entityType;
    }

    public IndexDefinition[] getIndexDefinitions() {
        return this.indexDefinitions;
    }

    @Override
    public BeanPersistListener getPersistListener() {
        return this.persistListener;
    }

    public BeanFindController getBeanFinder() {
        return this.beanFinder;
    }

    @Override
    public BeanFindController getFindController() {
        return this.beanFinder;
    }

    @Override
    public BeanQueryAdapter getQueryAdapter() {
        return this.queryAdapter;
    }

    public void deregister(BeanPersistListener listener) {
        BeanPersistListener currentListener = this.persistListener;
        if (currentListener != null) {
            if (currentListener instanceof ChainedBeanPersistListener) {
                this.persistListener = ((ChainedBeanPersistListener)currentListener).deregister(listener);
            } else if (currentListener.equals(listener)) {
                this.persistListener = null;
            }
        }
    }

    public void deregister(BeanPersistController controller) {
        BeanPersistController currentController = this.persistController;
        if (currentController != null) {
            if (currentController instanceof ChainedBeanPersistController) {
                this.persistController = ((ChainedBeanPersistController)currentController).deregister(controller);
            } else if (currentController.equals(controller)) {
                this.persistController = null;
            }
        }
    }

    public void register(BeanPersistListener newPersistListener) {
        if (newPersistListener.isRegisterFor(this.beanType)) {
            BeanPersistListener currentListener = this.persistListener;
            this.persistListener = currentListener == null ? newPersistListener : (currentListener instanceof ChainedBeanPersistListener ? ((ChainedBeanPersistListener)currentListener).register(newPersistListener) : new ChainedBeanPersistListener(currentListener, newPersistListener));
        }
    }

    public void register(BeanPersistController newController) {
        if (newController.isRegisterFor(this.beanType)) {
            BeanPersistController currentController = this.persistController;
            this.persistController = currentController == null ? newController : (currentController instanceof ChainedBeanPersistController ? ((ChainedBeanPersistController)currentController).register(newController) : new ChainedBeanPersistController(currentController, newController));
        }
    }

    @Override
    public BeanPersistController getPersistController() {
        return this.persistController;
    }

    public boolean isRawSqlBased() {
        return EntityType.SQL == this.entityType;
    }

    public String getDbComment() {
        return this.dbComment;
    }

    public String[] getDependentTables() {
        return this.dependentTables;
    }

    @Override
    public String getBaseTable() {
        return this.baseTable;
    }

    public boolean isBaseTable() {
        return this.baseTable != null && this.entityType == EntityType.ORM;
    }

    public String getBaseTable(SpiQuery.TemporalMode mode) {
        switch (mode) {
            case DRAFT: {
                return this.draftTable;
            }
            case VERSIONS: {
                return this.baseTableVersionsBetween;
            }
            case AS_OF: {
                return this.baseTableAsOf;
            }
        }
        return this.baseTable;
    }

    public String getDraftTable() {
        return this.draftTable;
    }

    public boolean isReadAuditing() {
        return this.readAuditing;
    }

    public boolean isSoftDelete() {
        return this.softDelete;
    }

    public void setSoftDeleteValue(EntityBean bean) {
        this.softDeleteProperty.setSoftDeleteValue(bean);
    }

    public String getSoftDeleteDbSet() {
        return this.softDeleteProperty.getSoftDeleteDbSet();
    }

    public String getSoftDeletePredicate(String tableAlias) {
        return this.softDeleteProperty.getSoftDeleteDbPredicate(tableAlias);
    }

    public boolean isDraftable() {
        return this.draftable;
    }

    public boolean isDraftableElement() {
        return this.draftableElement;
    }

    public void setDraft(EntityBean entityBean) {
        if (this.draft != null) {
            this.draft.setValue(entityBean, true);
        }
    }

    public boolean isDraftInstance(EntityBean entityBean) {
        if (this.draft != null) {
            return Boolean.TRUE == this.draft.getValue(entityBean);
        }
        return false;
    }

    public boolean isLiveInstance(EntityBean entityBean) {
        if (this.draft != null) {
            return Boolean.FALSE == this.draft.getValue(entityBean);
        }
        return false;
    }

    public void setDraftDirty(EntityBean entityBean, boolean value) {
        if (this.draftDirty != null && !entityBean._ebean_getIntercept().isChangedProperty(this.draftDirty.getPropertyIndex())) {
            this.draftDirty.setValueIntercept(entityBean, value);
        }
    }

    public void draftQueryOptimise(Query<T> query) {
        query.setPersistenceContextScope(PersistenceContextScope.QUERY);
        this.draftHelp.draftQueryOptimise(query);
    }

    public boolean isHistorySupport() {
        return this.historySupport;
    }

    @Override
    public IdType getIdType() {
        return this.idType;
    }

    public boolean isIdTypePlatformDefault() {
        return this.idTypePlatformDefault;
    }

    @Override
    public String getSequenceName() {
        return this.sequenceName;
    }

    public int getSequenceInitialValue() {
        return this.sequenceInitialValue;
    }

    public int getSequenceAllocationSize() {
        return this.sequenceAllocationSize;
    }

    public String getSelectLastInsertedId() {
        return this.selectLastInsertedId;
    }

    public TableJoin[] tableJoins() {
        return this.derivedTableJoins;
    }

    @Override
    public Collection<? extends Property> allProperties() {
        return this.propertiesAll();
    }

    public Collection<BeanProperty> propertiesAll() {
        return this.propMap.values();
    }

    public BeanProperty[] propertiesNonTransient() {
        return this.propertiesNonTransient;
    }

    public BeanProperty[] propertiesTransient() {
        return this.propertiesTransient;
    }

    public BeanPropertyAssocOne<?>[] propertiesEmbedded() {
        return this.propertiesEmbedded;
    }

    public void setEmbeddedOwner(EntityBean bean) {
        for (int i = 0; i < this.propertiesEmbedded.length; ++i) {
            this.propertiesEmbedded[i].setEmbeddedOwner(bean);
        }
    }

    @Override
    public BeanProperty getIdProperty() {
        return this.idProperty;
    }

    public boolean isInsertMode(EntityBeanIntercept ebi, boolean insertMode) {
        if (ebi.isLoaded()) {
            return false;
        }
        if (this.idProperty.isEmbedded()) {
            return !ebi.isLoaded();
        }
        if (!this.hasIdValue(ebi.getOwner())) {
            return true;
        }
        return insertMode;
    }

    public boolean isReference(EntityBeanIntercept ebi) {
        return ebi.isReference() || this.hasIdPropertyOnly(ebi);
    }

    public boolean hasIdPropertyOnly(EntityBeanIntercept ebi) {
        return ebi.hasIdOnly(this.idPropertyIndex);
    }

    public boolean hasIdValue(EntityBean bean) {
        return this.idProperty != null && !DmlUtil.isNullOrZero(this.idProperty.getValue(bean));
    }

    public boolean hasVersionProperty(EntityBeanIntercept ebi) {
        return this.versionPropertyIndex > -1 && ebi.isLoadedProperty(this.versionPropertyIndex);
    }

    public long setVersion(EntityBean entityBean, Object versionValue) {
        this.versionProperty.setValueIntercept(entityBean, versionValue);
        return this.versionProperty.scalarType.asVersion(versionValue);
    }

    public long getVersion(EntityBean entityBean) {
        if (this.versionProperty == null) {
            return 0L;
        }
        Object value = this.versionProperty.getValue(entityBean);
        return value == null ? 0L : this.versionProperty.scalarType.asVersion(value);
    }

    public void checkMutableProperties(EntityBeanIntercept ebi) {
        for (int i = 0; i < this.propertiesMutable.length; ++i) {
            Object value;
            BeanProperty beanProperty = this.propertiesMutable[i];
            int propertyIndex = beanProperty.getPropertyIndex();
            if (ebi.isDirtyProperty(propertyIndex) || !ebi.isLoadedProperty(propertyIndex) || (value = beanProperty.getValue(ebi.getOwner())) != null && !beanProperty.isDirtyValue(value)) continue;
            ebi.markPropertyAsChanged(propertyIndex);
        }
    }

    public ConcurrencyMode getConcurrencyMode(EntityBeanIntercept ebi) {
        if (!this.hasVersionProperty(ebi)) {
            return ConcurrencyMode.NONE;
        }
        return this.concurrencyMode;
    }

    Map<String, ValuePair> diffFlatten(Map<String, ValuePair> diff) {
        return DiffHelp.flatten(diff, this);
    }

    public Map<String, ValuePair> diffForInsert(EntityBean newBean) {
        LinkedHashMap<String, ValuePair> map = new LinkedHashMap<String, ValuePair>();
        this.diffForInsert(null, map, newBean);
        return map;
    }

    public void diffForInsert(String prefix, Map<String, ValuePair> map, EntityBean newBean) {
        int i;
        for (i = 0; i < this.propertiesBaseScalar.length; ++i) {
            this.propertiesBaseScalar[i].diffForInsert(prefix, map, newBean);
        }
        for (i = 0; i < this.propertiesOne.length; ++i) {
            this.propertiesOne[i].diffForInsert(prefix, map, newBean);
        }
        for (i = 0; i < this.propertiesEmbedded.length; ++i) {
            this.propertiesEmbedded[i].diffForInsert(prefix, map, newBean);
        }
    }

    public Map<String, ValuePair> diff(EntityBean newBean, EntityBean oldBean) {
        LinkedHashMap<String, ValuePair> map = new LinkedHashMap<String, ValuePair>();
        this.diff(null, map, newBean, oldBean);
        return map;
    }

    public void diff(String prefix, Map<String, ValuePair> map, EntityBean newBean, EntityBean oldBean) {
        int i;
        for (i = 0; i < this.propertiesBaseScalar.length; ++i) {
            this.propertiesBaseScalar[i].diff(prefix, map, newBean, oldBean);
        }
        for (i = 0; i < this.propertiesOne.length; ++i) {
            this.propertiesOne[i].diff(prefix, map, newBean, oldBean);
        }
        for (i = 0; i < this.propertiesEmbedded.length; ++i) {
            this.propertiesEmbedded[i].diff(prefix, map, newBean, oldBean);
        }
    }

    public void appendOrderById(SpiQuery<T> query) {
        if (this.idProperty != null && !this.idProperty.isEmbedded()) {
            OrderBy<T> orderBy = query.getOrderBy();
            if (orderBy == null || orderBy.isEmpty()) {
                RawSql rawSql = query.getRawSql();
                if (rawSql != null) {
                    query.order(rawSql.getSql().getOrderBy());
                }
                query.order().asc(this.idProperty.getName());
            } else if (!orderBy.containsProperty(this.idProperty.getName())) {
                query.order().asc(this.idProperty.getName());
            }
        }
    }

    public BeanPropertyAssocOne<?>[] propertiesOne() {
        return this.propertiesOne;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneImported() {
        return this.propertiesOneImported;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneImportedSave() {
        return this.propertiesOneImportedSave;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneImportedDelete() {
        return this.propertiesOneImportedDelete;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneExportedSave() {
        return this.propertiesOneExportedSave;
    }

    public BeanPropertyAssocOne<?>[] propertiesOneExportedDelete() {
        return this.propertiesOneExportedDelete;
    }

    public BeanProperty[] propertiesNonMany() {
        return this.propertiesNonMany;
    }

    public BeanPropertyAssocMany<?>[] propertiesMany() {
        return this.propertiesMany;
    }

    public BeanPropertyAssocMany<?>[] propertiesManySave() {
        return this.propertiesManySave;
    }

    public BeanPropertyAssocMany<?>[] propertiesManyDelete() {
        return this.propertiesManyDelete;
    }

    public BeanPropertyAssocMany<?>[] propertiesManyToMany() {
        return this.propertiesManyToMany;
    }

    public BeanProperty getVersionProperty() {
        return this.versionProperty;
    }

    public BeanProperty[] propertiesBaseScalar() {
        return this.propertiesBaseScalar;
    }

    public BeanPropertyCompound[] propertiesBaseCompound() {
        return this.propertiesBaseCompound;
    }

    public BeanProperty[] propertiesLocal() {
        return this.propertiesLocal;
    }

    public void jsonWriteDirty(WriteJson writeJson, EntityBean bean, boolean[] dirtyProps) throws IOException {
        this.jsonHelp.jsonWriteDirty(writeJson, bean, dirtyProps);
    }

    protected void jsonWriteDirtyProperties(WriteJson writeJson, EntityBean bean, boolean[] dirtyProps) throws IOException {
        this.jsonHelp.jsonWriteDirtyProperties(writeJson, bean, dirtyProps);
    }

    public void jsonWrite(WriteJson writeJson, EntityBean bean) throws IOException {
        this.jsonHelp.jsonWrite(writeJson, bean, null);
    }

    public void jsonWrite(WriteJson writeJson, EntityBean bean, String key) throws IOException {
        this.jsonHelp.jsonWrite(writeJson, bean, key);
    }

    protected void jsonWriteProperties(WriteJson writeJson, EntityBean bean) throws IOException {
        this.jsonHelp.jsonWriteProperties(writeJson, bean);
    }

    public T jsonRead(ReadJson jsonRead, String path) throws IOException {
        return this.jsonHelp.jsonRead(jsonRead, path);
    }

    protected T jsonReadObject(ReadJson jsonRead, String path) throws IOException {
        return this.jsonHelp.jsonReadObject(jsonRead, path);
    }

    public static enum EntityType {
        ORM,
        EMBEDDED,
        VIEW,
        SQL;

    }
}

