/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core.bootup;

import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Set;
import java.util.jar.Attributes;
import java.util.jar.Manifest;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class ManifestReader {
    private static final Logger logger = LoggerFactory.getLogger(ManifestReader.class);
    private final Set<String> packageSet = new HashSet<String>();

    ManifestReader() {
    }

    static Set<String> readManifests(ClassLoader classLoader, String resourcePath) {
        return new ManifestReader().read(classLoader, resourcePath);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Set<String> read(ClassLoader classLoader, String resourcePath) {
        try {
            Enumeration<URL> resources = classLoader.getResources(resourcePath);
            while (resources.hasMoreElements()) {
                InputStream is = resources.nextElement().openStream();
                try {
                    this.read(new Manifest(is));
                }
                finally {
                    this.close(is);
                }
            }
        }
        catch (IOException e) {
            logger.warn("Error reading META-INF/ebean.mf manifest resources", (Throwable)e);
        }
        return this.packageSet;
    }

    private void close(InputStream is) {
        try {
            is.close();
        }
        catch (IOException e) {
            logger.warn("Error closing manifest InputStream", (Throwable)e);
        }
    }

    private void read(Manifest manifest) throws IOException {
        Attributes attributes = manifest.getMainAttributes();
        String packages = attributes.getValue("packages");
        if (packages != null) {
            this.add(packages);
        }
    }

    private void add(String packages) {
        String[] split = packages.split(",|;| ");
        for (int i = 0; i < split.length; ++i) {
            String pkg = split[i].trim();
            if (pkg.isEmpty()) continue;
            this.packageSet.add(pkg);
        }
    }
}

