/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.PersistenceContextScope;
import com.avaje.ebean.QueryEachConsumer;
import com.avaje.ebean.QueryEachWhileConsumer;
import com.avaje.ebean.RawSql;
import com.avaje.ebean.Version;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebean.event.BeanFindController;
import com.avaje.ebean.event.BeanQueryAdapter;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebean.text.json.JsonReadOptions;
import com.avaje.ebeaninternal.api.BeanIdList;
import com.avaje.ebeaninternal.api.CQueryPlanKey;
import com.avaje.ebeaninternal.api.HashQuery;
import com.avaje.ebeaninternal.api.LoadContext;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiQuerySecondary;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.BeanRequest;
import com.avaje.ebeaninternal.server.core.OrmQueryEngine;
import com.avaje.ebeaninternal.server.core.QueryIterator;
import com.avaje.ebeaninternal.server.core.SpiOrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.DeployParser;
import com.avaje.ebeaninternal.server.deploy.DeployPropertyParserMap;
import com.avaje.ebeaninternal.server.loadcontext.DLoadContext;
import com.avaje.ebeaninternal.server.query.CQueryPlan;
import com.avaje.ebeaninternal.server.query.CancelableQuery;
import com.avaje.ebeaninternal.server.transaction.DefaultPersistenceContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.Map;
import java.util.Set;
import javax.persistence.PersistenceException;

public final class OrmQueryRequest<T>
extends BeanRequest
implements BeanQueryRequest<T>,
SpiOrmQueryRequest<T> {
    private final BeanDescriptor<T> beanDescriptor;
    private final OrmQueryEngine queryEngine;
    private final SpiQuery<T> query;
    private final BeanFindController finder;
    private final Boolean readOnly;
    private final RawSql rawSql;
    private LoadContext loadContext;
    private PersistenceContext persistenceContext;
    private JsonReadOptions jsonRead;
    private HashQuery cacheKey;
    private CQueryPlanKey queryPlanKey;
    private SpiQuerySecondary secondaryQueries;

    public OrmQueryRequest(SpiEbeanServer server, OrmQueryEngine queryEngine, SpiQuery<T> query, SpiTransaction t) {
        super(server, t);
        this.beanDescriptor = query.getBeanDescriptor();
        this.rawSql = query.getRawSql();
        this.finder = this.beanDescriptor.getBeanFinder();
        this.queryEngine = queryEngine;
        this.query = query;
        this.readOnly = query.isReadOnly();
    }

    @Override
    public void markNotQueryOnly() {
        this.transaction.markNotQueryOnly();
    }

    @Override
    public String getDBLikeClause() {
        return this.ebeanServer.getDatabasePlatform().getLikeClause();
    }

    @Override
    public void executeSecondaryQueries(boolean forEach) {
        if (this.loadContext != null) {
            this.loadContext.executeSecondaryQueries(this, forEach);
        }
    }

    public int getSecondaryQueriesMinBatchSize(int defaultQueryBatch) {
        return this.loadContext.getSecondaryQueriesMinBatchSize(defaultQueryBatch);
    }

    public Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public BeanDescriptor<T> getBeanDescriptor() {
        return this.beanDescriptor;
    }

    public LoadContext getGraphContext() {
        return this.loadContext;
    }

    @Override
    public boolean isUseDocStore() {
        return this.query.isUseDocStore();
    }

    private void adapterPreQuery() {
        BeanQueryAdapter queryAdapter = this.beanDescriptor.getQueryAdapter();
        if (queryAdapter != null) {
            queryAdapter.preQuery(this);
        }
    }

    public void prepareQuery() {
        this.adapterPreQuery();
        this.secondaryQueries = this.query.convertJoins();
        this.queryPlanKey = this.query.prepare(this);
    }

    public boolean isRawSql() {
        return this.rawSql != null;
    }

    public DeployParser createDeployParser() {
        if (this.rawSql != null) {
            return new DeployPropertyParserMap(this.rawSql.getColumnMapping().getMapping());
        }
        return this.beanDescriptor.createDeployPropertyParser();
    }

    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    public void persistenceContextAdd(EntityBean bean) {
        Object id = this.beanDescriptor.getId(bean);
        this.beanDescriptor.contextPut(this.persistenceContext, id, bean);
    }

    @Override
    public void initTransIfRequired() {
        if (this.transaction == null) {
            this.transaction = this.ebeanServer.getCurrentServerTransaction();
            if (this.transaction == null) {
                this.transaction = this.ebeanServer.createQueryTransaction();
                this.createdTransaction = true;
            }
        }
        this.persistenceContext = this.getPersistenceContext(this.query, this.transaction);
        this.loadContext = new DLoadContext(this, this.secondaryQueries);
    }

    @Override
    public JsonReadOptions createJsonReadOptions() {
        this.persistenceContext = this.getPersistenceContext(this.query, this.transaction);
        if (this.query.getPersistenceContext() == null) {
            this.query.setPersistenceContext(this.persistenceContext);
        }
        this.jsonRead = new JsonReadOptions();
        this.jsonRead.setPersistenceContext(this.persistenceContext);
        if (!this.query.isDisableLazyLoading()) {
            this.loadContext = new DLoadContext(this, this.secondaryQueries);
            this.jsonRead.setLoadContext(this.loadContext);
        }
        return this.jsonRead;
    }

    public void flushPersistenceContextOnIterate() {
        this.persistenceContext = new DefaultPersistenceContext();
        this.loadContext.resetPersistenceContext(this.persistenceContext);
        if (this.jsonRead != null) {
            this.jsonRead.setPersistenceContext(this.persistenceContext);
            this.jsonRead.setLoadContext(this.loadContext);
        }
    }

    private PersistenceContext getPersistenceContext(SpiQuery<?> query, SpiTransaction t) {
        PersistenceContext ctx = query.getPersistenceContext();
        if (ctx != null) {
            return ctx;
        }
        PersistenceContextScope scope = this.ebeanServer.getPersistenceContextScope(query);
        return scope == PersistenceContextScope.QUERY || t == null ? new DefaultPersistenceContext() : t.getPersistenceContext();
    }

    @Override
    public void endTransIfRequired() {
        if (this.createdTransaction) {
            this.transaction.commit();
        }
    }

    public boolean isFindById() {
        return this.query.getType() == SpiQuery.Type.BEAN;
    }

    @Override
    public int delete() {
        return this.queryEngine.delete(this);
    }

    @Override
    public int update() {
        return this.queryEngine.update(this);
    }

    @Override
    public Object findId() {
        return this.queryEngine.findId(this);
    }

    @Override
    public int findRowCount() {
        return this.queryEngine.findRowCount(this);
    }

    @Override
    public List<Object> findIds() {
        BeanIdList idList = this.queryEngine.findIds(this);
        return idList.getIdList();
    }

    @Override
    public void findEach(QueryEachConsumer<T> consumer) {
        QueryIterator it = this.queryEngine.findIterate(this);
        try {
            while (it.hasNext()) {
                consumer.accept(it.next());
            }
        }
        finally {
            it.close();
        }
    }

    @Override
    public void findEachWhile(QueryEachWhileConsumer<T> consumer) {
        QueryIterator it = this.queryEngine.findIterate(this);
        try {
            while (it.hasNext() && consumer.accept(it.next())) {
            }
        }
        finally {
            it.close();
        }
    }

    @Override
    public QueryIterator<T> findIterate() {
        return this.queryEngine.findIterate(this);
    }

    @Override
    public List<T> findList() {
        return (List)((Object)this.queryEngine.findMany(this));
    }

    @Override
    public List<Version<T>> findVersions() {
        return this.queryEngine.findVersions(this);
    }

    @Override
    public Set<?> findSet() {
        return (Set)((Object)this.queryEngine.findMany(this));
    }

    @Override
    public Map<?, ?> findMap() {
        String mapKey = this.query.getMapKey();
        if (mapKey == null) {
            BeanProperty idProp = this.beanDescriptor.getIdProperty();
            if (idProp != null) {
                this.query.setMapKey(idProp.getName());
            } else {
                throw new PersistenceException("No mapKey specified for query");
            }
        }
        return (Map)((Object)this.queryEngine.findMany(this));
    }

    public BeanFindController getBeanFinder() {
        return this.finder;
    }

    @Override
    public SpiQuery<T> getQuery() {
        return this.query;
    }

    public BeanPropertyAssocMany<?> getManyProperty() {
        return this.beanDescriptor.getManyProperty(this.query);
    }

    public CQueryPlan getQueryPlan() {
        return this.beanDescriptor.getQueryPlan(this.queryPlanKey);
    }

    public CQueryPlanKey getQueryPlanKey() {
        return this.queryPlanKey;
    }

    public void putQueryPlan(CQueryPlan queryPlan) {
        this.beanDescriptor.putQueryPlan(this.queryPlanKey, queryPlan);
    }

    public boolean isUseBeanCache() {
        return this.query.isUseBeanCache();
    }

    @Override
    public BeanCollection<T> getFromQueryCache() {
        if (!this.query.isUseQueryCache()) {
            return null;
        }
        this.cacheKey = this.query.queryHash();
        BeanCollection<T> cached = this.beanDescriptor.queryCacheGet(this.cacheKey);
        if (cached != null && this.isAuditReads() && this.readAuditQueryType()) {
            Collection<T> actualDetails = cached.getActualDetails();
            ArrayList<Object> ids = new ArrayList<Object>(actualDetails.size());
            for (T bean : actualDetails) {
                ids.add(this.beanDescriptor.getIdForJson(bean));
            }
            this.beanDescriptor.readAuditMany(this.queryPlanKey.getPartialKey(), "l2-query-cache", ids);
        }
        return cached;
    }

    private boolean readAuditQueryType() {
        SpiQuery.Type type = this.query.getType();
        switch (type) {
            case BEAN: 
            case ITERATE: 
            case LIST: 
            case SET: 
            case MAP: {
                return true;
            }
        }
        return false;
    }

    public void putToQueryCache(BeanCollection<T> queryResult) {
        this.beanDescriptor.queryCachePut(this.cacheKey, queryResult);
    }

    public void setCancelableQuery(CancelableQuery cancelableQuery) {
        this.query.setCancelableQuery(cancelableQuery);
    }

    public void logSql(String sql) {
        this.transaction.logSql(sql);
    }

    public boolean isLogSecondaryQuery() {
        return this.query.isLogSecondaryQuery();
    }

    public int getLazyLoadBatchSize() {
        int batchSize = this.query.getLazyLoadBatchSize();
        return batchSize > 0 ? batchSize : this.ebeanServer.getLazyLoadBatchSize();
    }

    public boolean isAuditReads() {
        return !this.query.isDisableReadAudit() && this.beanDescriptor.isReadAuditing();
    }

    public String getBaseTableAlias() {
        return this.query.getAlias() == null ? this.beanDescriptor.getBaseTableAlias() : this.query.getAlias();
    }

    public void setDefaultFetchBuffer(int fetchSize) {
        this.query.setDefaultFetchBuffer(fetchSize);
    }
}

