/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.ValuePair;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;

public class DiffHelp {
    private DiffHelp() {
    }

    public static Map<String, ValuePair> diff(Object newBean, Object oldBean, BeanDescriptor<?> desc) {
        if (!(newBean instanceof EntityBean)) {
            throw new IllegalArgumentException("First bean expected to be an enhanced EntityBean? bean:" + newBean);
        }
        if (oldBean != null) {
            if (!(oldBean instanceof EntityBean)) {
                throw new IllegalArgumentException("Second bean expected to be an enhanced EntityBean? bean:" + oldBean);
            }
            if (!newBean.getClass().isAssignableFrom(oldBean.getClass())) {
                throw new IllegalArgumentException("Second bean not assignable to the first bean?");
            }
        }
        if (oldBean == null) {
            return ((EntityBean)newBean)._ebean_getIntercept().getDirtyValues();
        }
        return desc.diff((EntityBean)newBean, (EntityBean)oldBean);
    }

    public static Map<String, ValuePair> flatten(Map<String, ValuePair> values, BeanDescriptor<?> desc) {
        LinkedHashMap<String, ValuePair> flattened = null;
        Iterator<Map.Entry<String, ValuePair>> iterator = values.entrySet().iterator();
        while (iterator.hasNext()) {
            BeanPropertyAssocOne assoc;
            Map.Entry<String, ValuePair> entry = iterator.next();
            BeanProperty beanProperty = desc.getBeanProperty(entry.getKey());
            if (beanProperty instanceof BeanPropertyAssocMany) {
                iterator.remove();
                continue;
            }
            if (!(beanProperty instanceof BeanPropertyAssocOne) || (assoc = (BeanPropertyAssocOne)beanProperty).isEmbedded()) continue;
            if (flattened == null) {
                flattened = new LinkedHashMap<String, ValuePair>();
            }
            DiffHelp.flattenToId(flattened, entry, beanProperty, assoc);
            iterator.remove();
        }
        if (flattened != null) {
            values.putAll(flattened);
        }
        return values;
    }

    private static void flattenToId(Map<String, ValuePair> flattened, Map.Entry<String, ValuePair> entry, BeanProperty beanProperty, BeanPropertyAssocOne assoc) {
        BeanDescriptor oneDesc = assoc.getTargetDescriptor();
        ValuePair value = entry.getValue();
        Object newId = value.getNewValue() == null ? null : oneDesc.getId((EntityBean)value.getNewValue());
        Object oldId = value.getOldValue() == null ? null : oneDesc.getId((EntityBean)value.getOldValue());
        String propName = beanProperty.getName() + "." + oneDesc.getIdProperty().getName();
        flattened.put(propName, new ValuePair(newId, oldId));
    }
}

