/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.cache.ServerCacheFactory;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebean.cache.ServerCacheOptions;
import com.avaje.ebean.cache.ServerCachePlugin;
import com.avaje.ebean.common.SpiContainer;
import com.avaje.ebean.config.ContainerConfig;
import com.avaje.ebean.config.PropertyMap;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.UnderscoreNamingConvention;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.dbmigration.DbOffline;
import com.avaje.ebeaninternal.api.SpiBackgroundExecutor;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.cache.DefaultServerCacheManager;
import com.avaje.ebeaninternal.server.cache.DefaultServerCachePlugin;
import com.avaje.ebeaninternal.server.cluster.ClusterManager;
import com.avaje.ebeaninternal.server.core.DatabasePlatformFactory;
import com.avaje.ebeaninternal.server.core.DefaultBackgroundExecutor;
import com.avaje.ebeaninternal.server.core.DefaultServer;
import com.avaje.ebeaninternal.server.core.InternalConfiguration;
import com.avaje.ebeaninternal.server.core.JndiDataSourceLookup;
import com.avaje.ebeaninternal.server.core.bootup.BootupClassPathSearch;
import com.avaje.ebeaninternal.server.core.bootup.BootupClasses;
import com.avaje.ebeaninternal.server.lib.ShutdownManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.avaje.datasource.DataSourceAlertFactory;
import org.avaje.datasource.DataSourceConfig;
import org.avaje.datasource.DataSourceFactory;
import org.avaje.datasource.DataSourcePoolListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContainer
implements SpiContainer {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.avaje.ebean.internal.DefaultContainer");
    private final ClusterManager clusterManager;
    private final JndiDataSourceLookup jndiDataSourceFactory;

    public DefaultContainer(ContainerConfig containerConfig) {
        this.clusterManager = new ClusterManager(containerConfig);
        this.jndiDataSourceFactory = new JndiDataSourceLookup();
        ShutdownManager.registerContainer(this);
    }

    @Override
    public void shutdown() {
        this.clusterManager.shutdown();
    }

    @Override
    public SpiEbeanServer createServer(String name) {
        ServerConfig config = new ServerConfig();
        config.setName(name);
        Properties prop = PropertyMap.defaultProperties();
        config.loadFromProperties(prop);
        return this.createServer(config);
    }

    private SpiBackgroundExecutor createBackgroundExecutor(ServerConfig serverConfig) {
        String namePrefix = "ebean-" + serverConfig.getName();
        int schedulePoolSize = serverConfig.getBackgroundExecutorSchedulePoolSize();
        int shutdownSecs = serverConfig.getBackgroundExecutorShutdownSecs();
        return new DefaultBackgroundExecutor(schedulePoolSize, shutdownSecs, namePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpiEbeanServer createServer(ServerConfig serverConfig) {
        DefaultContainer defaultContainer = this;
        synchronized (defaultContainer) {
            this.setNamingConvention(serverConfig);
            BootupClasses bootupClasses = this.getBootupClasses(serverConfig);
            this.setDataSource(serverConfig);
            boolean online = this.checkDataSource(serverConfig);
            this.setDatabasePlatform(serverConfig);
            if (serverConfig.getDbEncrypt() != null) {
                serverConfig.getDatabasePlatform().setDbEncrypt(serverConfig.getDbEncrypt());
            }
            serverConfig.getNamingConvention().setDatabasePlatform(serverConfig.getDatabasePlatform());
            SpiBackgroundExecutor executor = this.createBackgroundExecutor(serverConfig);
            ServerCacheManager cacheManager = this.getCacheManager(online, serverConfig, executor);
            InternalConfiguration c = new InternalConfiguration(this.clusterManager, cacheManager, executor, serverConfig, bootupClasses);
            DefaultServer server = new DefaultServer(c, cacheManager);
            if (!DbOffline.isGenerateMigration()) {
                server.executePlugins(online);
                server.initialise();
                if (online && this.clusterManager.isClustering()) {
                    this.clusterManager.registerServer(server);
                }
                server.start();
            }
            DbOffline.reset();
            return server;
        }
    }

    private ServerCacheManager getCacheManager(boolean online, ServerConfig serverConfig, BackgroundExecutor executor) {
        if (!online || serverConfig.isDisableL2Cache()) {
            return new DefaultServerCacheManager();
        }
        ServerCacheManager serverCacheManager = serverConfig.getServerCacheManager();
        if (serverCacheManager != null) {
            return serverCacheManager;
        }
        ServerCacheOptions beanOptions = new ServerCacheOptions();
        beanOptions.setMaxSize(serverConfig.getCacheMaxSize());
        beanOptions.setMaxIdleSecs(serverConfig.getCacheMaxIdleTime());
        beanOptions.setMaxSecsToLive(serverConfig.getCacheMaxTimeToLive());
        ServerCacheOptions queryOptions = new ServerCacheOptions();
        queryOptions.setMaxSize(serverConfig.getQueryCacheMaxSize());
        queryOptions.setMaxIdleSecs(serverConfig.getQueryCacheMaxIdleTime());
        queryOptions.setMaxSecsToLive(serverConfig.getQueryCacheMaxTimeToLive());
        boolean localL2Caching = false;
        ServerCachePlugin plugin = serverConfig.getServerCachePlugin();
        if (plugin == null) {
            ServiceLoader<ServerCachePlugin> cacheFactories = ServiceLoader.load(ServerCachePlugin.class);
            Iterator<ServerCachePlugin> iterator = cacheFactories.iterator();
            if (iterator.hasNext()) {
                plugin = iterator.next();
                logger.debug("using ServerCacheFactory {}", plugin.getClass());
            } else {
                localL2Caching = true;
                plugin = new DefaultServerCachePlugin();
            }
        }
        ServerCacheFactory factory = plugin.create(serverConfig, executor);
        return new DefaultServerCacheManager(localL2Caching, factory, beanOptions, queryOptions);
    }

    private BootupClasses getBootupClasses(ServerConfig serverConfig) {
        BootupClasses bootup = this.getBootupClasses1(serverConfig);
        bootup.addIdGenerators(serverConfig.getIdGenerators());
        bootup.addPersistControllers(serverConfig.getPersistControllers());
        bootup.addPostLoaders(serverConfig.getPostLoaders());
        bootup.addFindControllers(serverConfig.getFindControllers());
        bootup.addTransactionEventListeners(serverConfig.getTransactionEventListeners());
        bootup.addPersistListeners(serverConfig.getPersistListeners());
        bootup.addQueryAdapters(serverConfig.getQueryAdapters());
        bootup.addServerConfigStartup(serverConfig.getServerConfigStartupListeners());
        bootup.addChangeLogInstances(serverConfig);
        bootup.runServerConfigStartup(serverConfig);
        return bootup;
    }

    private BootupClasses getBootupClasses1(ServerConfig serverConfig) {
        List<Class<?>> entityClasses = serverConfig.getClasses();
        if (serverConfig.isDisableClasspathSearch() || entityClasses != null && !entityClasses.isEmpty()) {
            return new BootupClasses(entityClasses);
        }
        return BootupClassPathSearch.search(serverConfig);
    }

    private void setNamingConvention(ServerConfig config) {
        if (config.getNamingConvention() == null) {
            config.setNamingConvention(new UnderscoreNamingConvention());
        }
    }

    private void setDatabasePlatform(ServerConfig config) {
        DatabasePlatform dbPlatform = config.getDatabasePlatform();
        if (dbPlatform == null) {
            DatabasePlatformFactory factory = new DatabasePlatformFactory();
            DatabasePlatform db = factory.create(config);
            db.configure(config);
            config.setDatabasePlatform(db);
            logger.info("DatabasePlatform name:" + config.getName() + " platform:" + db.getName());
        }
    }

    private void setDataSource(ServerConfig config) {
        if (config.getDataSource() == null) {
            config.setDataSource(this.getDataSourceFromConfig(config));
        }
    }

    private DataSource getDataSourceFromConfig(ServerConfig config) {
        if (DbOffline.isSet()) {
            logger.debug("... DbOffline using platform [{}]", (Object)DbOffline.getPlatform());
            return null;
        }
        if (config.getDataSourceJndiName() != null) {
            DataSource ds = this.jndiDataSourceFactory.lookup(config.getDataSourceJndiName());
            if (ds == null) {
                throw new PersistenceException("JNDI lookup for DataSource " + config.getDataSourceJndiName() + " returned null.");
            }
            return ds;
        }
        DataSourceConfig dsConfig = config.getDataSourceConfig();
        if (dsConfig == null) {
            throw new PersistenceException("No DataSourceConfig defined for " + config.getName());
        }
        if (dsConfig.isOffline()) {
            if (config.getDatabasePlatformName() == null) {
                throw new PersistenceException("You MUST specify a DatabasePlatformName on ServerConfig when offline");
            }
            return null;
        }
        DataSourceFactory factory = config.service(DataSourceFactory.class);
        if (factory == null) {
            throw new IllegalStateException("No DataSourceFactory service implementation found in class path. Probably missing dependency to avaje-datasource?");
        }
        DataSourceAlertFactory alertFactory = config.service(DataSourceAlertFactory.class);
        if (alertFactory != null) {
            dsConfig.setAlert(alertFactory.createAlert());
        }
        this.attachListener(config, dsConfig);
        return factory.createPool(config.getName(), dsConfig);
    }

    private void attachListener(ServerConfig config, DataSourceConfig dsConfig) {
        String poolListener;
        if (dsConfig.getListener() == null && (poolListener = dsConfig.getPoolListener()) != null) {
            dsConfig.setListener((DataSourcePoolListener)config.getClassLoadConfig().newInstance(poolListener));
        }
    }

    private boolean checkDataSource(ServerConfig serverConfig) {
        if (DbOffline.isSet()) {
            return false;
        }
        if (serverConfig.getDataSource() == null) {
            if (serverConfig.getDataSourceConfig().isOffline()) {
                return false;
            }
            throw new RuntimeException("DataSource not set?");
        }
        Connection c = null;
        try {
            c = serverConfig.getDataSource().getConnection();
            if (c.getAutoCommit()) {
                logger.warn("DataSource [{}] has autoCommit defaulting to true!", (Object)serverConfig.getName());
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException ex) {
                    logger.error("Error closing connection", (Throwable)ex);
                }
            }
        }
    }
}

