/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.timezone.DataTimeZone;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class BeanRequest {
    private static final Logger log = LoggerFactory.getLogger(BeanRequest.class);
    protected final SpiEbeanServer ebeanServer;
    protected SpiTransaction transaction;
    protected boolean createdTransaction;

    public BeanRequest(SpiEbeanServer ebeanServer, SpiTransaction t) {
        this.ebeanServer = ebeanServer;
        this.transaction = t;
    }

    public boolean createImplicitTransIfRequired() {
        if (this.transaction != null) {
            return false;
        }
        this.transaction = this.ebeanServer.getCurrentServerTransaction();
        if (this.transaction == null || !this.transaction.isActive()) {
            this.transaction = this.ebeanServer.createServerTransaction(false, -1);
            this.createdTransaction = true;
        }
        return true;
    }

    public void commitTransIfRequired() {
        if (this.createdTransaction) {
            this.transaction.commit();
        }
    }

    public void rollbackTransIfRequired() {
        if (this.createdTransaction) {
            try {
                this.transaction.rollback();
            }
            catch (Exception e) {
                log.error("Error trying to rollback a transaction (after a prior exception thrown)", (Throwable)e);
            }
        }
    }

    public EbeanServer getEbeanServer() {
        return this.ebeanServer;
    }

    public SpiEbeanServer getServer() {
        return this.ebeanServer;
    }

    public SpiTransaction getTransaction() {
        return this.transaction;
    }

    public boolean isLogSql() {
        return this.transaction.isLogSql();
    }

    public boolean isLogSummary() {
        return this.transaction.isLogSummary();
    }

    public DataTimeZone getDataTimeZone() {
        return this.ebeanServer.getDataTimeZone();
    }
}

