/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.changelog;

import com.avaje.ebean.ValuePair;
import com.avaje.ebean.event.changelog.BeanChange;
import com.avaje.ebean.event.changelog.ChangeSet;
import com.avaje.ebean.event.changelog.ChangeType;
import com.avaje.ebean.text.json.JsonContext;
import com.fasterxml.jackson.core.JsonFactory;
import com.fasterxml.jackson.core.JsonGenerator;
import java.io.IOException;
import java.io.Writer;
import java.util.Map;

public class ChangeJsonBuilder {
    protected final JsonFactory jsonFactory = new JsonFactory();
    protected final JsonContext json;

    protected ChangeJsonBuilder(JsonContext json) {
        this.json = json;
    }

    public void writeBeanJson(Writer writer, BeanChange bean, ChangeSet changeSet, int position) throws IOException {
        JsonGenerator generator = this.jsonFactory.createGenerator(writer);
        this.writeBeanChange(generator, bean, changeSet, position);
        generator.flush();
        generator.close();
    }

    protected void writeBeanChange(JsonGenerator gen, BeanChange bean, ChangeSet changeSet, int position) throws IOException {
        gen.writeStartObject();
        this.writeBeanTransactionDetails(gen, changeSet, position);
        gen.writeStringField("object", bean.getTable());
        gen.writeStringField("objectId", bean.getId().toString());
        gen.writeStringField("change", bean.getType().getCode());
        gen.writeNumberField("eventTime", bean.getEventTime());
        this.writeBeanValues(gen, bean);
        gen.writeEndObject();
    }

    protected void writeBeanTransactionDetails(JsonGenerator gen, ChangeSet changeSet, int position) throws IOException {
        Map<String, String> userContext;
        String userIpAddress;
        String userId;
        gen.writeStringField("txnId", changeSet.getTxnId());
        gen.writeStringField("txnState", changeSet.getTxnState().getCode());
        gen.writeNumberField("txnBatch", changeSet.getTxnBatch());
        gen.writeNumberField("txnPosition", position);
        String source = changeSet.getSource();
        if (source != null) {
            gen.writeStringField("source", source);
        }
        if ((userId = changeSet.getUserId()) != null) {
            gen.writeStringField("userId", userId);
        }
        if ((userIpAddress = changeSet.getUserIpAddress()) != null) {
            gen.writeStringField("userIpAddress", userIpAddress);
        }
        if ((userContext = changeSet.getUserContext()) != null && !userContext.isEmpty()) {
            gen.writeObjectFieldStart("userContext");
            for (Map.Entry<String, String> entry : userContext.entrySet()) {
                gen.writeStringField(entry.getKey(), entry.getValue());
            }
            gen.writeEndObject();
        }
    }

    protected void writeBeanValues(JsonGenerator gen, BeanChange bean) throws IOException {
        if (bean.getType() != ChangeType.DELETE) {
            gen.writeFieldName("values");
            gen.writeStartObject();
            this.writeValuePairs(bean, gen);
            gen.writeEndObject();
        }
    }

    protected void writeValuePairs(BeanChange bean, JsonGenerator gen) throws IOException {
        for (Map.Entry<String, ValuePair> entry : bean.getValues().entrySet()) {
            Object oldValue;
            gen.writeFieldName(entry.getKey());
            gen.writeStartObject();
            ValuePair value = entry.getValue();
            Object newValue = value.getNewValue();
            if (newValue != null) {
                gen.writeFieldName("new");
                this.json.writeScalar(gen, newValue);
            }
            if ((oldValue = value.getOldValue()) != null) {
                gen.writeFieldName("old");
                this.json.writeScalar(gen, oldValue);
            }
            gen.writeEndObject();
        }
    }
}

