/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cache;

import com.avaje.ebean.cache.ServerCache;
import com.avaje.ebean.cache.ServerCacheFactory;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebean.cache.ServerCacheOptions;
import com.avaje.ebean.cache.ServerCacheType;
import com.avaje.ebeaninternal.server.cache.DefaultCacheHolder;
import com.avaje.ebeaninternal.server.cache.DefaultServerCacheFactory;

public class DefaultServerCacheManager
implements ServerCacheManager {
    private final DefaultCacheHolder beanCache;
    private final DefaultCacheHolder queryCache;
    private final DefaultCacheHolder naturalKeyCache;
    private final DefaultCacheHolder collectionIdsCache;
    private final boolean localL2Caching;

    public DefaultServerCacheManager(boolean localL2Caching, ServerCacheFactory cacheFactory, ServerCacheOptions defaultBeanOptions, ServerCacheOptions defaultQueryOptions) {
        this.localL2Caching = localL2Caching;
        this.beanCache = new DefaultCacheHolder(cacheFactory, defaultBeanOptions);
        this.queryCache = new DefaultCacheHolder(cacheFactory, defaultQueryOptions);
        this.naturalKeyCache = new DefaultCacheHolder(cacheFactory, defaultBeanOptions);
        this.collectionIdsCache = new DefaultCacheHolder(cacheFactory, defaultBeanOptions);
    }

    public DefaultServerCacheManager() {
        this(true, new DefaultServerCacheFactory(), new ServerCacheOptions(), new ServerCacheOptions());
    }

    @Override
    public boolean isLocalL2Caching() {
        return this.localL2Caching;
    }

    @Override
    public void clear(Class<?> beanType) {
        String beanName = beanType.getName();
        this.beanCache.clearCache(beanName);
        this.naturalKeyCache.clearCache(beanName);
        this.collectionIdsCache.clearCache(beanName);
        this.queryCache.clearCache(beanName);
    }

    @Override
    public void clearAll() {
        this.beanCache.clearAll();
        this.queryCache.clearAll();
        this.naturalKeyCache.clearAll();
        this.collectionIdsCache.clearAll();
    }

    @Override
    public ServerCache getCollectionIdsCache(Class<?> beanType, String propertyName) {
        return this.collectionIdsCache.getCache(beanType.getName() + "." + propertyName, ServerCacheType.COLLECTION_IDS);
    }

    @Override
    public ServerCache getNaturalKeyCache(Class<?> beanType) {
        return this.naturalKeyCache.getCache(beanType.getName(), ServerCacheType.NATURAL_KEY);
    }

    @Override
    public ServerCache getQueryCache(Class<?> beanType) {
        return this.queryCache.getCache(beanType.getName(), ServerCacheType.QUERY);
    }

    @Override
    public ServerCache getBeanCache(Class<?> beanType) {
        return this.beanCache.getCache(beanType.getName(), ServerCacheType.BEAN);
    }

    @Override
    public boolean isBeanCaching(Class<?> beanType) {
        return this.beanCache.isCaching(beanType.getName());
    }
}

