/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.cache;

import com.avaje.ebeaninternal.server.cache.CacheChange;
import com.avaje.ebeaninternal.server.cache.CacheChangeBeanRemove;
import com.avaje.ebeaninternal.server.cache.CacheChangeBeanUpdate;
import com.avaje.ebeaninternal.server.cache.CacheChangeNaturalKeyPut;
import com.avaje.ebeaninternal.server.cache.CachedManyIds;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class CacheChangeSet {
    private final List<CacheChange> entries = new ArrayList<CacheChange>();
    private final Set<BeanDescriptor> queryCaches = new HashSet<BeanDescriptor>();
    private final Map<ManyKey, ManyChange> manyChangeMap = new HashMap<ManyKey, ManyChange>();
    private final Set<String> viewInvalidation = new HashSet<String>();
    private final boolean viewEntityInvalidation;

    public CacheChangeSet(boolean viewEntityInvalidation) {
        this.viewEntityInvalidation = viewEntityInvalidation;
    }

    public Set<String> apply() {
        for (BeanDescriptor beanDescriptor : this.queryCaches) {
            beanDescriptor.queryCacheClear();
        }
        for (CacheChange cacheChange : this.entries) {
            cacheChange.apply();
        }
        for (CacheChange cacheChange : this.manyChangeMap.values()) {
            cacheChange.apply();
        }
        return this.viewInvalidation;
    }

    public void addClearQuery(BeanDescriptor<?> descriptor) {
        this.queryCaches.add(descriptor);
    }

    public <T> void addManyClear(BeanDescriptor<T> desc, String manyProperty) {
        this.many(desc, manyProperty).setClear();
    }

    public <T> void addManyRemove(BeanDescriptor<T> desc, String manyProperty, Object parentId) {
        this.many(desc, manyProperty).addRemove(parentId);
    }

    public <T> void addManyPut(BeanDescriptor<T> desc, String manyProperty, Object parentId, CachedManyIds entry) {
        this.many(desc, manyProperty).addPut(parentId, entry);
    }

    public void addBeanInsert(String baseTable) {
        if (this.viewEntityInvalidation) {
            this.viewInvalidation.add(baseTable);
        }
    }

    public <T> void addBeanRemove(BeanDescriptor<T> desc, Object id) {
        this.entries.add(new CacheChangeBeanRemove(desc, id));
        if (this.viewEntityInvalidation) {
            this.viewInvalidation.add(desc.getBaseTable());
        }
    }

    public <T> void addBeanUpdate(BeanDescriptor<T> desc, Object id, Map<String, Object> changes, boolean updateNaturalKey, long version) {
        this.entries.add(new CacheChangeBeanUpdate(desc, id, changes, updateNaturalKey, version));
        if (this.viewEntityInvalidation) {
            this.viewInvalidation.add(desc.getBaseTable());
        }
    }

    public <T> void addNaturalKeyPut(BeanDescriptor<T> desc, Object id, Object val) {
        this.entries.add(new CacheChangeNaturalKeyPut(desc, id, val));
    }

    private ManyChange many(BeanDescriptor<?> desc, String manyProperty) {
        ManyKey key = new ManyKey(desc, manyProperty);
        ManyChange manyChange = this.manyChangeMap.get(key);
        if (manyChange == null) {
            manyChange = new ManyChange(key);
            this.manyChangeMap.put(key, manyChange);
        }
        return manyChange;
    }

    private static class ManyKey {
        private final BeanDescriptor<?> desc;
        private final String manyProperty;

        ManyKey(BeanDescriptor<?> desc, String manyProperty) {
            this.desc = desc;
            this.manyProperty = manyProperty;
        }

        public boolean equals(Object o) {
            if (this == o) {
                return true;
            }
            if (o == null || this.getClass() != o.getClass()) {
                return false;
            }
            ManyKey manyKey = (ManyKey)o;
            return this.desc.equals(manyKey.desc) && this.manyProperty.equals(manyKey.manyProperty);
        }

        public int hashCode() {
            return 31 * this.desc.hashCode() + this.manyProperty.hashCode();
        }

        void cacheClear() {
            this.desc.cacheManyPropClear(this.manyProperty);
        }

        void cachePut(Object parentId, CachedManyIds entry) {
            this.desc.cacheManyPropPut(this.manyProperty, parentId, entry);
        }

        void cacheRemove(Object parentId) {
            this.desc.cacheManyPropRemove(this.manyProperty, parentId);
        }
    }

    private static class ManyChange
    implements CacheChange {
        final ManyKey key;
        final List<Object> removes = new ArrayList<Object>();
        final Map<Object, CachedManyIds> puts = new LinkedHashMap<Object, CachedManyIds>();
        boolean clear;

        ManyChange(ManyKey key) {
            this.key = key;
        }

        void setClear() {
            this.clear = true;
            this.removes.clear();
        }

        void addRemove(Object parentId) {
            if (!this.clear) {
                this.removes.add(parentId);
            }
        }

        void addPut(Object parentId, CachedManyIds entry) {
            this.puts.put(parentId, entry);
        }

        @Override
        public void apply() {
            if (this.clear) {
                this.key.cacheClear();
            } else {
                for (Map.Entry<Object, CachedManyIds> entry : this.puts.entrySet()) {
                    this.key.cachePut(entry.getKey(), entry.getValue());
                }
                for (Object parentId : this.removes) {
                    this.key.cacheRemove(parentId);
                }
            }
        }
    }
}

