/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.autotune.service;

import com.avaje.ebean.bean.NodeUsageCollector;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.bean.ObjectGraphOrigin;
import com.avaje.ebean.text.PathProperties;
import com.avaje.ebeaninternal.server.autotune.AutoTuneCollection;
import com.avaje.ebeaninternal.server.autotune.service.ProfileOriginNodeUsage;
import com.avaje.ebeaninternal.server.autotune.service.ProfileOriginQuery;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryDetail;
import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicLong;

public class ProfileOrigin {
    private static final long RESET_COUNT = -1000000000L;
    private final ObjectGraphOrigin origin;
    private final boolean queryTuningAddVersion;
    private final int profilingBase;
    private final double profilingRate;
    private final Map<String, ProfileOriginQuery> queryStatsMap = new ConcurrentHashMap<String, ProfileOriginQuery>();
    private final Map<String, ProfileOriginNodeUsage> nodeUsageMap = new ConcurrentHashMap<String, ProfileOriginNodeUsage>();
    private final Object monitor = new Object();
    private final AtomicLong requestCount = new AtomicLong();
    private final AtomicLong profileCount = new AtomicLong();
    private String originalQuery;

    public ProfileOrigin(ObjectGraphOrigin origin, boolean queryTuningAddVersion, int profilingBase, double profilingRate) {
        this.origin = origin;
        this.queryTuningAddVersion = queryTuningAddVersion;
        this.profilingBase = profilingBase;
        this.profilingRate = profilingRate;
    }

    public String getOriginalQuery() {
        return this.originalQuery;
    }

    public void setOriginalQuery(String originalQuery) {
        this.originalQuery = originalQuery;
    }

    public boolean isProfile() {
        long count = this.requestCount.incrementAndGet();
        if (count < (long)this.profilingBase) {
            return true;
        }
        long hits = this.profileCount.get();
        if (this.profilingRate > (double)hits / (double)count) {
            this.profileCount.incrementAndGet();
            return true;
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void profilingCollection(BeanDescriptor<?> rootDesc, AutoTuneCollection req, boolean reset) {
        Object object = this.monitor;
        synchronized (object) {
            if (this.nodeUsageMap.isEmpty()) {
                return;
            }
            OrmQueryDetail detail = this.buildDetail(rootDesc);
            AutoTuneCollection.Entry entry = req.add(this.origin, detail, this.originalQuery);
            Collection<ProfileOriginQuery> values = this.queryStatsMap.values();
            for (ProfileOriginQuery queryEntry : values) {
                entry.addQuery(queryEntry.createEntryQuery(reset));
            }
            if (reset) {
                this.nodeUsageMap.clear();
                if (this.requestCount.get() > -1000000000L) {
                    this.requestCount.set(this.profilingBase);
                    this.profileCount.set(0L);
                }
            }
        }
    }

    private OrmQueryDetail buildDetail(BeanDescriptor<?> rootDesc) {
        PathProperties pathProps = new PathProperties();
        for (ProfileOriginNodeUsage statsNode : this.nodeUsageMap.values()) {
            statsNode.buildTunedFetch(pathProps, rootDesc, this.queryTuningAddVersion);
        }
        OrmQueryDetail detail = new OrmQueryDetail();
        Collection<PathProperties.Props> pathProperties = pathProps.getPathProps();
        for (PathProperties.Props props : pathProperties) {
            if (props.isEmpty()) continue;
            detail.fetch(props.getPath(), props.getPropertiesAsString(), null);
        }
        detail.sortFetchPaths(rootDesc);
        return detail;
    }

    public ObjectGraphOrigin getOrigin() {
        return this.origin;
    }

    public void collectQueryInfo(ObjectGraphNode node, long beansLoaded, long micros) {
        ProfileOriginQuery stats;
        String key = node.getPath();
        if (key == null) {
            key = "";
        }
        if ((stats = this.queryStatsMap.get(key)) == null) {
            stats = new ProfileOriginQuery(key);
            this.queryStatsMap.put(key, stats);
        }
        stats.add(beansLoaded, micros);
    }

    public void collectUsageInfo(NodeUsageCollector profile) {
        if (!profile.isEmpty()) {
            ProfileOriginNodeUsage nodeStats = this.getNodeStats(profile.getNode().getPath());
            nodeStats.collectUsageInfo(profile);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private ProfileOriginNodeUsage getNodeStats(String path) {
        Object object = this.monitor;
        synchronized (object) {
            path = path == null ? "" : path;
            ProfileOriginNodeUsage nodeStats = this.nodeUsageMap.get(path);
            if (nodeStats == null) {
                nodeStats = new ProfileOriginNodeUsage(path);
                this.nodeUsageMap.put(path, nodeStats);
            }
            return nodeStats;
        }
    }
}

