/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.api;

import com.avaje.ebeaninternal.api.TransactionEventBeans;
import com.avaje.ebeaninternal.api.TransactionEventTable;
import com.avaje.ebeaninternal.server.cache.CacheChangeSet;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.transaction.DeleteByIdMap;
import com.avaje.ebeanservice.docstore.api.DocStoreUpdates;
import java.io.Serializable;
import java.util.List;

public class TransactionEvent
implements Serializable {
    private static final long serialVersionUID = 7230903304106097120L;
    private final transient boolean local;
    private TransactionEventTable eventTables;
    private transient TransactionEventBeans eventBeans;
    private transient DeleteByIdMap deleteByIdMap;

    public TransactionEvent() {
        this.local = true;
    }

    public void addDeleteById(BeanDescriptor<?> desc, Object id) {
        if (this.deleteByIdMap == null) {
            this.deleteByIdMap = new DeleteByIdMap();
        }
        this.deleteByIdMap.add(desc, id);
    }

    public void addDeleteByIdList(BeanDescriptor<?> desc, List<Object> idList) {
        if (this.deleteByIdMap == null) {
            this.deleteByIdMap = new DeleteByIdMap();
        }
        this.deleteByIdMap.addList(desc, idList);
    }

    public DeleteByIdMap getDeleteByIdMap() {
        return this.deleteByIdMap;
    }

    public boolean isLocal() {
        return this.local;
    }

    public List<PersistRequestBean<?>> getPersistRequestBeans() {
        return this.eventBeans == null ? null : this.eventBeans.getRequests();
    }

    public TransactionEventTable getEventTables() {
        return this.eventTables;
    }

    public void add(String tableName, boolean inserts, boolean updates, boolean deletes) {
        if (this.eventTables == null) {
            this.eventTables = new TransactionEventTable();
        }
        this.eventTables.add(tableName, inserts, updates, deletes);
    }

    public void add(TransactionEventTable table) {
        if (this.eventTables == null) {
            this.eventTables = new TransactionEventTable();
        }
        this.eventTables.add(table);
    }

    public void add(PersistRequestBean<?> request) {
        if (request.isNotify()) {
            if (this.eventBeans == null) {
                this.eventBeans = new TransactionEventBeans();
            }
            this.eventBeans.add(request);
        }
    }

    public CacheChangeSet buildCacheChanges(boolean viewInvalidation) {
        CacheChangeSet changeSet = new CacheChangeSet(viewInvalidation);
        if (this.eventBeans != null) {
            this.eventBeans.notifyCache(changeSet);
        }
        if (this.deleteByIdMap != null) {
            this.deleteByIdMap.notifyCache(changeSet);
        }
        return changeSet;
    }

    public void addDocStoreUpdates(DocStoreUpdates docStoreUpdates) {
        List<PersistRequestBean<?>> persistRequestBeans = this.getPersistRequestBeans();
        if (persistRequestBeans != null) {
            for (int i = 0; i < persistRequestBeans.size(); ++i) {
                persistRequestBeans.get(i).addDocStoreUpdates(docStoreUpdates);
            }
        }
    }
}

