/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.api;

import com.avaje.ebeaninternal.api.PropertyJoin;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.el.ElPropertyDeploy;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.server.query.SqlJoinType;
import java.io.Serializable;
import java.util.Collection;
import java.util.TreeMap;
import java.util.TreeSet;

public class ManyWhereJoins
implements Serializable {
    private static final long serialVersionUID = -6490181101871795417L;
    private final TreeMap<String, PropertyJoin> joins = new TreeMap();
    private StringBuilder formulaProperties = new StringBuilder();
    private boolean formulaWithJoin;
    private boolean requireOuterJoins;

    public boolean isRequireOuterJoins() {
        return this.requireOuterJoins;
    }

    public void setRequireOuterJoins(boolean requireOuterJoins) {
        this.requireOuterJoins = requireOuterJoins;
    }

    public void add(ElPropertyDeploy elProp) {
        String join = elProp.getElPrefix();
        BeanProperty p = elProp.getBeanProperty();
        if (p instanceof BeanPropertyAssocMany) {
            join = this.addManyToJoin(join, p.getName());
        }
        if (join != null) {
            String secondaryTableJoinPrefix;
            this.addJoin(join);
            if (p != null && (secondaryTableJoinPrefix = p.getSecondaryTableJoinPrefix()) != null) {
                this.addJoin(join + "." + secondaryTableJoinPrefix);
            }
            this.addParentJoins(join);
        }
    }

    private String addManyToJoin(String join, String manyPropName) {
        if (join == null) {
            return manyPropName;
        }
        return join + "." + manyPropName;
    }

    private void addParentJoins(String join) {
        String[] split = SplitName.split(join);
        if (split[0] != null) {
            this.addJoin(split[0]);
            this.addParentJoins(split[0]);
        }
    }

    private void addJoin(String property) {
        SqlJoinType joinType = this.requireOuterJoins ? SqlJoinType.OUTER : SqlJoinType.INNER;
        this.joins.put(property, new PropertyJoin(property, joinType));
    }

    public boolean isEmpty() {
        return this.joins.isEmpty();
    }

    public Collection<PropertyJoin> getPropertyJoins() {
        return this.joins.values();
    }

    public TreeSet<String> getPropertyNames() {
        TreeSet<String> propertyNames = new TreeSet<String>();
        for (PropertyJoin join : this.joins.values()) {
            propertyNames.add(join.getProperty());
        }
        return propertyNames;
    }

    public void addFormulaWithJoin(String propertyName) {
        if (this.formulaWithJoin) {
            this.formulaProperties.append(",");
        } else {
            this.formulaProperties = new StringBuilder();
            this.formulaWithJoin = true;
        }
        this.formulaProperties.append(propertyName);
    }

    public boolean isFormulaWithJoin() {
        return this.formulaWithJoin;
    }

    public String getFormulaProperties() {
        return this.formulaProperties.toString();
    }
}

