/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.model.build;

import com.avaje.ebean.config.DbConstraintNaming;
import com.avaje.ebean.config.dbplatform.DbType;
import com.avaje.ebean.config.dbplatform.DbTypeMap;
import com.avaje.ebean.dbmigration.model.MColumn;
import com.avaje.ebean.dbmigration.model.MTable;
import com.avaje.ebean.dbmigration.model.ModelContainer;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.type.ScalarType;
import java.util.Collection;
import java.util.List;

public class ModelBuildContext {
    private final DbTypeMap dbTypeMap = DbTypeMap.logicalTypes();
    private final ModelContainer model;
    private final DbConstraintNaming constraintNaming;
    private final DbConstraintNaming.MaxLength maxLength;
    private final boolean platformTypes;

    public ModelBuildContext(ModelContainer model, DbConstraintNaming naming, DbConstraintNaming.MaxLength maxLength, boolean platformTypes) {
        this.model = model;
        this.constraintNaming = naming;
        this.maxLength = maxLength;
        this.platformTypes = platformTypes;
    }

    public void adjustDraftReferences() {
        this.model.adjustDraftReferences();
    }

    public String normaliseTable(String baseTable) {
        return this.constraintNaming.normaliseTable(baseTable);
    }

    public String primaryKeyName(String tableName) {
        return this.maxLength(this.constraintNaming.primaryKeyName(tableName), 0);
    }

    public String foreignKeyConstraintName(String tableName, String columnName, int foreignKeyCount) {
        return this.maxLength(this.constraintNaming.foreignKeyConstraintName(tableName, columnName), foreignKeyCount);
    }

    public String foreignKeyIndexName(String tableName, String[] columns, int indexCount) {
        return this.maxLength(this.constraintNaming.foreignKeyIndexName(tableName, columns), indexCount);
    }

    public String foreignKeyIndexName(String tableName, String column, int indexCount) {
        return this.maxLength(this.constraintNaming.foreignKeyIndexName(tableName, column), indexCount);
    }

    public String indexName(String tableName, String column, int indexCount) {
        return this.maxLength(this.constraintNaming.indexName(tableName, column), indexCount);
    }

    public String indexName(String tableName, String[] columns, int indexCount) {
        return this.maxLength(this.constraintNaming.indexName(tableName, columns), indexCount);
    }

    public String uniqueConstraintName(String tableName, String columnName, int indexCount) {
        return this.maxLength(this.constraintNaming.uniqueConstraintName(tableName, columnName), indexCount);
    }

    public String uniqueConstraintName(String tableName, String[] columnNames, int indexCount) {
        return this.maxLength(this.constraintNaming.uniqueConstraintName(tableName, columnNames), indexCount);
    }

    public String checkConstraintName(String tableName, String columnName, int checkCount) {
        return this.maxLength(this.constraintNaming.checkConstraintName(tableName, columnName), checkCount);
    }

    public MTable addTable(MTable table) {
        return this.model.addTable(table);
    }

    public void addIndex(String indexName, String tableName, String columnName) {
        this.model.addIndex(indexName, tableName, columnName);
    }

    public void addIndex(String indexName, String tableName, String[] columnNames) {
        this.model.addIndex(indexName, tableName, columnNames);
    }

    private String maxLength(String constraintName, int indexCount) {
        return this.maxLength.maxLength(constraintName, indexCount);
    }

    public DbTypeMap getDbTypeMap() {
        return this.dbTypeMap;
    }

    public String getColumnDefn(BeanProperty p, boolean strict) {
        DbType dbType = this.getDbType(p);
        if (dbType == null) {
            throw new IllegalStateException("Unknown DbType mapping for " + p.getFullBeanName());
        }
        return p.renderDbType(dbType, strict);
    }

    private DbType getDbType(BeanProperty p) {
        if (p.isDbEncrypted()) {
            return this.dbTypeMap.get(p.getDbEncryptedType());
        }
        if (p.isLocalEncrypted()) {
            ScalarType<Object> scalarType = p.getScalarType();
            int jdbcType = scalarType.getJdbcType();
            return this.dbTypeMap.get(jdbcType);
        }
        int dbType = p.getDbType(this.platformTypes);
        if (dbType == 0) {
            throw new RuntimeException("No scalarType defined for " + p.getFullBeanName());
        }
        return this.dbTypeMap.get(dbType);
    }

    public void createDraft(MTable table, boolean draftable) {
        List<MColumn> pkCols;
        MTable draftTable = table.createDraftTable();
        draftTable.setPkName(this.primaryKeyName(draftTable.getName()));
        if (draftable && (pkCols = table.primaryKeyColumns()).size() == 1) {
            MColumn pk = pkCols.get(0);
            pk.setReferences(draftTable.getName() + "." + pk.getName());
            pk.setForeignKeyName(this.foreignKeyConstraintName(table.getName(), pk.getName(), 0));
        }
        int fkCount = 0;
        int ixCount = 0;
        int uqCount = 0;
        Collection<MColumn> cols = draftTable.allColumns();
        for (MColumn col : cols) {
            if (col.getForeignKeyName() != null) {
                col.setForeignKeyName(this.foreignKeyConstraintName(draftTable.getName(), col.getName(), ++fkCount));
                String[] indexCols = new String[]{col.getName()};
                col.setForeignKeyIndex(this.foreignKeyIndexName(draftTable.getName(), indexCols, ++ixCount));
            }
            if (col.getUnique() != null) {
                col.setUnique(this.uniqueConstraintName(draftTable.getName(), col.getName(), ++uqCount));
            }
            if (col.getUniqueOneToOne() == null) continue;
            col.setUniqueOneToOne(this.uniqueConstraintName(draftTable.getName(), col.getName(), ++uqCount));
        }
        this.addTable(draftTable);
    }
}

