/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration.platform.util;

import com.avaje.ebean.config.dbplatform.DbType;
import com.avaje.ebean.config.dbplatform.DbTypeMap;

public class PlatformTypeConverter {
    protected final DbTypeMap platformTypes;

    public PlatformTypeConverter(DbTypeMap platformTypes) {
        this.platformTypes = platformTypes;
    }

    public String convert(String columnDefinition) {
        int open = columnDefinition.indexOf(40);
        if (open > -1) {
            return this.convertWithScale(columnDefinition, open);
        }
        return this.convertNoScale(columnDefinition);
    }

    protected String convertWithScale(String columnDefinition, int open) {
        int close = columnDefinition.lastIndexOf(41);
        if (close == -1) {
            return columnDefinition;
        }
        String suffix = close + 1 < columnDefinition.length() ? columnDefinition.substring(close + 1) : "";
        String type = columnDefinition.substring(0, open);
        try {
            DbType dbType = this.platformTypes.lookup(type, true);
            int comma = columnDefinition.indexOf(44, open);
            if (comma > -1) {
                int scale = Integer.parseInt(columnDefinition.substring(open + 1, comma));
                int precision = Integer.parseInt(columnDefinition.substring(comma + 1, close));
                return dbType.renderType(scale, precision) + suffix;
            }
            int scale = Integer.parseInt(columnDefinition.substring(open + 1, close));
            return dbType.renderType(scale, 0) + suffix;
        }
        catch (IllegalArgumentException e) {
            return columnDefinition;
        }
    }

    protected String convertNoScale(String columnDefinition) {
        try {
            DbType dbType = this.platformTypes.lookup(columnDefinition, false);
            return dbType.renderType(0, 0);
        }
        catch (IllegalArgumentException e) {
            return columnDefinition;
        }
    }
}

