/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration.platform;

import com.avaje.ebean.dbmigration.ddlgeneration.DdlBuffer;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlWrite;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.DbTriggerBasedHistoryDdl;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.DbTriggerUpdate;
import com.avaje.ebean.dbmigration.model.MTable;
import java.io.IOException;
import java.util.List;

public class PostgresHistoryDdl
extends DbTriggerBasedHistoryDdl {
    public PostgresHistoryDdl() {
        this.currentTimestamp = "current_timestamp";
    }

    @Override
    protected void createHistoryTable(DdlBuffer apply, MTable table) throws IOException {
        String baseTable = table.getName();
        apply.append("create table ").append(baseTable).append(this.historySuffix).append("(like ").append(baseTable).append(")").endOfStatement();
    }

    @Override
    protected void addSysPeriodColumns(DdlBuffer apply, String baseTableName, String whenCreatedColumn) throws IOException {
        apply.append("alter table ").append(baseTableName).append(" add column ").append(this.sysPeriod).append(" tstzrange not null default tstzrange(").append(this.currentTimestamp).append(", null)").endOfStatement();
        if (whenCreatedColumn != null) {
            apply.append("update ").append(baseTableName).append(" set ").append(this.sysPeriod).append(" = tstzrange(").append(whenCreatedColumn).append(", null)").endOfStatement();
        }
    }

    @Override
    protected void appendSysPeriodColumns(DdlBuffer apply, String prefix) throws IOException {
        this.appendColumnName(apply, prefix, this.sysPeriod);
    }

    @Override
    protected void dropSysPeriodColumns(DdlBuffer buffer, String baseTableName) throws IOException {
        buffer.append("alter table ").append(baseTableName).append(" drop column ").append(this.sysPeriod).endOfStatement();
    }

    @Override
    protected void createTriggers(DdlWrite writer, MTable table) throws IOException {
        String baseTableName = table.getName();
        String procedureName = this.procedureName(baseTableName);
        String triggerName = this.triggerName(baseTableName);
        DdlBuffer apply = writer.applyHistory();
        apply.append("create trigger ").append(triggerName).newLine().append("  before update or delete on ").append(baseTableName).newLine().append("  for each row execute procedure ").append(procedureName).append("();").newLine().newLine();
    }

    @Override
    protected void dropTriggers(DdlBuffer buffer, String baseTable) throws IOException {
        buffer.append("drop trigger if exists ").append(this.triggerName(baseTable)).append(" on ").append(baseTable).append(" cascade").endOfStatement();
        buffer.append("drop function if exists ").append(this.procedureName(baseTable)).append("()").endOfStatement();
        buffer.end();
    }

    protected void createOrReplaceFunction(DdlBuffer apply, String procedureName, String historyTable, List<String> includedColumns) throws IOException {
        apply.append("create or replace function ").append(procedureName).append("() returns trigger as $$").newLine().append("begin").newLine();
        apply.append("  if (TG_OP = 'UPDATE') then").newLine();
        this.appendInsertIntoHistory(apply, historyTable, includedColumns);
        apply.append("    NEW.").append(this.sysPeriod).append(" = tstzrange(").append(this.currentTimestamp).append(",null);").newLine().append("    return new;").newLine();
        apply.append("  elsif (TG_OP = 'DELETE') then").newLine();
        this.appendInsertIntoHistory(apply, historyTable, includedColumns);
        apply.append("    return old;").newLine();
        apply.append("  end if;").newLine().append("end;").newLine().append("$$ LANGUAGE plpgsql;").newLine();
        apply.end();
    }

    @Override
    protected void createStoredFunction(DdlWrite writer, MTable table) throws IOException {
        String procedureName = this.procedureName(table.getName());
        String historyTable = this.historyTableName(table.getName());
        List<String> columnNames = this.columnNamesForApply(table);
        this.createOrReplaceFunction(writer.applyHistory(), procedureName, historyTable, columnNames);
    }

    @Override
    protected void updateHistoryTriggers(DbTriggerUpdate update) throws IOException {
        String procedureName = this.procedureName(update.getBaseTable());
        this.recreateHistoryView(update);
        this.createOrReplaceFunction(update.historyBuffer(), procedureName, update.getHistoryTable(), update.getColumns());
    }

    private void recreateHistoryView(DbTriggerUpdate update) throws IOException {
        DdlBuffer buffer = update.dropDependencyBuffer();
        buffer.append("drop view if exists ").append(update.getBaseTable()).append(this.viewSuffix).endOfStatement();
        this.createWithHistoryView(update);
    }

    @Override
    protected void appendInsertIntoHistory(DdlBuffer buffer, String historyTable, List<String> columns) throws IOException {
        buffer.append("    insert into ").append(historyTable).append(" (").append(this.sysPeriod).append(",");
        this.appendColumnNames(buffer, columns, "");
        buffer.append(") values (tstzrange(lower(OLD.").append(this.sysPeriod).append("), ").append(this.currentTimestamp).append("), ");
        this.appendColumnNames(buffer, columns, "OLD.");
        buffer.append(");").newLine();
    }
}

