/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration.ddlgeneration;

import com.avaje.ebean.dbmigration.ddlgeneration.DdlBuffer;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.BaseDdlBuffer;
import com.avaje.ebean.dbmigration.model.MConfiguration;
import com.avaje.ebean.dbmigration.model.MTable;
import com.avaje.ebean.dbmigration.model.ModelContainer;

public class DdlWrite {
    private final ModelContainer currentModel;
    private final DdlBuffer applyDropDependencies;
    private final DdlBuffer apply;
    private final DdlBuffer applyForeignKeys;
    private final DdlBuffer applyHistory;
    private final DdlBuffer dropAllForeignKeys;
    private final DdlBuffer dropAll;

    public DdlWrite() {
        this(new MConfiguration(), new ModelContainer());
    }

    public DdlWrite(MConfiguration configuration, ModelContainer currentModel) {
        this.currentModel = currentModel;
        this.applyDropDependencies = new BaseDdlBuffer(configuration);
        this.apply = new BaseDdlBuffer(configuration);
        this.applyForeignKeys = new BaseDdlBuffer(configuration);
        this.applyHistory = new BaseDdlBuffer(configuration);
        this.dropAllForeignKeys = new BaseDdlBuffer(configuration);
        this.dropAll = new BaseDdlBuffer(configuration);
    }

    public MTable getTable(String tableName) {
        return this.currentModel.getTable(tableName);
    }

    public boolean isApplyEmpty() {
        return this.apply.getBuffer().isEmpty() && this.applyForeignKeys.getBuffer().isEmpty() && this.applyHistory.getBuffer().isEmpty() && this.applyDropDependencies.getBuffer().isEmpty();
    }

    public DdlBuffer apply() {
        return this.apply;
    }

    public DdlBuffer applyDropDependencies() {
        return this.applyDropDependencies;
    }

    public DdlBuffer applyForeignKeys() {
        return this.applyForeignKeys;
    }

    public DdlBuffer applyHistory() {
        return this.applyHistory;
    }

    public DdlBuffer dropAllForeignKeys() {
        return this.dropAllForeignKeys;
    }

    public DdlBuffer dropAll() {
        return this.dropAll;
    }
}

