/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.dbmigration;

import com.avaje.ebean.Transaction;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.dbmigration.model.CurrentModel;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.extraddl.model.ExtraDdlXmlReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.LineNumberReader;
import java.io.Reader;
import java.sql.Connection;
import java.sql.SQLException;
import javax.persistence.PersistenceException;
import org.avaje.dbmigration.ddl.DdlRunner;

public class DdlGenerator {
    private final SpiEbeanServer server;
    private final boolean generateDdl;
    private final boolean runDdl;
    private final boolean createOnly;
    private CurrentModel currentModel;
    private String dropAllContent;
    private String createAllContent;

    public DdlGenerator(SpiEbeanServer server, ServerConfig serverConfig) {
        this.server = server;
        this.generateDdl = serverConfig.isDdlGenerate();
        this.runDdl = serverConfig.isDdlRun();
        this.createOnly = serverConfig.isDdlCreateOnly();
    }

    public void execute(boolean online) {
        this.generateDdl();
        if (online) {
            this.runDdl();
        }
    }

    protected void generateDdl() {
        if (this.generateDdl) {
            if (!this.createOnly) {
                this.writeDrop(this.getDropFileName());
            }
            this.writeCreate(this.getCreateFileName());
        }
    }

    protected void runDdl() {
        if (this.runDdl) {
            try {
                this.runInitSql();
                this.runDropSql();
                this.runCreateSql();
                this.runSeedSql();
            }
            catch (IOException e) {
                String msg = "Error reading drop/create script from file system";
                throw new RuntimeException(msg, e);
            }
        }
    }

    public int runScript(boolean expectErrors, String content, String scriptName) {
        DdlRunner runner = new DdlRunner(expectErrors, scriptName);
        Transaction transaction = this.server.createTransaction();
        Connection connection = transaction.getConnection();
        try {
            if (expectErrors) {
                connection.setAutoCommit(true);
            }
            int count = runner.runAll(content, connection);
            if (expectErrors) {
                connection.setAutoCommit(false);
            }
            transaction.commit();
            int n = count;
            return n;
        }
        catch (SQLException e) {
            throw new PersistenceException("Failed to run script", (Throwable)e);
        }
        finally {
            transaction.end();
        }
    }

    protected void runDropSql() throws IOException {
        if (!this.createOnly) {
            if (this.dropAllContent == null) {
                this.dropAllContent = this.readFile(this.getDropFileName());
            }
            this.runScript(true, this.dropAllContent, this.getDropFileName());
        }
    }

    protected void runCreateSql() throws IOException {
        String extraApply;
        if (this.createAllContent == null) {
            this.createAllContent = this.readFile(this.getCreateFileName());
        }
        this.runScript(false, this.createAllContent, this.getCreateFileName());
        String ignoreExtraDdl = System.getProperty("ebean.ignoreExtraDdl");
        if (!"true".equalsIgnoreCase(ignoreExtraDdl) && (extraApply = ExtraDdlXmlReader.buildExtra(this.server.getDatabasePlatform().getName())) != null) {
            this.runScript(false, extraApply, "extra-dll");
        }
    }

    protected void runInitSql() throws IOException {
        this.runResourceScript(this.server.getServerConfig().getDdlInitSql());
    }

    protected void runSeedSql() throws IOException {
        this.runResourceScript(this.server.getServerConfig().getDdlSeedSql());
    }

    protected void runResourceScript(String sqlScript) throws IOException {
        InputStream is;
        if (sqlScript != null && (is = this.getClassLoader().getResourceAsStream(sqlScript)) != null) {
            String content = this.readContent(new InputStreamReader(is));
            this.runScript(false, content, sqlScript);
        }
    }

    protected ClassLoader getClassLoader() {
        ClassLoader cl = Thread.currentThread().getContextClassLoader();
        if (cl == null) {
            cl = this.getClassLoader();
        }
        return cl;
    }

    protected void writeDrop(String dropFile) {
        try {
            this.writeFile(dropFile, this.generateDropAllDdl());
        }
        catch (IOException e) {
            throw new PersistenceException("Error generating Drop DDL", (Throwable)e);
        }
    }

    protected void writeCreate(String createFile) {
        try {
            this.writeFile(createFile, this.generateCreateAllDdl());
        }
        catch (IOException e) {
            throw new PersistenceException("Error generating Create DDL", (Throwable)e);
        }
    }

    protected String generateDropAllDdl() {
        try {
            this.dropAllContent = this.currentModel().getDropAllDdl();
            return this.dropAllContent;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String generateCreateAllDdl() {
        try {
            this.createAllContent = this.currentModel().getCreateDdl();
            return this.createAllContent;
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    protected String getDropFileName() {
        return this.server.getName() + "-drop-all.sql";
    }

    protected String getCreateFileName() {
        return this.server.getName() + "-create-all.sql";
    }

    protected CurrentModel currentModel() {
        if (this.currentModel == null) {
            this.currentModel = new CurrentModel(this.server);
        }
        return this.currentModel;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void writeFile(String fileName, String fileContent) throws IOException {
        File f = new File(fileName);
        FileWriter fw = new FileWriter(f);
        try {
            fw.write(fileContent);
            fw.flush();
        }
        finally {
            fw.close();
        }
    }

    protected String readFile(String fileName) throws IOException {
        File f = new File(fileName);
        if (!f.exists()) {
            return null;
        }
        return this.readContent(new FileReader(f));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected String readContent(Reader reader) throws IOException {
        StringBuilder buf = new StringBuilder();
        LineNumberReader lineReader = new LineNumberReader(reader);
        try {
            String s;
            while ((s = lineReader.readLine()) != null) {
                buf.append(s).append("\n");
            }
            String string = buf.toString();
            return string;
        }
        finally {
            lineReader.close();
        }
    }
}

