/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

import com.avaje.ebean.config.dbplatform.SqlLimitRequest;
import com.avaje.ebean.config.dbplatform.SqlLimitResponse;
import com.avaje.ebean.config.dbplatform.SqlLimiter;

public class RownumSqlLimiter
implements SqlLimiter {
    private final String rnum;
    private final boolean useFirstRowsHint;

    public RownumSqlLimiter() {
        this("rn_", true);
    }

    public RownumSqlLimiter(String rnum, boolean useFirstRowsHint) {
        this.rnum = rnum;
        this.useFirstRowsHint = useFirstRowsHint;
    }

    @Override
    public SqlLimitResponse limit(SqlLimitRequest request) {
        String dbSql = request.getDbSql();
        StringBuilder sb = new StringBuilder(60 + dbSql.length());
        int firstRow = request.getFirstRow();
        int lastRow = request.getMaxRows();
        if (lastRow > 0) {
            lastRow += firstRow;
        }
        sb.append("select * from ( ");
        sb.append("select ");
        if (this.useFirstRowsHint && request.getMaxRows() > 0) {
            sb.append("/*+ FIRST_ROWS(").append(request.getMaxRows()).append(") */ ");
        }
        sb.append("rownum ").append(this.rnum).append(", a.* ");
        sb.append(" from (");
        sb.append(" select ");
        if (request.isDistinct()) {
            sb.append("distinct ");
        }
        sb.append(dbSql);
        sb.append('\n').append("  ) a ");
        if (lastRow > 0) {
            sb.append(" where rownum <= ").append(lastRow);
        }
        sb.append(" ) ");
        if (firstRow > 0) {
            sb.append(" where ");
            sb.append(this.rnum).append(" > ").append(firstRow);
        }
        String sql = request.getDbPlatform().completeSql(sb.toString(), request.getOrmQuery());
        return new SqlLimitResponse(sql, true);
    }
}

