/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config.dbplatform;

import com.avaje.ebean.BackgroundExecutor;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.config.dbplatform.DbType;
import com.avaje.ebean.config.dbplatform.IdType;
import com.avaje.ebean.config.dbplatform.PlatformIdGenerator;
import com.avaje.ebean.config.dbplatform.PostgresDbEncrypt;
import com.avaje.ebean.config.dbplatform.PostgresHistorySupport;
import com.avaje.ebean.config.dbplatform.PostgresSequenceIdGenerator;
import com.avaje.ebean.dbmigration.ddlgeneration.DdlHandler;
import com.avaje.ebean.dbmigration.ddlgeneration.platform.PostgresDdl;
import java.util.Properties;
import javax.sql.DataSource;

public class PostgresPlatform
extends DatabasePlatform {
    public PostgresPlatform() {
        this.name = "postgres";
        this.supportsNativeIlike = true;
        this.likeClause = "like ? escape''";
        this.selectCountWithAlias = true;
        this.blobDbType = -4;
        this.clobDbType = 12;
        this.nativeUuidType = true;
        this.dbEncrypt = new PostgresDbEncrypt();
        this.historySupport = new PostgresHistorySupport();
        this.platformDdl = new PostgresDdl(this);
        this.dbIdentity.setIdType(IdType.IDENTITY);
        this.dbIdentity.setSupportsGetGeneratedKeys(true);
        this.dbIdentity.setSupportsSequence(true);
        this.openQuote = "\"";
        this.closeQuote = "\"";
        DbType dbTypeText = new DbType("text");
        DbType dbBytea = new DbType("bytea", false);
        this.dbTypeMap.put(5000, new DbType("hstore", false));
        this.dbTypeMap.put(5001, new DbType("json", false));
        this.dbTypeMap.put(5002, new DbType("jsonb", false));
        this.dbTypeMap.put(4, new DbType("integer", false));
        this.dbTypeMap.put(8, new DbType("float"));
        this.dbTypeMap.put(-6, new DbType("smallint"));
        this.dbTypeMap.put(3, new DbType("decimal", 38));
        this.dbTypeMap.put(93, new DbType("timestamptz"));
        this.dbTypeMap.put(-2, dbBytea);
        this.dbTypeMap.put(-3, dbBytea);
        this.dbTypeMap.put(2004, dbBytea);
        this.dbTypeMap.put(2005, dbTypeText);
        this.dbTypeMap.put(-4, dbBytea);
        this.dbTypeMap.put(-1, dbTypeText);
    }

    @Override
    public void configure(ServerConfig serverConfig) {
        String tsType;
        super.configure(serverConfig);
        Properties properties = serverConfig.getProperties();
        if (properties != null && (tsType = properties.getProperty("ebean.postgres.timestamp")) != null) {
            this.dbTypeMap.put(93, new DbType(tsType));
        }
    }

    @Override
    public DdlHandler createDdlHandler(ServerConfig serverConfig) {
        return this.platformDdl.createDdlHandler(serverConfig);
    }

    @Override
    public PlatformIdGenerator createSequenceIdGenerator(BackgroundExecutor be, DataSource ds, String seqName, int batchSize) {
        return new PostgresSequenceIdGenerator(be, ds, seqName, batchSize);
    }

    @Override
    protected String withForUpdate(String sql) {
        return sql + " for update";
    }
}

