/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import com.avaje.ebean.annotation.DocStoreMode;
import com.avaje.ebean.config.PropertiesWrapper;

public class DocStoreConfig {
    protected boolean active;
    protected boolean generateMapping;
    protected boolean dropCreate;
    protected boolean create;
    protected String url;
    protected DocStoreMode persist = DocStoreMode.UPDATE;
    protected int bulkBatchSize = 1000;
    protected String mappingPath;
    protected String mappingSuffix;
    protected String pathToResources = "src/main/resources";

    public boolean isActive() {
        String systemValue = System.getProperty("ebean.docstore.active");
        if (systemValue != null) {
            return Boolean.parseBoolean(systemValue);
        }
        return this.active;
    }

    public void setActive(boolean active) {
        this.active = active;
    }

    public String getUrl() {
        String systemValue = System.getProperty("ebean.docstore.url");
        if (systemValue != null) {
            return systemValue;
        }
        return this.url;
    }

    public void setUrl(String url) {
        this.url = url;
    }

    public boolean isGenerateMapping() {
        String systemValue = System.getProperty("ebean.docstore.generateMapping");
        if (systemValue != null) {
            return Boolean.parseBoolean(systemValue);
        }
        return this.generateMapping;
    }

    public void setGenerateMapping(boolean generateMapping) {
        this.generateMapping = generateMapping;
    }

    public boolean isDropCreate() {
        String systemValue = System.getProperty("ebean.docstore.dropCreate");
        if (systemValue != null) {
            return Boolean.parseBoolean(systemValue);
        }
        return this.dropCreate;
    }

    public void setDropCreate(boolean dropCreate) {
        this.dropCreate = dropCreate;
    }

    public boolean isCreate() {
        String systemValue = System.getProperty("ebean.docstore.create");
        if (systemValue != null) {
            return Boolean.parseBoolean(systemValue);
        }
        return this.create;
    }

    public void setCreate(boolean create) {
        this.create = create;
    }

    public int getBulkBatchSize() {
        return this.bulkBatchSize;
    }

    public void setBulkBatchSize(int bulkBatchSize) {
        this.bulkBatchSize = bulkBatchSize;
    }

    public String getMappingPath() {
        return this.mappingPath;
    }

    public void setMappingPath(String mappingPath) {
        this.mappingPath = mappingPath;
    }

    public String getMappingSuffix() {
        return this.mappingSuffix;
    }

    public void setMappingSuffix(String mappingSuffix) {
        this.mappingSuffix = mappingSuffix;
    }

    public String getPathToResources() {
        return this.pathToResources;
    }

    public void setPathToResources(String pathToResources) {
        this.pathToResources = pathToResources;
    }

    public DocStoreMode getPersist() {
        return this.persist;
    }

    public void setPersist(DocStoreMode persist) {
        this.persist = persist;
    }

    public void loadSettings(PropertiesWrapper properties) {
        this.active = properties.getBoolean("docstore.active", this.active);
        this.url = properties.get("docstore.url", this.url);
        this.persist = properties.getEnum(DocStoreMode.class, "docstore.persist", this.persist);
        this.bulkBatchSize = properties.getInt("docstore.bulkBatchSize", this.bulkBatchSize);
        this.generateMapping = properties.getBoolean("docstore.generateMapping", this.generateMapping);
        this.dropCreate = properties.getBoolean("docstore.dropCreate", this.dropCreate);
        this.create = properties.getBoolean("docstore.create", this.create);
        this.mappingPath = properties.get("docstore.mappingPath", this.mappingPath);
        this.mappingSuffix = properties.get("docstore.mappingSuffix", this.mappingSuffix);
        this.pathToResources = properties.get("docstore.pathToResources", this.pathToResources);
    }
}

