/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebean.config;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.config.PropertiesWrapper;
import com.avaje.ebean.config.dbplatform.DbPlatformName;
import com.avaje.ebean.dbmigration.DbMigration;
import java.util.Map;
import org.avaje.dbmigration.MigrationConfig;
import org.avaje.dbmigration.MigrationRunner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DbMigrationConfig {
    protected static final Logger logger = LoggerFactory.getLogger(DbMigrationConfig.class);
    protected DbPlatformName platform;
    protected boolean generate;
    protected String version;
    protected String name;
    protected String migrationPath = "dbmigration";
    protected String modelPath = "model";
    protected String applySuffix = ".sql";
    protected String applyPrefix = "";
    protected String modelSuffix = ".model.xml";
    protected boolean includeGeneratedFileComment;
    protected String generatePendingDrop;
    protected String metaTable = "db_migration";
    protected boolean runMigration;
    protected String runPlaceholders;
    protected Map<String, String> runPlaceholderMap;
    protected String dbUsername;
    protected String dbPassword;

    public DbPlatformName getPlatform() {
        return this.platform;
    }

    public void setPlatform(DbPlatformName platform) {
        this.platform = platform;
    }

    public String getMigrationPath() {
        return this.migrationPath;
    }

    public void setMigrationPath(String migrationPath) {
        this.migrationPath = migrationPath;
    }

    public String getModelPath() {
        return this.modelPath;
    }

    public void setModelPath(String modelPath) {
        this.modelPath = modelPath;
    }

    public String getModelSuffix() {
        return this.modelSuffix;
    }

    public void setModelSuffix(String modelSuffix) {
        this.modelSuffix = modelSuffix;
    }

    public String getApplySuffix() {
        return this.applySuffix;
    }

    public void setApplySuffix(String applySuffix) {
        this.applySuffix = applySuffix;
    }

    public String getApplyPrefix() {
        return this.applyPrefix;
    }

    public void setApplyPrefix(String applyPrefix) {
        this.applyPrefix = applyPrefix;
    }

    public boolean isIncludeGeneratedFileComment() {
        return this.includeGeneratedFileComment;
    }

    public void setIncludeGeneratedFileComment(boolean includeGeneratedFileComment) {
        this.includeGeneratedFileComment = includeGeneratedFileComment;
    }

    public String getGeneratePendingDrop() {
        return this.generatePendingDrop;
    }

    public void setGeneratePendingDrop(String generatePendingDrop) {
        this.generatePendingDrop = generatePendingDrop;
    }

    public void setVersion(String version) {
        this.version = version;
    }

    public void setName(String name) {
        this.name = name;
    }

    public String getMetaTable() {
        return this.metaTable;
    }

    public void setMetaTable(String metaTable) {
        this.metaTable = metaTable;
    }

    public String getRunPlaceholders() {
        String placeholders = this.readEnvironment("ddl.migration.placeholders");
        if (placeholders != null) {
            return placeholders;
        }
        return this.runPlaceholders;
    }

    public void setRunPlaceholders(String runPlaceholders) {
        this.runPlaceholders = runPlaceholders;
    }

    public Map<String, String> getRunPlaceholderMap() {
        return this.runPlaceholderMap;
    }

    public void setRunPlaceholderMap(Map<String, String> runPlaceholderMap) {
        this.runPlaceholderMap = runPlaceholderMap;
    }

    public boolean isRunMigration() {
        String run = this.readEnvironment("ddl.migration.run");
        if (run != null) {
            return "true".equalsIgnoreCase(run.trim());
        }
        return this.runMigration;
    }

    public void setRunMigration(boolean runMigration) {
        this.runMigration = runMigration;
    }

    public String getDbUsername() {
        String user = this.readEnvironment("ddl.migration.user");
        if (user != null) {
            return user;
        }
        return this.dbUsername;
    }

    public void setDbUsername(String dbUsername) {
        this.dbUsername = dbUsername;
    }

    public String getDbPassword() {
        String user = this.readEnvironment("ddl.migration.password");
        if (user != null) {
            return user;
        }
        return this.dbPassword;
    }

    public void setDbPassword(String dbPassword) {
        this.dbPassword = dbPassword;
    }

    public void loadSettings(PropertiesWrapper properties, String serverName) {
        this.migrationPath = properties.get("migration.migrationPath", this.migrationPath);
        this.modelPath = properties.get("migration.modelPath", this.modelPath);
        this.applyPrefix = properties.get("migration.applyPrefix", this.applyPrefix);
        this.applySuffix = properties.get("migration.applySuffix", this.applySuffix);
        this.modelSuffix = properties.get("migration.modelSuffix", this.modelSuffix);
        this.includeGeneratedFileComment = properties.getBoolean("migration.includeGeneratedFileComment", this.includeGeneratedFileComment);
        this.generatePendingDrop = properties.get("migration.generatePendingDrop", this.generatePendingDrop);
        this.platform = properties.getEnum(DbPlatformName.class, "migration.platform", this.platform);
        this.generate = properties.getBoolean("migration.generate", this.generate);
        this.version = properties.get("migration.version", this.version);
        this.name = properties.get("migration.name", this.name);
        this.runMigration = properties.getBoolean("migration.run", this.runMigration);
        this.metaTable = properties.get("migration.metaTable", this.metaTable);
        this.runPlaceholders = properties.get("migration.placeholders", this.runPlaceholders);
        String adminUser = properties.get("datasource." + serverName + ".username", this.dbUsername);
        adminUser = properties.get("datasource." + serverName + ".adminusername", adminUser);
        this.dbUsername = properties.get("migration.dbusername", adminUser);
        String adminPwd = properties.get("datasource." + serverName + ".password", this.dbPassword);
        adminPwd = properties.get("datasource." + serverName + ".adminpassword", adminPwd);
        this.dbPassword = properties.get("migration.dbpassword", adminPwd);
    }

    public boolean isGenerateOnStart() {
        String envGenerate = this.readEnvironment("ddl.migration.generate");
        if (envGenerate != null) {
            return "true".equalsIgnoreCase(envGenerate.trim());
        }
        return this.generate;
    }

    public void generateOnStart(EbeanServer server) {
        if (this.isGenerateOnStart()) {
            if (this.platform == null) {
                logger.warn("No platform set for migration DDL generation");
            } else {
                DbMigration migration = new DbMigration(server);
                migration.setPlatform(this.platform);
                try {
                    migration.generateMigration();
                }
                catch (Exception e) {
                    throw new RuntimeException("Error generating DB migration", e);
                }
            }
        }
    }

    public String getVersion() {
        String envVersion = this.readEnvironment("ddl.migration.version");
        if (!this.isEmpty(envVersion)) {
            return envVersion.trim();
        }
        return this.version;
    }

    public String getName() {
        String envName = this.readEnvironment("ddl.migration.name");
        if (!this.isEmpty(envName)) {
            return envName.trim();
        }
        return this.name;
    }

    protected String readEnvironment(String key) {
        String val = System.getProperty(key);
        if (val == null) {
            val = System.getenv(key);
        }
        return val;
    }

    protected boolean isEmpty(String val) {
        return val == null || val.trim().isEmpty();
    }

    public MigrationRunner createRunner(ClassLoader classLoader) {
        MigrationConfig runnerConfig = new MigrationConfig();
        runnerConfig.setMetaTable(this.metaTable);
        runnerConfig.setApplySuffix(this.applySuffix);
        runnerConfig.setMigrationPath(this.migrationPath);
        runnerConfig.setRunPlaceholderMap(this.runPlaceholderMap);
        runnerConfig.setRunPlaceholders(this.runPlaceholders);
        runnerConfig.setDbUsername(this.getDbUsername());
        runnerConfig.setDbPassword(this.getDbPassword());
        runnerConfig.setClassLoader(classLoader);
        return new MigrationRunner(runnerConfig);
    }
}

