/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.ScalarTypeJsonMap;
import java.sql.SQLException;
import java.util.Map;
import org.postgresql.util.PGobject;

public abstract class ScalarTypeJsonMapPostgres
extends ScalarTypeJsonMap {
    private static final String POSTGRES_TYPE_JSON = "json";
    private static final String POSTGRES_TYPE_JSONB = "jsonb";
    final String postgresType;

    ScalarTypeJsonMapPostgres(int jdbcType, String postgresType) {
        super(jdbcType);
        this.postgresType = postgresType;
    }

    @Override
    public void bind(DataBind b, Map value) throws SQLException {
        String rawJson = value == null ? null : this.formatValue(value);
        PGobject pgo = new PGobject();
        pgo.setType(this.postgresType);
        pgo.setValue(rawJson);
        b.setObject(pgo);
    }

    public static class JSONB
    extends ScalarTypeJsonMapPostgres {
        public JSONB() {
            super(5002, ScalarTypeJsonMapPostgres.POSTGRES_TYPE_JSONB);
        }
    }

    public static class JSON
    extends ScalarTypeJsonMapPostgres {
        public JSON() {
            super(5001, ScalarTypeJsonMapPostgres.POSTGRES_TYPE_JSON);
        }
    }
}

