/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.type;

import com.avaje.ebean.text.TextException;
import com.avaje.ebeaninternal.server.type.ConvertInetAddresses;
import com.avaje.ebeaninternal.server.type.ScalarTypeBaseVarchar;
import java.net.InetAddress;

public class ScalarTypeInetAddress
extends ScalarTypeBaseVarchar<InetAddress> {
    public ScalarTypeInetAddress() {
        super(InetAddress.class);
    }

    @Override
    public int getLength() {
        return 50;
    }

    @Override
    public InetAddress convertFromDbString(String dbValue) {
        try {
            return this.parse(dbValue);
        }
        catch (IllegalArgumentException e) {
            throw new RuntimeException("Error with InetAddresses [" + dbValue + "] " + e);
        }
    }

    @Override
    public String convertToDbString(InetAddress beanValue) {
        return ConvertInetAddresses.toUriString(beanValue);
    }

    @Override
    public String formatValue(InetAddress v) {
        return ConvertInetAddresses.toUriString(v);
    }

    @Override
    public InetAddress parse(String value) {
        try {
            return ConvertInetAddresses.forUriString(value);
        }
        catch (IllegalArgumentException e) {
            throw new TextException("Error with InetAddresses [" + value + "] ", e);
        }
    }
}

