/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebeaninternal.server.transaction.JdbcTransaction;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;

public class ExplicitJdbcTransaction
extends JdbcTransaction {
    public ExplicitJdbcTransaction(String id, boolean explicit, Connection connection, TransactionManager manager) {
        super(id, explicit, connection, manager);
    }

    @Override
    protected void checkAutoCommit(Connection connection) throws SQLException {
        this.executeStatement("begin");
    }

    @Override
    protected void performRollback() throws SQLException {
        this.executeStatement("rollback");
    }

    @Override
    protected void performCommit() throws SQLException {
        this.executeStatement("commit");
    }

    private void executeStatement(String statement) throws SQLException {
        PreparedStatement stmt = this.connection.prepareStatement(statement);
        try {
            stmt.execute();
        }
        finally {
            stmt.close();
        }
    }
}

