/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.transaction;

import com.avaje.ebean.annotation.DocStoreMode;
import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.transaction.BeanPersistIds;
import com.avaje.ebeanservice.docstore.api.DocStoreUpdates;
import com.avaje.ebeanservice.docstore.api.support.DocStoreDeleteEvent;
import java.io.Serializable;
import java.util.Collection;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public final class DeleteByIdMap {
    private final Map<String, BeanPersistIds> beanMap = new LinkedHashMap<String, BeanPersistIds>();

    public String toString() {
        return this.beanMap.toString();
    }

    public void notifyCache() {
        for (BeanPersistIds deleteIds : this.beanMap.values()) {
            BeanDescriptor<?> d = deleteIds.getBeanDescriptor();
            List<Object> idValues = deleteIds.getDeleteIds();
            if (idValues == null) continue;
            d.queryCacheClear();
            for (int i = 0; i < idValues.size(); ++i) {
                d.cacheBeanRemove(idValues.get(i));
            }
        }
    }

    public boolean isEmpty() {
        return this.beanMap.isEmpty();
    }

    public Collection<BeanPersistIds> values() {
        return this.beanMap.values();
    }

    public void add(BeanDescriptor<?> desc, Object id) {
        BeanPersistIds r = this.getPersistIds(desc);
        r.addId(PersistRequest.Type.DELETE, (Serializable)id);
    }

    public void addList(BeanDescriptor<?> desc, List<Object> idList) {
        BeanPersistIds r = this.getPersistIds(desc);
        for (int i = 0; i < idList.size(); ++i) {
            r.addId(PersistRequest.Type.DELETE, (Serializable)idList.get(i));
        }
    }

    private BeanPersistIds getPersistIds(BeanDescriptor<?> desc) {
        String beanType = desc.getFullName();
        BeanPersistIds r = this.beanMap.get(beanType);
        if (r == null) {
            r = new BeanPersistIds(desc);
            this.beanMap.put(beanType, r);
        }
        return r;
    }

    void addDocStoreUpdates(DocStoreUpdates docStoreUpdates, DocStoreMode txnIndexMode) {
        for (BeanPersistIds deleteIds : this.beanMap.values()) {
            BeanDescriptor<?> desc = deleteIds.getBeanDescriptor();
            DocStoreMode mode = desc.getDocStoreMode(PersistRequest.Type.DELETE, txnIndexMode);
            if (DocStoreMode.IGNORE == mode) continue;
            boolean queue = DocStoreMode.QUEUE == mode;
            String queueId = desc.getDocStoreQueueId();
            List<Object> idValues = deleteIds.getDeleteIds();
            if (idValues == null) continue;
            for (int i = 0; i < idValues.size(); ++i) {
                if (queue) {
                    docStoreUpdates.queueDelete(queueId, idValues.get(i));
                    continue;
                }
                docStoreUpdates.addDelete(new DocStoreDeleteEvent(desc, idValues.get(i)));
            }
        }
    }
}

