/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.text.json;

import com.avaje.ebean.FetchPath;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.config.JsonConfig;
import com.avaje.ebean.text.json.JsonIOException;
import com.avaje.ebean.text.json.JsonWriteBeanVisitor;
import com.avaje.ebean.text.json.JsonWriter;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.text.json.PathStack;
import com.avaje.ebeaninternal.server.util.ArrayStack;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.io.InputStream;
import java.math.BigDecimal;
import java.util.Collection;
import java.util.Map;
import java.util.Set;

public class WriteJson
implements JsonWriter {
    private final SpiEbeanServer server;
    private final JsonGenerator generator;
    private final FetchPath fetchPath;
    private final Map<String, JsonWriteBeanVisitor<?>> visitors;
    private final PathStack pathStack;
    private final ArrayStack<Object> parentBeans;
    private final Object objectMapper;
    private final JsonConfig.Include include;

    public WriteJson(SpiEbeanServer server, JsonGenerator generator, FetchPath fetchPath, Map<String, JsonWriteBeanVisitor<?>> visitors, Object objectMapper, JsonConfig.Include include) {
        this.server = server;
        this.generator = generator;
        this.fetchPath = fetchPath;
        this.visitors = visitors;
        this.objectMapper = objectMapper;
        this.include = include;
        this.parentBeans = new ArrayStack();
        this.pathStack = new PathStack();
    }

    public WriteJson(JsonGenerator generator, JsonConfig.Include include) {
        this.generator = generator;
        this.include = include;
        this.visitors = null;
        this.server = null;
        this.fetchPath = null;
        this.objectMapper = null;
        this.parentBeans = null;
        this.pathStack = null;
    }

    @Override
    public boolean isIncludeNull() {
        return this.include == JsonConfig.Include.ALL;
    }

    @Override
    public boolean isIncludeEmpty() {
        return this.include != JsonConfig.Include.NON_EMPTY;
    }

    @Override
    public JsonGenerator gen() {
        return this.generator;
    }

    @Override
    public void writeStartObject(String key) {
        try {
            if (key != null) {
                this.generator.writeFieldName(key);
            }
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeStartObject() {
        try {
            this.generator.writeStartObject();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeEndObject() {
        try {
            this.generator.writeEndObject();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeStartArray(String key) {
        try {
            if (key != null) {
                this.generator.writeFieldName(key);
            }
            this.generator.writeStartArray();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeStartArray() {
        try {
            this.generator.writeStartArray();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeEndArray() {
        try {
            this.generator.writeEndArray();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeRaw(String text) {
        try {
            this.generator.writeRaw(text);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeRawValue(String text) {
        try {
            this.generator.writeRawValue(text);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeFieldName(String name) {
        try {
            this.generator.writeFieldName(name);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeNullField(String name) {
        if (this.isIncludeNull()) {
            try {
                this.generator.writeNullField(name);
            }
            catch (IOException e) {
                throw new JsonIOException(e);
            }
        }
    }

    @Override
    public void writeNumberField(String name, long value) {
        try {
            this.generator.writeNumberField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeNumberField(String name, double value) {
        try {
            this.generator.writeNumberField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeNumberField(String name, int value) {
        try {
            this.generator.writeNumberField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeNumberField(String name, short value) {
        try {
            this.generator.writeNumberField(name, (int)value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeNumberField(String name, float value) {
        try {
            this.generator.writeNumberField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeNumberField(String name, BigDecimal value) {
        try {
            this.generator.writeNumberField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeStringField(String name, String value) {
        try {
            this.generator.writeStringField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeBinary(InputStream is, int length) {
        try {
            this.generator.writeBinary(is, length);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeBinaryField(String name, byte[] value) {
        try {
            this.generator.writeBinaryField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeBooleanField(String name, boolean value) {
        try {
            this.generator.writeBooleanField(name, value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeBoolean(boolean value) {
        try {
            this.generator.writeBoolean(value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeString(String value) {
        try {
            this.generator.writeString(value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeNumber(int value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeNumber(long value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeNumber(double value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeNumber(BigDecimal value) {
        try {
            this.generator.writeNumber(value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    @Override
    public void writeNull() {
        try {
            this.generator.writeNull();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public boolean isParentBean(Object bean) {
        return !this.parentBeans.isEmpty() && this.parentBeans.contains(bean);
    }

    public void pushParentBeanMany(Object parentBean) {
        this.parentBeans.push(parentBean);
    }

    public void popParentBeanMany() {
        this.parentBeans.pop();
    }

    public void beginAssocOne(String key, Object bean) {
        this.parentBeans.push(bean);
        this.pathStack.pushPathKey(key);
    }

    public void endAssocOne() {
        this.parentBeans.pop();
        this.pathStack.pop();
    }

    public void beginAssocMany(String key) {
        try {
            this.pathStack.pushPathKey(key);
            this.generator.writeFieldName(key);
            this.generator.writeStartArray();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public void endAssocMany() {
        try {
            this.pathStack.pop();
            this.generator.writeEndArray();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    public WriteBean createWriteBean(BeanDescriptor<?> desc, EntityBean bean) {
        JsonWriteBeanVisitor<?> visitor;
        String path = (String)this.pathStack.peekWithNull();
        JsonWriteBeanVisitor<?> jsonWriteBeanVisitor = visitor = this.visitors == null ? null : this.visitors.get(path);
        if (this.fetchPath == null) {
            return new WriteBean(desc, bean, visitor);
        }
        boolean explicitAllProps = false;
        Set<String> currentIncludeProps = this.fetchPath.getProperties(path);
        if (currentIncludeProps != null && ((explicitAllProps = currentIncludeProps.contains("*")) || currentIncludeProps.isEmpty())) {
            currentIncludeProps = null;
        }
        return new WriteBean(desc, explicitAllProps, currentIncludeProps, bean, visitor);
    }

    public void writeValueUsingObjectMapper(String name, Object value) {
        if (!this.isIncludeEmpty()) {
            if (value instanceof Collection && ((Collection)value).isEmpty()) {
                return;
            }
            if (value instanceof Map && ((Map)value).isEmpty()) {
                return;
            }
        }
        try {
            this.generator.writeFieldName(name);
            this.objectMapper().writeValue(this.generator, value);
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    private ObjectMapper objectMapper() {
        if (this.objectMapper == null) {
            throw new IllegalStateException("Jackson ObjectMapper required but not set. Expected to be set on either serverConfig");
        }
        return (ObjectMapper)this.objectMapper;
    }

    public Boolean includeMany(String key) {
        if (this.fetchPath != null) {
            String fullPath = this.pathStack.peekFullPath(key);
            return this.fetchPath.hasPath(fullPath);
        }
        return null;
    }

    public void toJson(String name, Collection<?> c) {
        try {
            this.beginAssocMany(name);
            for (Object bean : c) {
                BeanDescriptor<?> d = this.getDescriptor(bean.getClass());
                d.jsonWrite(this, (EntityBean)bean, null);
            }
            this.endAssocMany();
        }
        catch (IOException e) {
            throw new JsonIOException(e);
        }
    }

    private <T> BeanDescriptor<T> getDescriptor(Class<T> cls) {
        BeanDescriptor<T> d = this.server.getBeanDescriptor(cls);
        if (d == null) {
            throw new RuntimeException("No BeanDescriptor found for " + cls);
        }
        return d;
    }

    public static class WriteBean {
        final boolean explicitAllProps;
        final Set<String> currentIncludeProps;
        final BeanDescriptor<?> desc;
        final EntityBean currentBean;
        final JsonWriteBeanVisitor visitor;

        WriteBean(BeanDescriptor<?> desc, EntityBean currentBean, JsonWriteBeanVisitor visitor) {
            this(desc, false, null, currentBean, visitor);
        }

        WriteBean(BeanDescriptor<?> desc, boolean explicitAllProps, Set<String> currentIncludeProps, EntityBean currentBean, JsonWriteBeanVisitor visitor) {
            this.desc = desc;
            this.currentBean = currentBean;
            this.explicitAllProps = explicitAllProps;
            this.currentIncludeProps = currentIncludeProps;
            this.visitor = visitor;
        }

        private boolean isReferenceOnly() {
            return !this.explicitAllProps && this.currentIncludeProps == null && this.currentBean._ebean_getIntercept().isReference();
        }

        private boolean isIncludeProperty(BeanProperty prop) {
            if (this.explicitAllProps) {
                return true;
            }
            if (this.currentIncludeProps != null) {
                return this.currentIncludeProps.contains(prop.getName());
            }
            return this.currentBean._ebean_getIntercept().isLoadedProperty(prop.getPropertyIndex());
        }

        private boolean isIncludeTransientProperty(BeanProperty prop) {
            if (!this.explicitAllProps && this.currentIncludeProps != null) {
                return this.currentIncludeProps.contains(prop.getName());
            }
            return true;
        }

        public void write(WriteJson writeJson) {
            try {
                BeanProperty beanProp = this.desc.getIdProperty();
                if (beanProp != null && this.isIncludeProperty(beanProp)) {
                    beanProp.jsonWrite(writeJson, this.currentBean);
                }
                if (!this.isReferenceOnly()) {
                    int j;
                    BeanProperty[] props = this.desc.propertiesNonTransient();
                    for (j = 0; j < props.length; ++j) {
                        if (!this.isIncludeProperty(props[j])) continue;
                        props[j].jsonWrite(writeJson, this.currentBean);
                    }
                    props = this.desc.propertiesTransient();
                    for (j = 0; j < props.length; ++j) {
                        if (!this.isIncludeTransientProperty(props[j])) continue;
                        props[j].jsonWrite(writeJson, this.currentBean);
                    }
                }
                if (this.visitor != null) {
                    this.visitor.visit(this.currentBean, writeJson);
                }
            }
            catch (IOException e) {
                throw new JsonIOException(e);
            }
        }
    }
}

