/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.Version;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssoc;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.DbReadContext;
import com.avaje.ebeaninternal.server.deploy.DbSqlContext;
import com.avaje.ebeaninternal.server.deploy.TableJoin;
import com.avaje.ebeaninternal.server.query.SplitName;
import com.avaje.ebeaninternal.server.query.SqlJoinType;
import com.avaje.ebeaninternal.server.query.SqlTreeNode;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.List;

public class SqlTreeNodeExtraJoin
implements SqlTreeNode {
    private final BeanPropertyAssoc<?> assocBeanProperty;
    private final String prefix;
    private final boolean manyJoin;
    private final boolean pathContainsMany;
    private List<SqlTreeNodeExtraJoin> children;

    public SqlTreeNodeExtraJoin(String prefix, BeanPropertyAssoc<?> assocBeanProperty, boolean pathContainsMany) {
        this.prefix = prefix;
        this.assocBeanProperty = assocBeanProperty;
        this.pathContainsMany = pathContainsMany;
        this.manyJoin = assocBeanProperty instanceof BeanPropertyAssocMany;
    }

    @Override
    public void buildRawSqlSelectChain(List<String> selectChain) {
    }

    @Override
    public void addAsOfTableAlias(SpiQuery<?> query) {
    }

    @Override
    public void addSoftDeletePredicate(SpiQuery<?> query) {
    }

    public boolean isManyJoin() {
        return this.manyJoin;
    }

    public String getName() {
        return this.prefix;
    }

    public void addChild(SqlTreeNodeExtraJoin child) {
        if (this.children == null) {
            this.children = new ArrayList<SqlTreeNodeExtraJoin>();
        }
        this.children.add(child);
    }

    @Override
    public void appendFrom(DbSqlContext ctx, SqlJoinType joinType) {
        BeanPropertyAssocMany manyProp;
        boolean manyToMany = false;
        if (this.assocBeanProperty instanceof BeanPropertyAssocMany && (manyProp = (BeanPropertyAssocMany)this.assocBeanProperty).isManyToMany()) {
            manyToMany = true;
            String alias = ctx.getTableAlias(this.prefix);
            String[] split = SplitName.split(this.prefix);
            String parentAlias = ctx.getTableAlias(split[0]);
            String alias2 = alias + "z_";
            TableJoin manyToManyJoin = manyProp.getIntersectionTableJoin();
            manyToManyJoin.addJoin(joinType, parentAlias, alias2, ctx);
            this.assocBeanProperty.addJoin(joinType, alias2, alias, ctx);
        }
        if (this.pathContainsMany) {
            joinType = SqlJoinType.OUTER;
        }
        if (!manyToMany) {
            this.assocBeanProperty.addJoin(joinType, this.prefix, ctx);
        }
        if (this.children != null) {
            if (this.manyJoin || this.pathContainsMany) {
                joinType = joinType.autoToOuter();
            }
            for (int i = 0; i < this.children.size(); ++i) {
                SqlTreeNodeExtraJoin child = this.children.get(i);
                child.appendFrom(ctx, joinType);
            }
        }
    }

    @Override
    public void appendSelect(DbSqlContext ctx, boolean subQuery) {
    }

    @Override
    public void appendWhere(DbSqlContext ctx) {
    }

    @Override
    public EntityBean load(DbReadContext ctx, EntityBean localBean, EntityBean parentBean) throws SQLException {
        return null;
    }

    @Override
    public <T> Version<T> loadVersion(DbReadContext ctx) throws SQLException {
        return null;
    }
}

