/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.Transaction;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebeaninternal.api.BeanIdList;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.deploy.DbReadContext;
import com.avaje.ebeaninternal.server.query.CQueryPredicates;
import com.avaje.ebeaninternal.server.type.DataBind;
import com.avaje.ebeaninternal.server.type.DataReader;
import com.avaje.ebeaninternal.server.type.RsetDataReader;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class CQueryFetchIds {
    private static final Logger logger = LoggerFactory.getLogger(CQueryFetchIds.class);
    private final OrmQueryRequest<?> request;
    private final BeanDescriptor<?> desc;
    private final SpiQuery<?> query;
    private final CQueryPredicates predicates;
    private final String sql;
    private RsetDataReader dataReader;
    private PreparedStatement pstmt;
    private String bindLog;
    private int executionTimeMicros;
    private int rowCount;
    private final int maxRows;

    public CQueryFetchIds(OrmQueryRequest<?> request, CQueryPredicates predicates, String sql) {
        this.request = request;
        this.query = request.getQuery();
        this.sql = sql;
        this.maxRows = this.query.getMaxRows();
        this.query.setGeneratedSql(sql);
        this.desc = request.getBeanDescriptor();
        this.predicates = predicates;
    }

    public String getSummary() {
        StringBuilder sb = new StringBuilder(80);
        sb.append("FindIds exeMicros[").append(this.executionTimeMicros).append("] rows[").append(this.rowCount).append("] type[").append(this.desc.getName()).append("] predicates[").append(this.predicates.getLogWhereSql()).append("] bind[").append(this.bindLog).append("]");
        return sb.toString();
    }

    public String getBindLog() {
        return this.bindLog;
    }

    public String getGeneratedSql() {
        return this.sql;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BeanIdList findIds() throws SQLException {
        long startNano = System.nanoTime();
        try {
            List<Object> idList = this.query.getIdList();
            if (idList == null) {
                idList = Collections.synchronizedList(new ArrayList());
                this.query.setIdList(idList);
            }
            BeanIdList result = new BeanIdList(idList);
            Transaction t = this.request.getTransaction();
            Connection conn = t.getInternalConnection();
            this.pstmt = conn.prepareStatement(this.sql);
            if (this.query.getBufferFetchSizeHint() > 0) {
                this.pstmt.setFetchSize(this.query.getBufferFetchSizeHint());
            }
            if (this.query.getTimeout() > 0) {
                this.pstmt.setQueryTimeout(this.query.getTimeout());
            }
            this.bindLog = this.predicates.bind(new DataBind(this.pstmt));
            ResultSet rset = this.pstmt.executeQuery();
            this.dataReader = new RsetDataReader(rset);
            boolean hitMaxRows = false;
            boolean hasMoreRows = false;
            this.rowCount = 0;
            DbContext ctx = new DbContext();
            while (rset.next()) {
                Object idValue = this.desc.getIdBinder().read(ctx);
                idList.add(idValue);
                this.dataReader.resetColumnPosition();
                ++this.rowCount;
                if (this.maxRows <= 0 || this.rowCount != this.maxRows) continue;
                hitMaxRows = true;
                hasMoreRows = rset.next();
                break;
            }
            if (hitMaxRows) {
                result.setHasMore(hasMoreRows);
            }
            long exeNano = System.nanoTime() - startNano;
            this.executionTimeMicros = (int)exeNano / 1000;
            BeanIdList beanIdList = result;
            return beanIdList;
        }
        finally {
            this.close();
        }
    }

    private void close() {
        try {
            if (this.dataReader != null) {
                this.dataReader.close();
                this.dataReader = null;
            }
        }
        catch (SQLException e) {
            logger.error(null, (Throwable)e);
        }
        try {
            if (this.pstmt != null) {
                this.pstmt.close();
                this.pstmt = null;
            }
        }
        catch (SQLException e) {
            logger.error(null, (Throwable)e);
        }
    }

    class DbContext
    implements DbReadContext {
        DbContext() {
        }

        @Override
        public void propagateState(Object e) {
            throw new RuntimeException("Not Called");
        }

        @Override
        public SpiQuery.Mode getQueryMode() {
            return SpiQuery.Mode.NORMAL;
        }

        @Override
        public DataReader getDataReader() {
            return CQueryFetchIds.this.dataReader;
        }

        @Override
        public Boolean isReadOnly() {
            return Boolean.FALSE;
        }

        @Override
        public boolean isRawSql() {
            return false;
        }

        @Override
        public void register(String path, EntityBeanIntercept ebi) {
        }

        @Override
        public void register(String path, BeanCollection<?> bc) {
        }

        @Override
        public BeanPropertyAssocMany<?> getManyProperty() {
            return null;
        }

        @Override
        public PersistenceContext getPersistenceContext() {
            return null;
        }

        @Override
        public boolean isAutoTuneProfiling() {
            return false;
        }

        @Override
        public void profileBean(EntityBeanIntercept ebi, String prefix) {
        }

        @Override
        public void setCurrentPrefix(String currentPrefix, Map<String, String> pathMap) {
        }

        @Override
        public void setLazyLoadedChildBean(EntityBean loadedBean, Object lazyLoadParentId) {
        }

        @Override
        public boolean isDraftQuery() {
            return false;
        }
    }
}

