/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.query;

import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.RelationalQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.util.BeanCollectionFactory;
import java.util.Collection;
import java.util.Map;

public final class BeanCollectionWrapper {
    private final boolean isMap;
    private final String mapKey;
    private final BeanCollection<?> beanCollection;
    private final Collection<Object> collection;
    private final Map<Object, Object> map;
    private final BeanDescriptor<?> desc = null;
    private int rowCount;

    public BeanCollectionWrapper(RelationalQueryRequest request) {
        SpiQuery.Type queryType = request.getQueryType();
        this.mapKey = request.getQuery().getMapKey();
        this.isMap = SpiQuery.Type.MAP.equals((Object)queryType);
        this.beanCollection = this.createBeanCollection(queryType);
        this.collection = this.getCollection(this.isMap);
        this.map = this.getMap(this.isMap);
    }

    private Map<Object, Object> getMap(boolean isMap) {
        return isMap ? (Map)((Object)this.beanCollection) : null;
    }

    private Collection<Object> getCollection(boolean isMap) {
        return isMap ? null : (Collection)((Object)this.beanCollection);
    }

    public BeanCollection<?> getBeanCollection() {
        return this.beanCollection;
    }

    private BeanCollection<?> createBeanCollection(SpiQuery.Type manyType) {
        return BeanCollectionFactory.create(manyType);
    }

    public boolean isMap() {
        return this.isMap;
    }

    public int size() {
        return this.rowCount;
    }

    public void add(EntityBean bean) {
        this.add(bean, this.beanCollection);
    }

    public void add(EntityBean bean, Object collection) {
        if (bean == null) {
            return;
        }
        ++this.rowCount;
        if (this.isMap) {
            Object keyValue = this.mapKey != null ? this.desc.getValue(bean, this.mapKey) : this.desc.getId(bean);
            Map mapColl = (Map)collection;
            mapColl.put(keyValue, bean);
        } else {
            ((Collection)collection).add(bean);
        }
    }

    public void addToCollection(Object bean) {
        this.collection.add(bean);
    }

    public void addToMap(Object bean, Object key) {
        this.map.put(key, bean);
    }
}

