/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist.dml;

import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.lib.util.Str;
import com.avaje.ebeaninternal.server.persist.BatchedPstmt;
import com.avaje.ebeaninternal.server.persist.BatchedPstmtHolder;
import com.avaje.ebeaninternal.server.persist.dml.PersistHandler;
import com.avaje.ebeaninternal.server.persist.dmlbind.BindableRequest;
import com.avaje.ebeaninternal.server.transaction.TransactionManager;
import com.avaje.ebeaninternal.server.type.DataBind;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import javax.persistence.OptimisticLockException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class DmlHandler
implements PersistHandler,
BindableRequest {
    private static final Logger logger = LoggerFactory.getLogger(DmlHandler.class);
    protected final PersistRequestBean<?> persistRequest;
    protected final StringBuilder bindLog;
    protected final SpiTransaction transaction;
    protected final boolean emptyStringToNull;
    protected final boolean logLevelSql;
    protected final long now = System.currentTimeMillis();
    protected DataBind dataBind;
    protected String sql;
    protected Object versionValue;

    protected DmlHandler(PersistRequestBean<?> persistRequest, boolean emptyStringToNull) {
        this.persistRequest = persistRequest;
        this.emptyStringToNull = emptyStringToNull;
        this.transaction = persistRequest.getTransaction();
        this.logLevelSql = this.transaction.isLogSql();
        this.bindLog = this.logLevelSql ? new StringBuilder(50) : null;
    }

    @Override
    public long now() {
        return this.now;
    }

    @Override
    public PersistRequestBean<?> getPersistRequest() {
        return this.persistRequest;
    }

    @Override
    public abstract void bind() throws SQLException;

    @Override
    public abstract int execute() throws SQLException;

    protected void checkRowCount(int rowCount) throws OptimisticLockException {
        try {
            this.persistRequest.checkRowCount(rowCount);
            this.persistRequest.postExecute();
        }
        catch (OptimisticLockException e) {
            String m = e.getMessage() + " sql[" + this.sql + "] bind[" + this.bindLog + "]";
            this.persistRequest.getTransaction().logSummary("OptimisticLockException:" + m);
            throw new OptimisticLockException(m, null, e.getEntity());
        }
    }

    @Override
    public void addBatch() throws SQLException {
        this.dataBind.getPstmt().addBatch();
    }

    @Override
    public void close() {
        try {
            if (this.dataBind != null) {
                this.dataBind.close();
            }
        }
        catch (SQLException ex) {
            logger.error(null, (Throwable)ex);
        }
    }

    @Override
    public String getBindLog() {
        return this.bindLog == null ? "" : this.bindLog.toString();
    }

    @Override
    public void setIdValue(Object idValue) {
        this.persistRequest.setBoundId(idValue);
    }

    protected void logSql(String sql) {
        if (this.logLevelSql) {
            if (TransactionManager.SQL_LOGGER.isTraceEnabled()) {
                sql = Str.add(sql, "; --bind(", this.bindLog.toString(), ")");
            }
            this.transaction.logSql(sql);
        }
    }

    @Override
    public void bind(Object value, int sqlType) throws SQLException {
        if (this.logLevelSql) {
            if (value == null) {
                this.bindLog.append("null");
            } else {
                String sval = value.toString();
                if (sval.length() > 50) {
                    this.bindLog.append(sval.substring(0, 47)).append("...");
                } else {
                    this.bindLog.append(sval);
                }
            }
            this.bindLog.append(",");
        }
        this.dataBind.setObject(value, sqlType);
    }

    @Override
    public void bindNoLog(Object value, int sqlType, String logPlaceHolder) throws SQLException {
        if (this.logLevelSql) {
            this.bindLog.append(logPlaceHolder).append(" ");
        }
        this.dataBind.setObject(value, sqlType);
    }

    @Override
    public void bind(Object value, BeanProperty prop) throws SQLException {
        this.bindInternal(this.logLevelSql, value, prop);
    }

    @Override
    public void bindNoLog(Object value, BeanProperty prop) throws SQLException {
        this.bindInternal(false, value, prop);
    }

    private void bindInternal(boolean log, Object value, BeanProperty prop) throws SQLException {
        if (log) {
            if (prop.isLob()) {
                this.bindLog.append("[LOB]");
            } else {
                String sv = String.valueOf(value);
                if (sv.length() > 50) {
                    sv = sv.substring(0, 47) + "...";
                }
                this.bindLog.append(sv);
            }
            this.bindLog.append(",");
        }
        prop.bind(this.dataBind, value);
    }

    @Override
    public void registerGeneratedVersion(Object versionValue) {
        this.versionValue = versionValue;
    }

    public void setUpdateGenValues() {
        if (this.versionValue != null) {
            this.persistRequest.setVersionValue(this.versionValue);
        }
    }

    protected PreparedStatement getPstmt(SpiTransaction t, String sql, boolean genKeys) throws SQLException {
        Connection conn = t.getInternalConnection();
        if (genKeys) {
            int[] columns = new int[]{1};
            return conn.prepareStatement(sql, columns);
        }
        return conn.prepareStatement(sql);
    }

    protected PreparedStatement getPstmt(SpiTransaction t, String sql, PersistRequestBean<?> request, boolean genKeys) throws SQLException {
        BatchedPstmtHolder batch = t.getBatchControl().getPstmtHolder();
        PreparedStatement stmt = batch.getStmt(sql, request);
        if (stmt != null) {
            return stmt;
        }
        stmt = this.getPstmt(t, sql, genKeys);
        BatchedPstmt bs = new BatchedPstmt(stmt, genKeys, sql);
        batch.addStmt(bs, request);
        return stmt;
    }
}

