/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.persist;

import com.avaje.ebeaninternal.server.core.PersistRequest;
import com.avaje.ebeaninternal.server.core.PersistRequestBean;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.persist.BatchControl;
import java.util.ArrayList;
import java.util.IdentityHashMap;

public class BatchedBeanHolder {
    private static final Object DUMMY = new Object();
    private final BatchControl control;
    private final String shortDesc;
    private final int order;
    private ArrayList<PersistRequest> inserts;
    private ArrayList<PersistRequest> updates;
    private ArrayList<PersistRequest> deletes;
    private final IdentityHashMap<Object, Object> persistedBeans = new IdentityHashMap();

    public BatchedBeanHolder(BatchControl control, BeanDescriptor<?> beanDescriptor, int order) {
        this.control = control;
        this.shortDesc = beanDescriptor.getName() + ":" + order;
        this.order = order;
    }

    public int getOrder() {
        return this.order;
    }

    public void executeNow() {
        if (this.inserts != null && !this.inserts.isEmpty()) {
            this.control.executeNow(this.inserts);
            this.inserts.clear();
        }
        if (this.updates != null && !this.updates.isEmpty()) {
            this.control.executeNow(this.updates);
            this.updates.clear();
        }
        if (this.deletes != null && !this.deletes.isEmpty()) {
            this.control.executeNow(this.deletes);
            this.deletes.clear();
        }
        this.persistedBeans.clear();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder(this.shortDesc.length() + 18);
        sb.append(this.shortDesc);
        if (this.inserts != null) {
            sb.append(" i:").append(this.inserts.size());
        }
        if (this.updates != null) {
            sb.append(" u:").append(this.updates.size());
        }
        if (this.deletes != null) {
            sb.append(" d:").append(this.deletes.size());
        }
        return sb.toString();
    }

    public int append(PersistRequestBean<?> request) {
        Object alreadyInBatch = this.persistedBeans.put(request.getEntityBean(), DUMMY);
        if (alreadyInBatch != null) {
            return 0;
        }
        request.setBatched();
        switch (request.getType()) {
            case INSERT: {
                if (this.inserts == null) {
                    this.inserts = new ArrayList();
                }
                this.inserts.add(request);
                return this.inserts.size();
            }
            case UPDATE: 
            case SOFT_DELETE: {
                if (this.updates == null) {
                    this.updates = new ArrayList();
                }
                this.updates.add(request);
                return this.updates.size();
            }
            case DELETE: {
                if (this.deletes == null) {
                    this.deletes = new ArrayList();
                }
                this.deletes.add(request);
                return this.deletes.size();
            }
        }
        throw new RuntimeException("Invalid type code " + (Object)((Object)request.getType()));
    }

    public boolean isEmpty() {
        return this.persistedBeans.isEmpty();
    }
}

