/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.loadcontext;

import com.avaje.ebean.Query;
import com.avaje.ebean.bean.BeanCollection;
import com.avaje.ebean.bean.CallStack;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebean.bean.ObjectGraphNode;
import com.avaje.ebean.bean.ObjectGraphOrigin;
import com.avaje.ebean.bean.PersistenceContext;
import com.avaje.ebeaninternal.api.LoadContext;
import com.avaje.ebeaninternal.api.LoadSecondaryQuery;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.api.SpiQuerySecondary;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssoc;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocMany;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.loadcontext.DLoadBeanContext;
import com.avaje.ebeaninternal.server.loadcontext.DLoadManyContext;
import com.avaje.ebeaninternal.server.querydefn.OrmQueryProperties;
import java.sql.Timestamp;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DLoadContext
implements LoadContext {
    private final SpiEbeanServer ebeanServer;
    private final BeanDescriptor<?> rootDescriptor;
    private final Map<String, DLoadBeanContext> beanMap = new HashMap<String, DLoadBeanContext>();
    private final Map<String, DLoadManyContext> manyMap = new HashMap<String, DLoadManyContext>();
    private final DLoadBeanContext rootBeanContext;
    private final boolean asDraft;
    private final Timestamp asOf;
    private final Boolean readOnly;
    private final boolean excludeBeanCache;
    private final int defaultBatchSize;
    private final boolean disableLazyLoading;
    private final boolean disableReadAudit;
    private final boolean includeSoftDeletes;
    protected final boolean useDocStore;
    private final String relativePath;
    private final ObjectGraphOrigin origin;
    private final boolean useProfiling;
    private final Map<String, ObjectGraphNode> nodePathMap = new HashMap<String, ObjectGraphNode>();
    private PersistenceContext persistenceContext;
    private List<OrmQueryProperties> secQuery;

    public DLoadContext(BeanDescriptor<?> rootDescriptor, PersistenceContext persistenceContext) {
        this.useDocStore = true;
        this.rootDescriptor = rootDescriptor;
        this.ebeanServer = rootDescriptor.getEbeanServer();
        this.persistenceContext = persistenceContext;
        this.origin = this.initOrigin();
        this.defaultBatchSize = 100;
        this.excludeBeanCache = false;
        this.asDraft = false;
        this.asOf = null;
        this.readOnly = false;
        this.disableLazyLoading = false;
        this.disableReadAudit = false;
        this.includeSoftDeletes = false;
        this.relativePath = null;
        this.useProfiling = false;
        this.rootBeanContext = new DLoadBeanContext(this, rootDescriptor, null, this.defaultBatchSize, null);
    }

    private ObjectGraphOrigin initOrigin() {
        CallStack callStack = this.ebeanServer.createCallStack();
        return new ObjectGraphOrigin(0, callStack, this.rootDescriptor.getFullName());
    }

    public DLoadContext(OrmQueryRequest<?> request, SpiQuerySecondary secondaryQueries) {
        this.persistenceContext = request.getPersistenceContext();
        this.ebeanServer = request.getServer();
        this.defaultBatchSize = request.getLazyLoadBatchSize();
        this.rootDescriptor = request.getBeanDescriptor();
        Query query = request.getQuery();
        this.useDocStore = query.isUseDocStore();
        this.asOf = query.getAsOf();
        this.asDraft = query.isAsDraft();
        this.includeSoftDeletes = query.isIncludeSoftDeletes();
        this.readOnly = query.isReadOnly();
        this.disableReadAudit = query.isDisableReadAudit();
        this.disableLazyLoading = query.isDisableLazyLoading();
        this.excludeBeanCache = Boolean.FALSE.equals(query.isUseBeanCache());
        this.useProfiling = query.getProfilingListener() != null;
        ObjectGraphNode parentNode = query.getParentNode();
        if (parentNode != null) {
            this.origin = parentNode.getOriginQueryPoint();
            this.relativePath = parentNode.getPath();
        } else {
            this.origin = null;
            this.relativePath = null;
        }
        this.rootBeanContext = new DLoadBeanContext(this, this.rootDescriptor, null, this.defaultBatchSize, null);
        this.registerSecondaryQueries(secondaryQueries);
    }

    private void registerSecondaryQueries(SpiQuerySecondary secondaryQueries) {
        List<OrmQueryProperties> lazyJoins;
        this.secQuery = secondaryQueries.getQueryJoins();
        if (this.secQuery != null) {
            for (OrmQueryProperties pathProperties : this.secQuery) {
                this.registerSecondaryQuery(pathProperties);
            }
        }
        if ((lazyJoins = secondaryQueries.getLazyJoins()) != null) {
            for (OrmQueryProperties lazyJoin : lazyJoins) {
                this.registerSecondaryQuery(lazyJoin);
            }
        }
    }

    private void registerSecondaryQuery(OrmQueryProperties props) {
        ElPropertyValue elGetValue = this.rootDescriptor.getElGetValue(props.getPath());
        boolean many = elGetValue.getBeanProperty().containsMany();
        this.registerSecondaryNode(many, props);
    }

    protected boolean isExcludeBeanCache() {
        return this.excludeBeanCache;
    }

    @Override
    public int getSecondaryQueriesMinBatchSize(int defaultQueryBatch) {
        if (this.secQuery == null) {
            return -1;
        }
        int maxBatch = 0;
        for (int i = 0; i < this.secQuery.size(); ++i) {
            int batchSize = this.secQuery.get(i).getQueryFetchBatch();
            if (batchSize == 0) {
                batchSize = defaultQueryBatch;
            }
            maxBatch = Math.max(maxBatch, batchSize);
        }
        return maxBatch;
    }

    @Override
    public void executeSecondaryQueries(OrmQueryRequest<?> parentRequest, boolean forEach) {
        if (this.secQuery != null) {
            for (int i = 0; i < this.secQuery.size(); ++i) {
                LoadSecondaryQuery load = this.getLoadSecondaryQuery(this.secQuery.get(i).getPath());
                load.loadSecondaryQuery(parentRequest, forEach);
            }
        }
    }

    private LoadSecondaryQuery getLoadSecondaryQuery(String path) {
        LoadSecondaryQuery beanLoad = this.beanMap.get(path);
        if (beanLoad == null) {
            beanLoad = this.manyMap.get(path);
        }
        return beanLoad;
    }

    @Override
    public ObjectGraphNode getObjectGraphNode(String path) {
        ObjectGraphNode node = this.nodePathMap.get(path);
        if (node == null) {
            node = this.createObjectGraphNode(path);
            this.nodePathMap.put(path, node);
        }
        return node;
    }

    private ObjectGraphNode createObjectGraphNode(String path) {
        if (this.relativePath != null) {
            path = path == null ? this.relativePath : this.relativePath + "." + path;
        }
        return new ObjectGraphNode(this.origin, path);
    }

    protected String getFullPath(String path) {
        if (this.relativePath == null) {
            return path;
        }
        return this.relativePath + "." + path;
    }

    protected SpiEbeanServer getEbeanServer() {
        return this.ebeanServer;
    }

    protected Boolean isReadOnly() {
        return this.readOnly;
    }

    @Override
    public PersistenceContext getPersistenceContext() {
        return this.persistenceContext;
    }

    @Override
    public void resetPersistenceContext(PersistenceContext persistenceContext) {
        this.persistenceContext = persistenceContext;
        for (DLoadBeanContext beanContext : this.beanMap.values()) {
            beanContext.clear();
        }
        for (DLoadManyContext manyContext : this.manyMap.values()) {
            manyContext.clear();
        }
        this.rootBeanContext.clear();
    }

    @Override
    public void register(String path, EntityBeanIntercept ebi) {
        this.getBeanContext(path).register(ebi);
    }

    @Override
    public void register(String path, BeanCollection<?> bc) {
        this.getManyContext(path).register(bc);
    }

    protected DLoadBeanContext getBeanContext(String path) {
        if (path == null) {
            return this.rootBeanContext;
        }
        DLoadBeanContext beanContext = this.beanMap.get(path);
        if (beanContext == null) {
            beanContext = this.createBeanContext(path, this.defaultBatchSize, null);
            this.beanMap.put(path, beanContext);
        }
        return beanContext;
    }

    private void registerSecondaryNode(boolean many, OrmQueryProperties props) {
        int batchSize;
        String path = props.getPath();
        int lazyJoinBatch = props.getLazyFetchBatch();
        int n = batchSize = lazyJoinBatch > 0 ? lazyJoinBatch : this.defaultBatchSize;
        if (many) {
            DLoadManyContext manyContext = this.createManyContext(path, batchSize, props);
            this.manyMap.put(path, manyContext);
        } else {
            DLoadBeanContext beanContext = this.createBeanContext(path, batchSize, props);
            this.beanMap.put(path, beanContext);
        }
    }

    private DLoadManyContext getManyContext(String path) {
        if (path == null) {
            throw new RuntimeException("path is null?");
        }
        DLoadManyContext ctx = this.manyMap.get(path);
        if (ctx == null) {
            ctx = this.createManyContext(path, this.defaultBatchSize, null);
            this.manyMap.put(path, ctx);
        }
        return ctx;
    }

    private DLoadManyContext createManyContext(String path, int batchSize, OrmQueryProperties queryProps) {
        BeanPropertyAssocMany p = (BeanPropertyAssocMany)this.getBeanProperty(this.rootDescriptor, path);
        return new DLoadManyContext(this, p, path, batchSize, queryProps);
    }

    private DLoadBeanContext createBeanContext(String path, int batchSize, OrmQueryProperties queryProps) {
        BeanPropertyAssoc p = (BeanPropertyAssoc)this.getBeanProperty(this.rootDescriptor, path);
        BeanDescriptor targetDescriptor = p.getTargetDescriptor();
        return new DLoadBeanContext(this, targetDescriptor, path, batchSize, queryProps);
    }

    private BeanProperty getBeanProperty(BeanDescriptor<?> desc, String path) {
        return desc.getBeanPropertyFromPath(path);
    }

    public void propagateQueryState(SpiQuery<?> query, boolean docStoreMapped) {
        if (this.useDocStore && docStoreMapped) {
            query.setUseDocStore(true);
        }
        if (this.readOnly != null) {
            query.setReadOnly(this.readOnly);
        }
        query.setDisableLazyLoading(this.disableLazyLoading);
        query.asOf(this.asOf);
        if (this.asDraft) {
            query.asDraft();
        }
        if (this.includeSoftDeletes) {
            query.setIncludeSoftDeletes();
        }
        if (this.disableReadAudit) {
            query.setDisableReadAuditing();
        }
        if (this.useProfiling) {
            query.setAutoTune(true);
        }
    }
}

