/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.lib.util;

import java.util.HashMap;
import java.util.Map;

public class StringHelper {
    public static Map<String, String> delimitedToMap(String allNameValuePairs, String listDelimiter, String nameValueSeparator) {
        HashMap<String, String> params = new HashMap<String, String>();
        if (allNameValuePairs == null || allNameValuePairs.length() == 0) {
            return params;
        }
        allNameValuePairs = StringHelper.trimFront(allNameValuePairs, listDelimiter);
        return StringHelper.getKeyValue(params, 0, allNameValuePairs, listDelimiter, nameValueSeparator);
    }

    public static String trimFront(String source, String trim) {
        if (source == null) {
            return null;
        }
        if (source.indexOf(trim) == 0) {
            return StringHelper.trimFront(source.substring(trim.length()), trim);
        }
        return source;
    }

    public static boolean isNull(String value) {
        return value == null || value.trim().length() == 0;
    }

    private static HashMap<String, String> getKeyValue(HashMap<String, String> map, int pos, String allNameValuePairs, String listDelimiter, String nameValueSeparator) {
        if (pos >= allNameValuePairs.length()) {
            return map;
        }
        int equalsPos = allNameValuePairs.indexOf(nameValueSeparator, pos);
        int delimPos = allNameValuePairs.indexOf(listDelimiter, pos);
        if (delimPos == -1) {
            delimPos = allNameValuePairs.length();
        }
        if (equalsPos == -1) {
            return map;
        }
        if (delimPos == equalsPos + 1) {
            return StringHelper.getKeyValue(map, delimPos + 1, allNameValuePairs, listDelimiter, nameValueSeparator);
        }
        if (equalsPos > delimPos) {
            String key = allNameValuePairs.substring(pos, delimPos);
            if ((key = key.trim()).length() > 0) {
                map.put(key, null);
            }
            return StringHelper.getKeyValue(map, delimPos + 1, allNameValuePairs, listDelimiter, nameValueSeparator);
        }
        String key = allNameValuePairs.substring(pos, equalsPos);
        if (delimPos > -1) {
            String value = allNameValuePairs.substring(equalsPos + 1, delimPos);
            key = key.trim();
            map.put(key, value);
            pos = delimPos + 1;
            return StringHelper.getKeyValue(map, pos, allNameValuePairs, listDelimiter, nameValueSeparator);
        }
        return map;
    }

    public static String replaceString(String source, String match, String replace) {
        if (source == null) {
            return null;
        }
        if (replace == null) {
            return source;
        }
        if (match == null) {
            throw new NullPointerException("match is null?");
        }
        if (match.equals(replace)) {
            return source;
        }
        return StringHelper.replaceString(source, match, replace, 30, 0, source.length());
    }

    public static String replaceString(String source, String match, String replace, int additionalSize, int startPos, int endPos) {
        if (source == null) {
            return null;
        }
        char match0 = match.charAt(0);
        int matchLength = match.length();
        if (matchLength == 1 && replace.length() == 1) {
            char replace0 = replace.charAt(0);
            return source.replace(match0, replace0);
        }
        if (matchLength >= replace.length()) {
            additionalSize = 0;
        }
        int sourceLength = source.length();
        int lastMatch = endPos - matchLength;
        StringBuilder sb = new StringBuilder(sourceLength + additionalSize);
        if (startPos > 0) {
            sb.append(source.substring(0, startPos));
        }
        for (int i = startPos; i < sourceLength; ++i) {
            char sourceChar = source.charAt(i);
            if (i > lastMatch || sourceChar != match0) {
                sb.append(sourceChar);
                continue;
            }
            boolean isMatch = true;
            int sourceMatchPos = i;
            for (int j = 1; j < matchLength; ++j) {
                if (source.charAt(++sourceMatchPos) == match.charAt(j)) continue;
                isMatch = false;
                break;
            }
            if (isMatch) {
                i = i + matchLength - 1;
                sb.append(replace);
                continue;
            }
            sb.append(sourceChar);
        }
        return sb.toString();
    }

    public static String replaceStringMulti(String source, String[] match, String replace) {
        return StringHelper.replaceStringMulti(source, match, replace, 30, 0, source.length());
    }

    public static String replaceStringMulti(String source, String[] match, String replace, int additionalSize, int startPos, int endPos) {
        int shortestMatch = match[0].length();
        char[] match0 = new char[match.length];
        for (int i = 0; i < match0.length; ++i) {
            match0[i] = match[i].charAt(0);
            if (match[i].length() >= shortestMatch) continue;
            shortestMatch = match[i].length();
        }
        StringBuilder sb = new StringBuilder(source.length() + additionalSize);
        int len = source.length();
        int lastMatch = endPos - shortestMatch;
        if (startPos > 0) {
            sb.append(source.substring(0, startPos));
        }
        for (int i = startPos; i < len; ++i) {
            char sourceChar = source.charAt(i);
            if (i > lastMatch) {
                sb.append(sourceChar);
                continue;
            }
            int matchCount = 0;
            for (int k = 0; k < match0.length; ++k) {
                int j;
                if (matchCount != 0 || sourceChar != match0[k] || match[k].length() + i > len) continue;
                ++matchCount;
                for (j = 1; j < match[k].length(); ++j) {
                    if (source.charAt(i + j) == match[k].charAt(j)) continue;
                    --matchCount;
                    break;
                }
                if (matchCount <= 0) continue;
                i = i + j - 1;
                sb.append(replace);
                break;
            }
            if (matchCount != 0) continue;
            sb.append(sourceChar);
        }
        return sb.toString();
    }
}

