/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import java.io.IOException;

class NullExpression
extends AbstractExpression {
    private final boolean notNull;

    NullExpression(String propertyName, boolean notNull) {
        super(propertyName);
        this.notNull = notNull;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeExists(this.notNull, this.propName);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String propertyName = this.propName;
        String nullExpr = this.notNull ? " is not null " : " is null ";
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isAssocId()) {
            request.append(prop.getAssocIdExpression(propertyName, nullExpr));
            return;
        }
        request.append(propertyName).append(nullExpr);
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof NullExpression)) {
            return false;
        }
        NullExpression that = (NullExpression)other;
        return this.propName.equals(that.propName) && this.notNull == that.notNull;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        return true;
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(NullExpression.class).add(this.notNull).add(this.propName);
    }

    @Override
    public int queryBindHash() {
        return this.notNull ? 1 : 0;
    }
}

