/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.LikeType;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import java.io.IOException;

class LikeExpression
extends AbstractExpression {
    private final String val;
    private final boolean caseInsensitive;
    private final LikeType type;

    LikeExpression(String propertyName, String value, boolean caseInsensitive, LikeType type) {
        super(propertyName);
        this.caseInsensitive = caseInsensitive;
        this.type = type;
        this.val = value;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeLike(this.propName, this.val, this.type, this.caseInsensitive);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            String encryptKey = prop.getBeanProperty().getEncryptKey().getStringValue();
            request.addBindEncryptKey(encryptKey);
        }
        String bindValue = LikeExpression.getValue(this.val, this.caseInsensitive, this.type);
        request.addBindValue(bindValue);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String pname = this.propName;
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            pname = prop.getBeanProperty().getDecryptProperty(this.propName);
        }
        if (this.caseInsensitive) {
            request.append("lower(").append(pname).append(")");
        } else {
            request.append(pname);
        }
        if (this.type.equals((Object)LikeType.EQUAL_TO)) {
            request.append(" = ? ");
        } else {
            request.appendLike();
        }
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(LikeExpression.class).add(this.caseInsensitive).add(this.propName);
        builder.bind(1);
    }

    @Override
    public int queryBindHash() {
        return this.val.hashCode();
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof LikeExpression)) {
            return false;
        }
        LikeExpression that = (LikeExpression)other;
        return this.propName.equals(that.propName) && this.caseInsensitive == that.caseInsensitive && this.type == that.type;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        LikeExpression that = (LikeExpression)other;
        return this.val.equals(that.val);
    }

    private static String getValue(String value, boolean caseInsensitive, LikeType type) {
        if (caseInsensitive) {
            value = value.toLowerCase();
        }
        switch (type) {
            case RAW: {
                return value;
            }
            case STARTS_WITH: {
                return value + "%";
            }
            case ENDS_WITH: {
                return "%" + value;
            }
            case CONTAINS: {
                return "%" + value + "%";
            }
            case EQUAL_TO: {
                return value;
            }
        }
        throw new RuntimeException("LikeType " + (Object)((Object)type) + " missed?");
    }
}

