/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.expression.Op;
import com.avaje.ebeaninternal.server.expression.Same;
import java.io.IOException;

class JsonPathExpression
extends AbstractExpression {
    protected final String path;
    protected final Op operator;
    protected final Object value;
    protected final Object upperValue;

    JsonPathExpression(String propertyName, String path, Op operator, Object value) {
        super(propertyName);
        this.path = path;
        this.operator = operator;
        this.value = value;
        this.upperValue = null;
    }

    JsonPathExpression(String propertyName, String path, Object value, Object upperValue) {
        super(propertyName);
        this.path = path;
        this.operator = Op.BETWEEN;
        this.value = value;
        this.upperValue = upperValue;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        String fullName = this.propName + "." + this.path;
        if (this.operator == Op.BETWEEN) {
            context.writeRange(fullName, Op.GT_EQ, this.value, Op.LT_EQ, this.upperValue);
        } else {
            context.writeSimple(this.operator, fullName, this.value);
        }
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(JsonPathExpression.class).add(this.propName).add(this.path).add((Object)this.operator);
        builder.bindIfNotNull(this.value);
        builder.bindIfNotNull(this.upperValue);
    }

    @Override
    public int queryBindHash() {
        int hc = this.value == null ? 0 : this.value.hashCode();
        hc = this.upperValue == null ? hc : hc * 31 + this.upperValue.hashCode();
        return hc;
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof JsonPathExpression)) {
            return false;
        }
        JsonPathExpression that = (JsonPathExpression)other;
        return this.propName.equals(that.propName) && this.operator == that.operator && Same.sameByValue(this.path, that.path) && Same.sameByNull(this.value, that.value) && Same.sameByNull(this.upperValue, that.upperValue);
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        JsonPathExpression that = (JsonPathExpression)other;
        if (this.value != null ? !this.value.equals(that.value) : that.value != null) {
            return false;
        }
        return this.upperValue != null ? this.upperValue.equals(that.upperValue) : that.upperValue == null;
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        request.getJsonHandler().addSql(request, this.propName, this.path, this.operator, this.value);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        if (this.value != null) {
            request.addBindValue(this.value);
        }
        if (this.upperValue != null) {
            request.addBindValue(this.upperValue);
        }
    }
}

