/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import java.io.IOException;
import java.util.Collection;

class InExpression
extends AbstractExpression {
    private final boolean not;
    private final Object[] values;

    InExpression(String propertyName, Collection<?> coll, boolean not) {
        super(propertyName);
        this.values = coll.toArray(new Object[coll.size()]);
        this.not = not;
    }

    InExpression(String propertyName, Object[] array, boolean not) {
        super(propertyName);
        this.values = array;
        this.not = not;
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeIn(this.propName, this.values, this.not);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && !prop.isAssocId()) {
            prop = null;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (prop == null) {
                request.addBindValue(this.values[i]);
                continue;
            }
            Object[] ids = prop.getAssocIdValues((EntityBean)this.values[i]);
            if (ids == null) continue;
            for (int j = 0; j < ids.length; ++j) {
                request.addBindValue(ids[j]);
            }
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        if (this.values.length == 0) {
            String expr = this.not ? "1=1" : "1=0";
            request.append(expr);
            return;
        }
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && !prop.isAssocId()) {
            prop = null;
        }
        if (prop != null) {
            request.append(prop.getAssocIdInExpr(this.propName));
            String inClause = prop.getAssocIdInValueExpr(this.values.length);
            request.append(inClause);
        } else {
            request.append(this.propName);
            if (this.not) {
                request.append(" not");
            }
            request.append(" in (?");
            for (int i = 1; i < this.values.length; ++i) {
                request.append(", ").append("?");
            }
            request.append(" ) ");
        }
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(InExpression.class).add(this.propName).add(this.values.length).add(this.not);
        builder.bind(this.values.length);
    }

    @Override
    public int queryBindHash() {
        int hc = 31;
        for (int i = 0; i < this.values.length; ++i) {
            hc = 31 * hc + this.values[i].hashCode();
        }
        return hc;
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof InExpression)) {
            return false;
        }
        InExpression that = (InExpression)other;
        return this.propName.equals(that.propName) && this.not == that.not && this.values.length == that.values.length;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        InExpression that = (InExpression)other;
        if (this.values.length != that.values.length) {
            return false;
        }
        for (int i = 0; i < this.values.length; ++i) {
            if (this.values[i].equals(that.values[i])) continue;
            return false;
        }
        return true;
    }
}

