/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.api.SpiExpressionValidation;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.id.IdBinder;
import com.avaje.ebeaninternal.server.expression.DefaultExpressionRequest;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.expression.NonPrepareExpression;
import java.io.IOException;
import java.util.List;

public class IdInExpression
extends NonPrepareExpression {
    private final List<?> idList;

    public IdInExpression(List<?> idList) {
        this.idList = idList;
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins manyWhereJoin) {
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeIds(this.idList);
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        DefaultExpressionRequest r = (DefaultExpressionRequest)request;
        BeanDescriptor<?> descriptor = r.getBeanDescriptor();
        IdBinder idBinder = descriptor.getIdBinder();
        for (int i = 0; i < this.idList.size(); ++i) {
            idBinder.addIdInBindValue(request, this.idList.get(i));
        }
    }

    public void addSqlNoAlias(SpiExpressionRequest request) {
        DefaultExpressionRequest r = (DefaultExpressionRequest)request;
        BeanDescriptor<?> descriptor = r.getBeanDescriptor();
        IdBinder idBinder = descriptor.getIdBinder();
        request.append(descriptor.getIdBinder().getBindIdInSql(null));
        String inClause = idBinder.getIdInValueExpr(this.idList.size());
        request.append(inClause);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        DefaultExpressionRequest r = (DefaultExpressionRequest)request;
        BeanDescriptor<?> descriptor = r.getBeanDescriptor();
        IdBinder idBinder = descriptor.getIdBinder();
        request.append(descriptor.getIdBinderInLHSSql());
        String inClause = idBinder.getIdInValueExpr(this.idList.size());
        request.append(inClause);
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(IdInExpression.class).add(this.idList.size());
        builder.bind(this.idList.size());
    }

    @Override
    public int queryBindHash() {
        return this.idList.hashCode();
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof IdInExpression)) {
            return false;
        }
        IdInExpression that = (IdInExpression)other;
        return this.idList.size() == that.idList.size();
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        IdInExpression that = (IdInExpression)other;
        if (this.idList.size() != that.idList.size()) {
            return false;
        }
        for (int i = 0; i < this.idList.size(); ++i) {
            if (this.idList.get(i).equals(that.idList.get(i))) continue;
            return false;
        }
        return true;
    }
}

