/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebean.ExampleExpression;
import com.avaje.ebean.LikeType;
import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.event.BeanQueryRequest;
import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.ManyWhereJoins;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.api.SpiExpressionValidation;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import com.avaje.ebeaninternal.server.deploy.BeanProperty;
import com.avaje.ebeaninternal.server.deploy.BeanPropertyAssocOne;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import com.avaje.ebeaninternal.server.expression.LikeExpression;
import com.avaje.ebeaninternal.server.expression.Op;
import com.avaje.ebeaninternal.server.expression.SimpleExpression;
import com.avaje.ebeaninternal.server.query.SplitName;
import java.io.IOException;
import java.util.ArrayList;

public class DefaultExampleExpression
implements SpiExpression,
ExampleExpression {
    private final EntityBean entity;
    private boolean caseInsensitive;
    private LikeType likeType;
    private boolean includeZeros;
    private ArrayList<SpiExpression> list;

    public DefaultExampleExpression(EntityBean entity, boolean caseInsensitive, LikeType likeType) {
        this.entity = entity;
        this.caseInsensitive = caseInsensitive;
        this.likeType = likeType;
    }

    DefaultExampleExpression(ArrayList<SpiExpression> source) {
        this.entity = null;
        this.list = new ArrayList(source.size());
        for (SpiExpression expression : source) {
            this.list.add(expression.copyForPlanKey());
        }
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        if (!this.list.isEmpty()) {
            context.startBoolMust();
            for (SpiExpression expr : this.list) {
                expr.writeDocQuery(context);
            }
            context.endBool();
        }
    }

    @Override
    public SpiExpression copyForPlanKey() {
        return new DefaultExampleExpression(this.list);
    }

    @Override
    public void containsMany(BeanDescriptor<?> desc, ManyWhereJoins whereManyJoins) {
        if (this.list != null) {
            for (int i = 0; i < this.list.size(); ++i) {
                this.list.get(i).containsMany(desc, whereManyJoins);
            }
        }
    }

    @Override
    public ExampleExpression includeZeros() {
        this.includeZeros = true;
        return this;
    }

    @Override
    public ExampleExpression caseInsensitive() {
        this.caseInsensitive = true;
        return this;
    }

    @Override
    public ExampleExpression useStartsWith() {
        this.likeType = LikeType.STARTS_WITH;
        return this;
    }

    @Override
    public ExampleExpression useContains() {
        this.likeType = LikeType.CONTAINS;
        return this;
    }

    @Override
    public ExampleExpression useEndsWith() {
        this.likeType = LikeType.ENDS_WITH;
        return this;
    }

    @Override
    public ExampleExpression useEqualTo() {
        this.likeType = LikeType.EQUAL_TO;
        return this;
    }

    @Override
    public void validate(SpiExpressionValidation validation) {
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).validate(validation);
        }
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        for (int i = 0; i < this.list.size(); ++i) {
            SpiExpression item = this.list.get(i);
            item.addBindValues(request);
        }
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        if (!this.list.isEmpty()) {
            request.append("(");
            for (int i = 0; i < this.list.size(); ++i) {
                SpiExpression item = this.list.get(i);
                if (i > 0) {
                    request.append(" and ");
                }
                item.addSql(request);
            }
            request.append(") ");
        }
    }

    @Override
    public void prepareExpression(BeanQueryRequest<?> request) {
        this.list = this.buildExpressions(request);
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(DefaultExampleExpression.class);
        for (int i = 0; i < this.list.size(); ++i) {
            this.list.get(i).queryPlanHash(builder);
        }
    }

    @Override
    public int queryBindHash() {
        int hc = DefaultExampleExpression.class.getName().hashCode();
        for (int i = 0; i < this.list.size(); ++i) {
            hc = hc * 31 + this.list.get(i).queryBindHash();
        }
        return hc;
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof DefaultExampleExpression)) {
            return false;
        }
        DefaultExampleExpression that = (DefaultExampleExpression)other;
        if (this.list.size() != that.list.size()) {
            return false;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i).isSameByPlan(that.list.get(i))) continue;
            return false;
        }
        return true;
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        DefaultExampleExpression that = (DefaultExampleExpression)other;
        if (this.list.size() != that.list.size()) {
            return false;
        }
        for (int i = 0; i < this.list.size(); ++i) {
            if (this.list.get(i).isSameByBind(that.list.get(i))) continue;
            return false;
        }
        return true;
    }

    private ArrayList<SpiExpression> buildExpressions(BeanQueryRequest<?> request) {
        ArrayList<SpiExpression> list = new ArrayList<SpiExpression>();
        OrmQueryRequest r = (OrmQueryRequest)request;
        BeanDescriptor beanDescriptor = r.getBeanDescriptor();
        this.addExpressions(list, beanDescriptor, this.entity, null);
        return list;
    }

    private void addExpressions(ArrayList<SpiExpression> list, BeanDescriptor<?> beanDescriptor, EntityBean bean, String prefix) {
        for (BeanProperty beanProperty : beanDescriptor.propertiesAll()) {
            Object value;
            if (beanProperty.isTransient() || (value = beanProperty.getValue(bean)) == null) continue;
            String propName = SplitName.add(prefix, beanProperty.getName());
            if (beanProperty.isScalar()) {
                if (value instanceof String) {
                    list.add(new LikeExpression(propName, (String)value, this.caseInsensitive, this.likeType));
                    continue;
                }
                if (!this.includeZeros && this.isZero(value)) continue;
                list.add(new SimpleExpression(propName, Op.EQ, value));
                continue;
            }
            if (!(beanProperty instanceof BeanPropertyAssocOne) || !(value instanceof EntityBean)) continue;
            BeanPropertyAssocOne assocOne = (BeanPropertyAssocOne)beanProperty;
            BeanDescriptor targetDescriptor = assocOne.getTargetDescriptor();
            this.addExpressions(list, targetDescriptor, (EntityBean)value, propName);
        }
    }

    private boolean isZero(Object value) {
        Number num;
        double doubleValue;
        return value instanceof Number && (doubleValue = (num = (Number)value).doubleValue()) == 0.0;
    }
}

