/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.expression;

import com.avaje.ebeaninternal.api.HashQueryPlanBuilder;
import com.avaje.ebeaninternal.api.SpiExpression;
import com.avaje.ebeaninternal.api.SpiExpressionRequest;
import com.avaje.ebeaninternal.server.el.ElPropertyValue;
import com.avaje.ebeaninternal.server.expression.AbstractExpression;
import com.avaje.ebeaninternal.server.expression.DocQueryContext;
import java.io.IOException;

class CaseInsensitiveEqualExpression
extends AbstractExpression {
    private final String value;

    CaseInsensitiveEqualExpression(String propertyName, String value) {
        super(propertyName);
        this.value = value.toLowerCase();
    }

    @Override
    public void writeDocQuery(DocQueryContext context) throws IOException {
        context.writeIEqualTo(this.propName, this.value);
    }

    @Override
    public void addBindValues(SpiExpressionRequest request) {
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            String encryptKey = prop.getBeanProperty().getEncryptKey().getStringValue();
            request.addBindEncryptKey(encryptKey);
        }
        request.addBindValue(this.value);
    }

    @Override
    public void addSql(SpiExpressionRequest request) {
        String pname = this.propName;
        ElPropertyValue prop = this.getElProp(request);
        if (prop != null && prop.isDbEncrypted()) {
            pname = prop.getBeanProperty().getDecryptProperty(this.propName);
        }
        request.append("lower(").append(pname).append(") =? ");
    }

    @Override
    public void queryPlanHash(HashQueryPlanBuilder builder) {
        builder.add(CaseInsensitiveEqualExpression.class).add(this.propName);
        builder.bind(1);
    }

    @Override
    public int queryBindHash() {
        return this.value.hashCode();
    }

    @Override
    public boolean isSameByPlan(SpiExpression other) {
        if (!(other instanceof CaseInsensitiveEqualExpression)) {
            return false;
        }
        CaseInsensitiveEqualExpression that = (CaseInsensitiveEqualExpression)other;
        return this.propName.equals(that.propName);
    }

    @Override
    public boolean isSameByBind(SpiExpression other) {
        CaseInsensitiveEqualExpression that = (CaseInsensitiveEqualExpression)other;
        return this.value.equals(that.value);
    }
}

