/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.EbeanServer;
import com.avaje.ebean.cache.ServerCacheFactory;
import com.avaje.ebean.cache.ServerCacheManager;
import com.avaje.ebean.cache.ServerCacheOptions;
import com.avaje.ebean.common.SpiContainer;
import com.avaje.ebean.config.ContainerConfig;
import com.avaje.ebean.config.PropertyMap;
import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebean.config.UnderscoreNamingConvention;
import com.avaje.ebean.config.dbplatform.DatabasePlatform;
import com.avaje.ebean.dbmigration.DbOffline;
import com.avaje.ebeaninternal.api.SpiBackgroundExecutor;
import com.avaje.ebeaninternal.api.SpiEbeanServer;
import com.avaje.ebeaninternal.server.cache.DefaultServerCacheFactory;
import com.avaje.ebeaninternal.server.cache.DefaultServerCacheManager;
import com.avaje.ebeaninternal.server.cluster.ClusterManager;
import com.avaje.ebeaninternal.server.core.BootupClassPathSearch;
import com.avaje.ebeaninternal.server.core.BootupClasses;
import com.avaje.ebeaninternal.server.core.DatabasePlatformFactory;
import com.avaje.ebeaninternal.server.core.DefaultBackgroundExecutor;
import com.avaje.ebeaninternal.server.core.DefaultServer;
import com.avaje.ebeaninternal.server.core.InternalConfiguration;
import com.avaje.ebeaninternal.server.core.JndiDataSourceLookup;
import com.avaje.ebeaninternal.server.core.XmlConfig;
import com.avaje.ebeaninternal.server.core.XmlConfigLoader;
import com.avaje.ebeaninternal.server.lib.ShutdownManager;
import java.sql.Connection;
import java.sql.SQLException;
import java.util.Iterator;
import java.util.List;
import java.util.Properties;
import java.util.ServiceLoader;
import java.util.Timer;
import java.util.TimerTask;
import javax.persistence.PersistenceException;
import javax.sql.DataSource;
import org.avaje.datasource.DataSourceAlertFactory;
import org.avaje.datasource.DataSourceConfig;
import org.avaje.datasource.DataSourceFactory;
import org.avaje.datasource.DataSourcePoolListener;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DefaultContainer
implements SpiContainer {
    private static final Logger logger = LoggerFactory.getLogger((String)"com.avaje.ebean.internal.DefaultContainer");
    private final ClusterManager clusterManager;
    private final JndiDataSourceLookup jndiDataSourceFactory;

    public DefaultContainer(ContainerConfig containerConfig) {
        this.clusterManager = new ClusterManager(containerConfig);
        this.jndiDataSourceFactory = new JndiDataSourceLookup();
        ShutdownManager.registerContainer(this);
    }

    @Override
    public void shutdown() {
        this.clusterManager.shutdown();
    }

    @Override
    public SpiEbeanServer createServer(String name) {
        ServerConfig config = new ServerConfig();
        config.setName(name);
        Properties prop = PropertyMap.defaultProperties();
        config.loadFromProperties(prop);
        return this.createServer(config);
    }

    private SpiBackgroundExecutor createBackgroundExecutor(ServerConfig serverConfig) {
        String namePrefix = "ebean-" + serverConfig.getName();
        int schedulePoolSize = serverConfig.getBackgroundExecutorSchedulePoolSize();
        int corePoolSize = serverConfig.getBackgroundExecutorCorePoolSize();
        int maxPoolSize = serverConfig.getBackgroundExecutorMaxPoolSize();
        int idleSecs = serverConfig.getBackgroundExecutorIdleSecs();
        int shutdownSecs = serverConfig.getBackgroundExecutorShutdownSecs();
        return new DefaultBackgroundExecutor(schedulePoolSize, corePoolSize, maxPoolSize, idleSecs, shutdownSecs, namePrefix);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SpiEbeanServer createServer(ServerConfig serverConfig) {
        DefaultContainer defaultContainer = this;
        synchronized (defaultContainer) {
            this.setNamingConvention(serverConfig);
            BootupClasses bootupClasses = this.getBootupClasses(serverConfig);
            this.setDataSource(serverConfig);
            boolean online = this.checkDataSource(serverConfig);
            this.setDatabasePlatform(serverConfig);
            if (serverConfig.getDbEncrypt() != null) {
                serverConfig.getDatabasePlatform().setDbEncrypt(serverConfig.getDbEncrypt());
            }
            serverConfig.getNamingConvention().setDatabasePlatform(serverConfig.getDatabasePlatform());
            ServerCacheManager cacheManager = this.getCacheManager(serverConfig);
            SpiBackgroundExecutor bgExecutor = this.createBackgroundExecutor(serverConfig);
            XmlConfigLoader xmlConfigLoader = new XmlConfigLoader(null);
            XmlConfig xmlConfig = xmlConfigLoader.load();
            InternalConfiguration c = new InternalConfiguration(xmlConfig, this.clusterManager, cacheManager, bgExecutor, serverConfig, bootupClasses);
            DefaultServer server = new DefaultServer(c, cacheManager);
            cacheManager.init(server);
            if (!DbOffline.isRunningMigration()) {
                server.executePlugins(online);
            }
            server.initialise();
            if (online) {
                long sleepMillis;
                if (this.clusterManager.isClustering()) {
                    this.clusterManager.registerServer(server);
                }
                if ((sleepMillis = (long)(1000 * serverConfig.getCacheWarmingDelay())) > 0L) {
                    Timer timer = new Timer("EbeanCacheWarmer", true);
                    timer.schedule((TimerTask)new CacheWarmer(server, timer), sleepMillis);
                }
            }
            server.start();
            DbOffline.reset();
            return server;
        }
    }

    private ServerCacheManager getCacheManager(ServerConfig serverConfig) {
        ServerCacheManager serverCacheManager = serverConfig.getServerCacheManager();
        if (serverCacheManager != null) {
            return serverCacheManager;
        }
        ServerCacheOptions beanOptions = new ServerCacheOptions();
        beanOptions.setMaxSize(serverConfig.getCacheMaxSize());
        beanOptions.setMaxIdleSecs(serverConfig.getCacheMaxIdleTime());
        beanOptions.setMaxSecsToLive(serverConfig.getCacheMaxTimeToLive());
        ServerCacheOptions queryOptions = new ServerCacheOptions();
        queryOptions.setMaxSize(serverConfig.getQueryCacheMaxSize());
        queryOptions.setMaxIdleSecs(serverConfig.getQueryCacheMaxIdleTime());
        queryOptions.setMaxSecsToLive(serverConfig.getQueryCacheMaxTimeToLive());
        ServerCacheFactory cacheFactory = serverConfig.getServerCacheFactory();
        if (cacheFactory == null) {
            ServiceLoader<ServerCacheFactory> cacheFactories = ServiceLoader.load(ServerCacheFactory.class);
            Iterator<ServerCacheFactory> iterator = cacheFactories.iterator();
            if (iterator.hasNext()) {
                cacheFactory = iterator.next();
                logger.debug("using ServerCacheFactory {}", cacheFactory.getClass());
            } else {
                cacheFactory = new DefaultServerCacheFactory();
            }
        }
        return new DefaultServerCacheManager(cacheFactory, beanOptions, queryOptions);
    }

    private BootupClasses getBootupClasses(ServerConfig serverConfig) {
        BootupClasses bootupClasses = this.getBootupClasses1(serverConfig);
        bootupClasses.addPersistControllers(serverConfig.getPersistControllers());
        bootupClasses.addPostLoaders(serverConfig.getPostLoaders());
        bootupClasses.addFindControllers(serverConfig.getFindControllers());
        bootupClasses.addTransactionEventListeners(serverConfig.getTransactionEventListeners());
        bootupClasses.addPersistListeners(serverConfig.getPersistListeners());
        bootupClasses.addQueryAdapters(serverConfig.getQueryAdapters());
        bootupClasses.addServerConfigStartup(serverConfig.getServerConfigStartupListeners());
        bootupClasses.addChangeLogInstances(serverConfig);
        bootupClasses.runServerConfigStartup(serverConfig);
        return bootupClasses;
    }

    private BootupClasses getBootupClasses1(ServerConfig serverConfig) {
        List<Class<?>> entityClasses = serverConfig.getClasses();
        if (serverConfig.isDisableClasspathSearch() || entityClasses != null && entityClasses.size() > 0) {
            return new BootupClasses(serverConfig.getClasses());
        }
        return BootupClassPathSearch.search(serverConfig);
    }

    private void setNamingConvention(ServerConfig config) {
        if (config.getNamingConvention() == null) {
            config.setNamingConvention(new UnderscoreNamingConvention());
        }
    }

    private void setDatabasePlatform(ServerConfig config) {
        DatabasePlatform dbPlatform = config.getDatabasePlatform();
        if (dbPlatform == null) {
            DatabasePlatformFactory factory = new DatabasePlatformFactory();
            DatabasePlatform db = factory.create(config);
            config.setDatabasePlatform(db);
            logger.info("DatabasePlatform name:" + config.getName() + " platform:" + db.getName());
        }
    }

    private void setDataSource(ServerConfig config) {
        if (config.getDataSource() == null) {
            config.setDataSource(this.getDataSourceFromConfig(config));
        }
    }

    private DataSource getDataSourceFromConfig(ServerConfig config) {
        if (DbOffline.isSet()) {
            logger.debug("... DbOffline using platform [{}]", (Object)DbOffline.getPlatform());
            return null;
        }
        if (config.getDataSourceJndiName() != null) {
            DataSource ds = this.jndiDataSourceFactory.lookup(config.getDataSourceJndiName());
            if (ds == null) {
                throw new PersistenceException("JNDI lookup for DataSource " + config.getDataSourceJndiName() + " returned null.");
            }
            return ds;
        }
        DataSourceConfig dsConfig = config.getDataSourceConfig();
        if (dsConfig == null) {
            throw new PersistenceException("No DataSourceConfig defined for " + config.getName());
        }
        if (dsConfig.isOffline()) {
            if (config.getDatabasePlatformName() == null) {
                throw new PersistenceException("You MUST specify a DatabasePlatformName on ServerConfig when offline");
            }
            return null;
        }
        DataSourceFactory factory = config.service(DataSourceFactory.class);
        if (factory == null) {
            throw new IllegalStateException("No DataSourceFactory service implementation found in class path. Probably missing dependency to avaje-datasource?");
        }
        DataSourceAlertFactory alertFactory = config.service(DataSourceAlertFactory.class);
        if (alertFactory != null) {
            dsConfig.setAlert(alertFactory.createAlert());
        }
        this.attachListener(config, dsConfig);
        return factory.createPool(config.getName(), dsConfig);
    }

    private void attachListener(ServerConfig config, DataSourceConfig dsConfig) {
        String poolListener;
        if (dsConfig.getListener() == null && (poolListener = dsConfig.getPoolListener()) != null) {
            dsConfig.setListener((DataSourcePoolListener)config.getClassLoadConfig().newInstance(poolListener));
        }
    }

    private boolean checkDataSource(ServerConfig serverConfig) {
        if (DbOffline.isSet()) {
            return false;
        }
        if (serverConfig.getDataSource() == null) {
            if (serverConfig.getDataSourceConfig().isOffline()) {
                return false;
            }
            throw new RuntimeException("DataSource not set?");
        }
        Connection c = null;
        try {
            c = serverConfig.getDataSource().getConnection();
            if (c.getAutoCommit()) {
                logger.warn("DataSource [{}] has autoCommit defaulting to true!", (Object)serverConfig.getName());
            }
            boolean bl = true;
            return bl;
        }
        catch (SQLException ex) {
            throw new PersistenceException((Throwable)ex);
        }
        finally {
            if (c != null) {
                try {
                    c.close();
                }
                catch (SQLException ex) {
                    logger.error("Error closing connection", (Throwable)ex);
                }
            }
        }
    }

    private static class CacheWarmer
    extends TimerTask {
        private final EbeanServer server;
        private final Timer timer;

        CacheWarmer(EbeanServer server, Timer timer) {
            this.server = server;
            this.timer = timer;
        }

        @Override
        public void run() {
            this.server.runCacheWarming();
            this.timer.cancel();
        }
    }
}

