/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.core;

import com.avaje.ebean.config.ServerConfig;
import com.avaje.ebeaninternal.server.core.BootupClasses;
import com.avaje.ebeaninternal.server.core.ClassPathScanners;
import java.util.List;
import org.avaje.classpath.scanner.ClassFilter;
import org.avaje.classpath.scanner.ClassPathScanner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class BootupClassPathSearch {
    private static final Logger logger = LoggerFactory.getLogger(BootupClassPathSearch.class);
    private final List<String> packages;
    private final List<ClassPathScanner> scanners;

    public static BootupClasses search(ServerConfig serverConfig) {
        return new BootupClassPathSearch(serverConfig).getBootupClasses();
    }

    private BootupClassPathSearch(ServerConfig serverConfig) {
        this.packages = serverConfig.getPackages();
        this.scanners = ClassPathScanners.find(serverConfig);
    }

    private BootupClasses getBootupClasses() {
        try {
            BootupClasses bc = new BootupClasses();
            long st = System.currentTimeMillis();
            for (ClassPathScanner finder : this.scanners) {
                if (this.packages != null && this.packages.size() > 0) {
                    for (String packageName : this.packages) {
                        finder.scanForClasses(packageName, (ClassFilter)bc);
                    }
                    continue;
                }
                finder.scanForClasses("", (ClassFilter)bc);
            }
            long searchTime = System.currentTimeMillis() - st;
            logger.info("Classpath search entities[{}] searchTime [{}]", (Object)bc.getEntities().size(), (Object)searchTime);
            return bc;
        }
        catch (Exception ex) {
            throw new RuntimeException("Error in classpath search (looking for entities etc)", ex);
        }
    }
}

