/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.changelog;

import com.avaje.ebean.annotation.ChangeLog;
import com.avaje.ebean.annotation.ChangeLogInsertMode;
import com.avaje.ebean.event.BeanPersistRequest;
import com.avaje.ebean.event.changelog.ChangeLogFilter;
import com.avaje.ebean.event.changelog.ChangeLogRegister;
import java.util.HashSet;
import java.util.Set;

public class DefaultChangeLogRegister
implements ChangeLogRegister {
    private static final BasicFilter INCLUDE_INSERTS = new BasicFilter(true);
    private static final BasicFilter EXCLUDE_INSERTS = new BasicFilter(false);
    private final boolean defaultInsertsInclude;

    public DefaultChangeLogRegister(boolean defaultInsertsInclude) {
        this.defaultInsertsInclude = defaultInsertsInclude;
    }

    @Override
    public ChangeLogFilter getChangeFilter(Class<?> beanType) {
        ChangeLog changeLog = this.getChangeLog(beanType);
        if (changeLog == null) {
            return null;
        }
        String[] updatesThatInclude = changeLog.updatesThatInclude();
        if (updatesThatInclude.length == 0) {
            return this.insertModeInclude(changeLog.inserts()) ? INCLUDE_INSERTS : EXCLUDE_INSERTS;
        }
        HashSet<String> updateProps = new HashSet<String>();
        for (int i = 0; i < updatesThatInclude.length; ++i) {
            updateProps.add(updatesThatInclude[i]);
        }
        return new UpdateFilter(this.insertModeInclude(changeLog.inserts()), updateProps);
    }

    private ChangeLog getChangeLog(Class<?> beanType) {
        ChangeLog changeLog = beanType.getAnnotation(ChangeLog.class);
        if (changeLog != null) {
            return changeLog;
        }
        if (Object.class.equals(beanType.getSuperclass())) {
            return null;
        }
        return this.getChangeLog(beanType.getSuperclass());
    }

    private boolean insertModeInclude(ChangeLogInsertMode inserts) {
        if (inserts == ChangeLogInsertMode.DEFAULT) {
            return this.defaultInsertsInclude;
        }
        return ChangeLogInsertMode.INCLUDE == inserts;
    }

    protected static class UpdateFilter
    extends BasicFilter {
        final Set<String> updateProperties;

        UpdateFilter(boolean includeInserts, Set<String> updateProperties) {
            super(includeInserts);
            this.updateProperties = updateProperties;
        }

        @Override
        public boolean includeUpdate(BeanPersistRequest<?> updateRequest) {
            return updateRequest.hasDirtyProperty(this.updateProperties);
        }
    }

    protected static class BasicFilter
    implements ChangeLogFilter {
        final boolean includeInserts;

        BasicFilter(boolean includeInserts) {
            this.includeInserts = includeInserts;
        }

        @Override
        public boolean includeInsert(BeanPersistRequest<?> insertRequest) {
            return this.includeInserts;
        }

        @Override
        public boolean includeUpdate(BeanPersistRequest<?> updateRequest) {
            return true;
        }

        @Override
        public boolean includeDelete(BeanPersistRequest<?> deleteRequest) {
            return true;
        }
    }
}

