/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.server.autotune.service;

import com.avaje.ebeaninternal.server.autotune.model.Autotune;
import com.avaje.ebeaninternal.server.autotune.model.Origin;
import com.avaje.ebeaninternal.server.autotune.model.ProfileDiff;
import com.avaje.ebeaninternal.server.autotune.model.ProfileEmpty;
import com.avaje.ebeaninternal.server.autotune.model.ProfileNew;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public class SortAutoTuneDocument {
    private static final OriginNameKeySort NAME_KEY_SORT = new OriginNameKeySort();
    private static final OriginKeySort KEY_SORT = new OriginKeySort();

    public static void sort(Autotune document) {
        List<Origin> origins;
        ProfileEmpty profileEmpty;
        ProfileNew profileNew;
        ProfileDiff profileDiff = document.getProfileDiff();
        if (profileDiff != null) {
            Collections.sort(profileDiff.getOrigin(), NAME_KEY_SORT);
        }
        if ((profileNew = document.getProfileNew()) != null) {
            Collections.sort(profileNew.getOrigin(), NAME_KEY_SORT);
        }
        if ((profileEmpty = document.getProfileEmpty()) != null) {
            Collections.sort(profileEmpty.getOrigin(), KEY_SORT);
        }
        if (!(origins = document.getOrigin()).isEmpty()) {
            Collections.sort(origins, NAME_KEY_SORT);
        }
    }

    private static class OriginKeySort
    implements Comparator<Origin> {
        private OriginKeySort() {
        }

        @Override
        public int compare(Origin o1, Origin o2) {
            return o1.getKey().compareTo(o2.getKey());
        }
    }

    private static class OriginNameKeySort
    implements Comparator<Origin> {
        private OriginNameKeySort() {
        }

        @Override
        public int compare(Origin o1, Origin o2) {
            int comp = o1.getBeanType().compareTo(o2.getBeanType());
            if (comp == 0) {
                comp = o1.getKey().compareTo(o2.getKey());
            }
            return comp;
        }
    }
}

