/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.api;

import com.avaje.ebean.TxScope;
import com.avaje.ebean.config.PersistBatch;
import com.avaje.ebeaninternal.api.SpiTransaction;
import com.avaje.ebeaninternal.api.SpiTransactionScopeManager;
import java.util.ArrayList;

public class ScopeTrans
implements Thread.UncaughtExceptionHandler {
    private static final int OPCODE_ATHROW = 191;
    private final SpiTransactionScopeManager scopeMgr;
    private final SpiTransaction suspendedTransaction;
    private final SpiTransaction transaction;
    private final boolean rollbackOnChecked;
    private final boolean created;
    private final ArrayList<Class<? extends Throwable>> noRollbackFor;
    private final ArrayList<Class<? extends Throwable>> rollbackFor;
    private PersistBatch restoreBatch;
    private PersistBatch restoreBatchOnCascade;
    private int restoreBatchSize;
    private boolean rolledBack;

    public ScopeTrans(boolean rollbackOnChecked, boolean created, SpiTransaction transaction, TxScope txScope, SpiTransaction suspendedTransaction, SpiTransactionScopeManager scopeMgr) {
        this.rollbackOnChecked = rollbackOnChecked;
        this.created = created;
        this.transaction = transaction;
        this.suspendedTransaction = suspendedTransaction;
        this.scopeMgr = scopeMgr;
        this.noRollbackFor = txScope.getNoRollbackFor();
        this.rollbackFor = txScope.getRollbackFor();
        if (transaction != null) {
            if (!created && txScope.isBatchSet() || txScope.isBatchOnCascadeSet() || txScope.isBatchSizeSet()) {
                this.restoreBatch = transaction.getBatch();
                this.restoreBatchOnCascade = transaction.getBatchOnCascade();
                this.restoreBatchSize = transaction.getBatchSize();
            }
            if (txScope.isBatchSet()) {
                transaction.setBatch(txScope.getBatch());
            }
            if (txScope.isBatchOnCascadeSet()) {
                transaction.setBatchOnCascade(txScope.getBatchOnCascade());
            }
            if (txScope.isBatchSizeSet()) {
                transaction.setBatchSize(txScope.getBatchSize());
            }
        }
    }

    protected SpiTransaction getTransaction() {
        return this.transaction;
    }

    @Override
    public void uncaughtException(Thread thread, Throwable e) {
        this.caughtThrowable(e);
        this.onFinally();
    }

    public void onExit(Object returnOrThrowable, int opCode) {
        if (opCode == 191) {
            this.caughtThrowable((Throwable)returnOrThrowable);
        }
        this.onFinally();
    }

    public void onFinally() {
        try {
            if (!this.rolledBack) {
                this.commitTransaction();
            }
        }
        finally {
            this.restoreSuspended();
        }
    }

    protected void restoreSuspended() {
        if (this.suspendedTransaction != null) {
            this.scopeMgr.replace(this.suspendedTransaction);
        }
    }

    protected void commitTransaction() {
        if (this.created) {
            this.transaction.commit();
        } else {
            if (this.restoreBatch != null) {
                this.transaction.setBatch(this.restoreBatch);
            }
            if (this.restoreBatchOnCascade != null) {
                this.transaction.setBatchOnCascade(this.restoreBatchOnCascade);
            }
            if (this.restoreBatchSize > 0) {
                this.transaction.setBatchSize(this.restoreBatchSize);
            }
        }
    }

    public Error caughtError(Error e) {
        this.rollback(e);
        return e;
    }

    public <T extends Throwable> T caughtThrowable(T e) {
        if (this.isRollbackThrowable(e)) {
            this.rollback(e);
        }
        return e;
    }

    protected void rollback(Throwable e) {
        if (this.transaction != null && this.transaction.isActive()) {
            this.transaction.rollback(e);
        }
        this.rolledBack = true;
    }

    private boolean isRollbackThrowable(Throwable e) {
        int i;
        if (e instanceof Error) {
            return true;
        }
        if (this.noRollbackFor != null) {
            for (i = 0; i < this.noRollbackFor.size(); ++i) {
                if (!this.noRollbackFor.get(i).equals(e.getClass())) continue;
                return false;
            }
        }
        if (this.rollbackFor != null) {
            for (i = 0; i < this.rollbackFor.size(); ++i) {
                if (!this.rollbackFor.get(i).equals(e.getClass())) continue;
                return true;
            }
        }
        if (e instanceof RuntimeException) {
            return true;
        }
        return this.rollbackOnChecked;
    }
}

