/*
 * Decompiled with CFR 0.152.
 */
package com.avaje.ebeaninternal.api;

import com.avaje.ebean.bean.EntityBean;
import com.avaje.ebean.bean.EntityBeanIntercept;
import com.avaje.ebeaninternal.api.LoadBeanBuffer;
import com.avaje.ebeaninternal.api.LoadRequest;
import com.avaje.ebeaninternal.api.SpiQuery;
import com.avaje.ebeaninternal.server.core.OrmQueryRequest;
import com.avaje.ebeaninternal.server.deploy.BeanDescriptor;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class LoadBeanRequest
extends LoadRequest {
    private static final Logger logger = LoggerFactory.getLogger(LoadBeanRequest.class);
    private final List<EntityBeanIntercept> batch;
    private final LoadBeanBuffer loadBuffer;
    private final String lazyLoadProperty;
    private final boolean loadCache;

    public LoadBeanRequest(LoadBeanBuffer LoadBuffer2, String lazyLoadProperty, boolean loadCache) {
        this(LoadBuffer2, null, true, lazyLoadProperty, loadCache);
    }

    public LoadBeanRequest(LoadBeanBuffer LoadBuffer2, OrmQueryRequest<?> parentRequest) {
        this(LoadBuffer2, parentRequest, false, null, false);
    }

    private LoadBeanRequest(LoadBeanBuffer loadBuffer, OrmQueryRequest<?> parentRequest, boolean lazy, String lazyLoadProperty, boolean loadCache) {
        super(parentRequest, lazy);
        this.loadBuffer = loadBuffer;
        this.batch = loadBuffer.getBatch();
        this.lazyLoadProperty = lazyLoadProperty;
        this.loadCache = loadCache;
    }

    @Override
    public Class<?> getBeanType() {
        return this.loadBuffer.getBeanDescriptor().getBeanType();
    }

    public boolean isLoadCache() {
        return this.loadCache;
    }

    public String getDescription() {
        return "path:" + this.loadBuffer.getFullPath() + " batch:" + this.batch.size();
    }

    public List<EntityBeanIntercept> getBatch() {
        return this.batch;
    }

    public LoadBeanBuffer getLoadContext() {
        return this.loadBuffer;
    }

    public String getLazyLoadProperty() {
        return this.lazyLoadProperty;
    }

    public int getBatchSize() {
        return this.getLoadContext().getBatchSize();
    }

    public List<Object> getIdList(int batchSize) {
        int extraIds;
        ArrayList<Object> idList = new ArrayList<Object>(batchSize);
        BeanDescriptor<?> desc = this.loadBuffer.getBeanDescriptor();
        for (int i = 0; i < this.batch.size(); ++i) {
            EntityBeanIntercept ebi = this.batch.get(i);
            EntityBean bean = ebi.getOwner();
            idList.add(desc.getId(bean));
        }
        if (!idList.isEmpty() && (extraIds = batchSize - this.batch.size()) > 0) {
            Object firstId = idList.get(0);
            for (int i = 0; i < extraIds; ++i) {
                idList.add(firstId);
            }
        }
        return idList;
    }

    public void configureQuery(SpiQuery<?> query, List<Object> idList) {
        query.setMode(SpiQuery.Mode.LAZYLOAD_BEAN);
        query.setPersistenceContext(this.loadBuffer.getPersistenceContext());
        String mode = this.isLazy() ? "+lazy" : "+query";
        query.setLoadDescription(mode, this.getDescription());
        if (this.isLazy()) {
            query.setLazyLoadBatchSize(this.getBatchSize());
        }
        this.loadBuffer.configureQuery(query, this.lazyLoadProperty);
        if (idList.size() == 1) {
            query.where().idEq(idList.get(0));
        } else {
            query.where().idIn(idList);
        }
    }

    public void postLoad(List<?> list) {
        int i;
        HashSet<Object> loadedIds = new HashSet<Object>();
        BeanDescriptor<?> desc = this.loadBuffer.getBeanDescriptor();
        for (i = 0; i < list.size(); ++i) {
            EntityBean loadedBean = (EntityBean)list.get(i);
            loadedIds.add(desc.getId(loadedBean));
            if (!this.isLoadCache()) continue;
            desc.cacheBeanPutData(loadedBean);
        }
        if (this.lazyLoadProperty != null) {
            for (i = 0; i < this.batch.size(); ++i) {
                EntityBeanIntercept ebi = this.batch.get(i);
                Object id = desc.getId(ebi.getOwner());
                if (loadedIds.contains(id)) continue;
                logger.info("Lazy loading unsuccessful for type:" + desc.getName() + " id:" + id + " - expecting when bean has been deleted");
                ebi.setLazyLoadFailure(id);
            }
        }
    }
}

